/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactsBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResultsBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedLocalComponentsResult;

public class DefaultResolverResults
implements ResolverResults {
    private ResolvedConfiguration resolvedConfiguration;
    private ResolutionResult resolutionResult;
    private ResolveException fatalFailure;
    private ResolvedLocalComponentsResult resolvedLocalComponentsResult;
    private TransientConfigurationResultsBuilder transientConfigurationResultsBuilder;
    private ResolvedGraphResults graphResults;
    private ResolvedArtifactsBuilder artifactResults;

    @Override
    public boolean hasError() {
        if (this.fatalFailure != null) {
            return true;
        }
        return this.resolvedConfiguration != null && this.resolvedConfiguration.hasError();
    }

    @Override
    public ResolvedConfiguration getResolvedConfiguration() {
        this.assertHasArtifacts();
        return this.resolvedConfiguration;
    }

    @Override
    public ResolutionResult getResolutionResult() {
        this.assertHasResult();
        if (this.fatalFailure != null) {
            throw this.fatalFailure;
        }
        return this.resolutionResult;
    }

    @Override
    public ResolvedLocalComponentsResult getResolvedLocalComponents() {
        this.assertHasResult();
        if (this.fatalFailure != null) {
            throw this.fatalFailure;
        }
        return this.resolvedLocalComponentsResult;
    }

    private void assertHasResult() {
        if (this.resolutionResult == null && this.fatalFailure == null) {
            throw new IllegalStateException("Resolution result has not been attached.");
        }
    }

    private void assertHasArtifacts() {
        if (this.resolvedConfiguration == null) {
            throw new IllegalStateException("Resolution artifacts have not been attached.");
        }
    }

    @Override
    public void resolved(ResolutionResult resolutionResult, ResolvedLocalComponentsResult resolvedLocalComponentsResult) {
        this.resolutionResult = resolutionResult;
        this.resolvedLocalComponentsResult = resolvedLocalComponentsResult;
        this.fatalFailure = null;
    }

    @Override
    public void failed(ResolveException failure) {
        this.resolutionResult = null;
        this.fatalFailure = failure;
    }

    @Override
    public void withResolvedConfiguration(ResolvedConfiguration resolvedConfiguration) {
        this.resolvedConfiguration = resolvedConfiguration;
        this.graphResults = null;
        this.transientConfigurationResultsBuilder = null;
        this.artifactResults = null;
    }

    public void retainState(ResolvedGraphResults graphResults, ResolvedArtifactsBuilder artifactResults, TransientConfigurationResultsBuilder transientConfigurationResultsBuilder) {
        this.graphResults = graphResults;
        this.artifactResults = artifactResults;
        this.transientConfigurationResultsBuilder = transientConfigurationResultsBuilder;
    }

    public ResolvedGraphResults getGraphResults() {
        return this.graphResults;
    }

    public ResolvedArtifactResults getResolvedArtifacts() {
        return this.artifactResults.resolve();
    }

    public TransientConfigurationResultsBuilder getTransientConfigurationResultsBuilder() {
        return this.transientConfigurationResultsBuilder;
    }
}

