/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiPolyadicExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.NullableFunction;

public class PsiPolyadicExpressionImpl
extends ExpressionPsiElement
implements PsiPolyadicExpression {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiPolyadicExpressionImpl");
    private static final Function<PsiPolyadicExpressionImpl, PsiType> MY_TYPE_EVALUATOR = new NullableFunction<PsiPolyadicExpressionImpl, PsiType>(){

        @Override
        public PsiType fun(PsiPolyadicExpressionImpl expression) {
            return PsiPolyadicExpressionImpl.doGetType(expression);
        }
    };
    private static final TokenSet OUR_OPERATIONS_BIT_SET = TokenSet.create(JavaTokenType.OROR, JavaTokenType.ANDAND, JavaTokenType.OR, JavaTokenType.XOR, JavaTokenType.AND, JavaTokenType.EQEQ, JavaTokenType.NE, JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE, JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT, JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC);
    private volatile PsiExpression[] cachedOperands;

    public PsiPolyadicExpressionImpl() {
        super(JavaElementType.POLYADIC_EXPRESSION);
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        IElementType iElementType = ((PsiJavaToken)this.findChildByRoleAsPsiElement(63)).getTokenType();
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiPolyadicExpressionImpl", "getOperationTokenType"));
        }
        return iElementType;
    }

    @Override
    public PsiJavaToken getTokenBeforeOperand(@NotNull PsiExpression operand) {
        if (operand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiPolyadicExpressionImpl", "getTokenBeforeOperand"));
        }
        for (PsiElement element = operand; element != null; element = element.getPrevSibling()) {
            if (this.getChildRole(element.getNode()) != 63) continue;
            return (PsiJavaToken)element;
        }
        return null;
    }

    @Override
    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, MY_TYPE_EVALUATOR);
    }

    @Nullable
    private static PsiType doGetType(PsiPolyadicExpressionImpl param) {
        PsiExpression[] operands = param.getOperands();
        PsiType lType = null;
        IElementType sign = param.getOperationTokenType();
        for (int i = 1; i < operands.length; ++i) {
            PsiType rType = operands[i].getType();
            PsiType type2 = TypeConversionUtil.calcTypeForBinaryExpression(null, rType, sign, false);
            if (type2 != TypeConversionUtil.NULL_TYPE) {
                return type2;
            }
            if (lType == null) {
                lType = operands[0].getType();
            }
            lType = TypeConversionUtil.calcTypeForBinaryExpression(lType, rType, sign, true);
        }
        return lType;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 63: 
        }
        return this.findChildByType(OUR_OPERATIONS_BIT_SET);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        if (OUR_OPERATIONS_BIT_SET.contains(child.getElementType())) {
            return 63;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiPolyadicExpressionImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitPolyadicExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiExpression[] getOperands() {
        PsiExpression[] operands = this.cachedOperands;
        if (operands == null) {
            operands = (PsiExpression[])this.getChildrenAsPsiElements(ElementType.EXPRESSION_BIT_SET, PsiExpression.ARRAY_FACTORY);
            this.cachedOperands = operands;
        }
        if (operands == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiPolyadicExpressionImpl", "getOperands"));
        }
        return operands;
    }

    @Override
    public void clearCaches() {
        this.cachedOperands = null;
        super.clearCaches();
    }

    @Override
    public String toString() {
        return "PsiPolyadicExpression: " + this.getText();
    }
}

