/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.Deprecation;
import org.jetbrains.kotlin.resolve.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J$\u0010\u0006\u001a\u00020\u00072\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\rH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/DeprecatedCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "PROPERTY_SET_OPERATIONS", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "propertyGetterWorkaround", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "expression", "kotlin-compiler"})
public final class DeprecatedCallChecker
implements CallChecker {
    private static final TokenSet PROPERTY_SET_OPERATIONS;
    public static final DeprecatedCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, "resolvedCall.resultingDescriptor");
        this.check((CallableDescriptor)obj, context.getTrace(), reportOn);
    }

    private final void check(CallableDescriptor targetDescriptor, BindingTrace trace, PsiElement element) {
        Deprecation deprecation = DeprecationUtilKt.getDeprecation(targetDescriptor);
        if (targetDescriptor instanceof PropertySetterDescriptor && Intrinsics.areEqual(DeprecationUtilKt.getDeprecation(((PropertySetterDescriptor)targetDescriptor).getCorrespondingProperty()), deprecation)) {
            return;
        }
        if (deprecation != null) {
            trace.report(DeprecationUtilKt.createDeprecationDiagnostic(element, deprecation));
        } else if (targetDescriptor instanceof PropertyDescriptor) {
            this.propertyGetterWorkaround((PropertyDescriptor)targetDescriptor, trace, element);
        }
    }

    private final void propertyGetterWorkaround(PropertyDescriptor propertyDescriptor, BindingTrace trace, PsiElement expression) {
        block6: {
            KtUnaryExpression unaryExpression;
            KtExpression ktExpression;
            KtBinaryExpression binaryExpression = PsiTreeUtil.getParentOfType(expression, KtBinaryExpression.class);
            if (binaryExpression != null) {
                KtExpression left = binaryExpression.getLeft();
                if (Intrinsics.areEqual(left, expression) && PROPERTY_SET_OPERATIONS.contains(binaryExpression.getOperationToken())) {
                    return;
                }
                KtReferenceExpression[] referenceExpressions = (KtReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)left, KtReferenceExpression.class);
                if (referenceExpressions != null) {
                    for (int i = 0; i < referenceExpressions.length; ++i) {
                        KtReferenceExpression expr = referenceExpressions[i];
                        if (!Intrinsics.areEqual(expr, expression) || !PROPERTY_SET_OPERATIONS.contains(binaryExpression.getOperationToken())) continue;
                        return;
                    }
                }
            }
            if (PROPERTY_SET_OPERATIONS.contains((ktExpression = (unaryExpression = PsiTreeUtil.getParentOfType(expression, KtUnaryExpression.class))) != null && (ktExpression = ((KtUnaryExpression)ktExpression).getOperationReference()) != null ? ktExpression.getReferencedNameElementType() : null)) {
                return;
            }
            KtCallableReferenceExpression callableExpression = PsiTreeUtil.getParentOfType(expression, KtCallableReferenceExpression.class);
            if (callableExpression != null && Intrinsics.areEqual(callableExpression.getCallableReference(), expression)) {
                return;
            }
            PropertyGetterDescriptor propertyGetterDescriptor = propertyDescriptor.getGetter();
            if (propertyGetterDescriptor == null) break block6;
            PropertyGetterDescriptor propertyGetterDescriptor2 = propertyGetterDescriptor;
            PropertyGetterDescriptor it = propertyGetterDescriptor2;
            CallableDescriptor callableDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "it");
            INSTANCE.check(callableDescriptor, trace, expression);
        }
    }

    private DeprecatedCallChecker() {
        INSTANCE = this;
        PROPERTY_SET_OPERATIONS = TokenSet.create(KtTokens.EQ, KtTokens.PLUSEQ, KtTokens.MINUSEQ, KtTokens.MULTEQ, KtTokens.DIVEQ, KtTokens.PERCEQ, KtTokens.PLUSPLUS, KtTokens.MINUSMINUS);
    }

    static {
        new DeprecatedCallChecker();
    }
}

