#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: optparse-applicative
version: 0.12.1.0
id: optparse-applicative-0.12.1.0-4FckWvtE7Gp1EYdm7OVbJw
key: optparse-applicative-0.12.1.0-4FckWvtE7Gp1EYdm7OVbJw
license: BSD3
copyright: (c) 2012-2014 Paolo Capriotti <paolo@capriotti.io>
maintainer: paolo@capriotti.io
homepage: https://github.com/pcapriotti/optparse-applicative
synopsis: Utilities and combinators for parsing command line options
description:
    Here is a simple example of an applicative option parser:
    .
    @
    data Sample = Sample
    &#x20; &#x7b; hello :: String
    &#x20; , quiet :: Bool &#x7d;
    .
    sample :: Parser Sample
    sample = Sample
    &#x20; \<$\> strOption
    &#x20;     ( long \"hello\"
    &#x20;    \<\> metavar \"TARGET\"
    &#x20;    \<\> help \"Target for the greeting\" )
    &#x20; \<*\> switch
    &#x20;     ( long \"quiet\"
    &#x20;    \<\> help \"Whether to be quiet\" )
    @
    .
    The parser is built using applicative style starting from a set of basic
    combinators. In this example, @hello@ is defined as an '\''option'\'' with a
    @String@ argument, while @quiet@ is a boolean '\''flag'\'' (called '\''switch'\'').
    .
    A parser can be used like this:
    .
    @
    greet :: Sample -> IO ()
    greet (Sample h False) = putStrLn $ \"Hello, \" ++ h
    greet _ = return ()
    .
    main :: IO ()
    main = execParser opts \>\>= greet
    &#x20; where
    &#x20;   opts = info (helper \<*\> sample)
    &#x20;     ( fullDesc
    &#x20;    \<\> progDesc \"Print a greeting for TARGET\"
    &#x20;    \<\> header \"hello - a test for optparse-applicative\" )
    @
    .
    The @greet@ function is the entry point of the program, while @opts@ is a
    complete description of the program, used when generating a help text. The
    '\''helper'\'' combinator takes any parser, and adds a @help@ option to it (which
    always fails).
    .
    The @hello@ option in this example is mandatory (since it doesn'\''t have a
    default value), so running the program without any argument will display a
    help text:
    .
    >hello - a test for optparse-applicative
    >
    >Usage: hello --hello TARGET [--quiet]
    >  Print a greeting for TARGET
    >
    >Available options:
    >  -h,--help                Show this help text
    >  --hello TARGET           Target for the greeting
    >  --quiet                  Whether to be quiet
    .
    containing a short usage summary, and a detailed list of options with
    descriptions.
category: System
author: Paolo Capriotti
exposed: True
exposed-modules:
    Options.Applicative Options.Applicative.Arrows
    Options.Applicative.BashCompletion Options.Applicative.Builder
    Options.Applicative.Builder.Completer
    Options.Applicative.Builder.Internal Options.Applicative.Common
    Options.Applicative.Extra Options.Applicative.Help
    Options.Applicative.Help.Pretty Options.Applicative.Help.Chunk
    Options.Applicative.Help.Core Options.Applicative.Help.Types
    Options.Applicative.Types Options.Applicative.Internal
abi: af1ecdd2105eddb378bf58091fea8476
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/optparse-applicative-0.12.1.0
library-dirs: /usr/lib/ghc-8.0.1/site-local/optparse-applicative-0.12.1.0
data-dir: /usr/share/arm-linux-ghc-8.0.1/optparse-applicative-0.12.1.0
hs-libraries: HSoptparse-applicative-0.12.1.0-4FckWvtE7Gp1EYdm7OVbJw
depends:
    ansi-wl-pprint-0.6.7.3-BxXaXM4de7bF6SGXMvMtbC base-4.9.0.0
    process-1.4.2.0 transformers-0.5.2.0
    transformers-compat-0.5.1.4-81lZyuOJOvsD0zyCv2TKld
haddock-interfaces: /usr/share/doc/haskell-optparse-applicative0.12/html/optparse-applicative.haddock
haddock-html: /usr/share/doc/haskell-optparse-applicative0.12/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
