/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.unpack;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatErrorListener;
import org.jruby.truffle.core.format.LoopRecovery;
import org.jruby.truffle.core.format.pack.PackLexer;
import org.jruby.truffle.core.format.pack.PackParser;
import org.jruby.truffle.core.format.unpack.UnpackRootNode;
import org.jruby.truffle.core.format.unpack.UnpackTreeBuilder;
import org.jruby.truffle.language.RubyNode;

public class UnpackCompiler {
    private final RubyContext context;
    private final RubyNode currentNode;

    public UnpackCompiler(RubyContext context, RubyNode currentNode) {
        this.context = context;
        this.currentNode = currentNode;
    }

    public CallTarget compile(String format) {
        if (format.length() > this.context.getOptions().PACK_RECOVER_LOOP_MIN) {
            format = LoopRecovery.recoverLoop(format);
        }
        FormatErrorListener errorListener = new FormatErrorListener(this.context, this.currentNode);
        ANTLRInputStream input = new ANTLRInputStream(format);
        PackLexer lexer = new PackLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener(errorListener);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        PackParser parser = new PackParser(tokens);
        UnpackTreeBuilder builder = new UnpackTreeBuilder(this.context, this.currentNode);
        parser.addParseListener(builder);
        parser.removeErrorListeners();
        parser.addErrorListener(errorListener);
        parser.sequence();
        return Truffle.getRuntime().createCallTarget(new UnpackRootNode(this.context, this.currentNode.getEncapsulatingSourceSection(), builder.getNode()));
    }
}

