/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.extra;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.binding.BindingNodes;
import org.jruby.truffle.core.proc.ProcOperations;
import org.jruby.truffle.language.RubyGuards;

public class AttachmentsManager {
    private final RubyContext context;
    private final Instrumenter instrumenter;

    public AttachmentsManager(RubyContext context, Instrumenter instrumenter) {
        this.context = context;
        this.instrumenter = instrumenter;
    }

    public synchronized EventBinding<?> attach(String file, int line, DynamicObject block) {
        assert (RubyGuards.isRubyProc(block));
        Source source = this.context.getSourceCache().getBestSourceFuzzily(file);
        SourceSectionFilter filter = SourceSectionFilter.newBuilder().sourceIs(source).lineIs(line).tagIs(LineTag.class).build();
        return this.instrumenter.attachFactory(filter, eventContext -> new AttachmentEventNode(this.context, block));
    }

    private static class AttachmentEventNode
    extends ExecutionEventNode {
        private final RubyContext context;
        private final DynamicObject block;
        @Node.Child
        private DirectCallNode callNode;

        public AttachmentEventNode(RubyContext context, DynamicObject block) {
            this.context = context;
            this.block = block;
            this.callNode = Truffle.getRuntime().createDirectCallNode(Layouts.PROC.getCallTargetForType(block));
        }

        @Override
        public void onEnter(VirtualFrame frame) {
            this.callNode.call(frame, ProcOperations.packArguments(this.block, BindingNodes.createBinding(this.context, frame.materialize())));
        }
    }

    public class LineTag {
    }
}

