/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;

public class ForeignCodeNode
extends RubyNode {
    private final DynamicObject mimeType;
    private final DynamicObject code;
    private final DynamicObject name;
    @Node.Child
    private SnippetNode snippetNode = new SnippetNode();
    private static final Pattern NAME_PATTERN = Pattern.compile(".*function\\s+(\\w+)\\s*\\(.*", 32);

    public ForeignCodeNode(RubyContext context, String mimeType, String code) {
        Matcher matcher = NAME_PATTERN.matcher(code);
        matcher.find();
        String functionName = matcher.group(1);
        this.mimeType = StringOperations.createString(context, StringOperations.encodeRope(mimeType, (Encoding)UTF8Encoding.INSTANCE));
        this.code = StringOperations.createString(context, StringOperations.encodeRope(code + "\nInterop.export('" + functionName + "', " + functionName + ".bind(this));", (Encoding)UTF8Encoding.INSTANCE));
        this.name = context.getSymbolTable().getSymbol(functionName);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.snippetNode.execute(frame, "Truffle::Interop.eval mimeType, code; Truffle::Interop.import_method name", "mimeType", this.mimeType, "code", this.code, "name", this.name);
        return this.nil();
    }
}

