/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.objects.SingletonClassNode;
import org.jruby.truffle.language.objects.SingletonClassNodeGen;

public class GetDefaultDefineeNode
extends RubyNode {
    @Node.Child
    private SingletonClassNode singletonClassNode;

    public GetDefaultDefineeNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
    }

    @Override
    public DynamicObject execute(VirtualFrame frame) {
        InternalMethod method = RubyArguments.getMethod(frame);
        DynamicObject capturedDefaultDefinee = method.getCapturedDefaultDefinee();
        if (capturedDefaultDefinee != null) {
            return capturedDefaultDefinee;
        }
        Object self = RubyArguments.getSelf(frame);
        DeclarationContext declarationContext = RubyArguments.getDeclarationContext(frame);
        return declarationContext.getModuleToDefineMethods(self, method, this.getContext(), this.singletonClassNode);
    }
}

