/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.source.Source;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubySourceSection;
import org.jruby.truffle.language.control.BreakID;
import org.jruby.truffle.language.control.ReturnID;
import org.jruby.truffle.language.locals.LocalVariableType;
import org.jruby.truffle.language.locals.ReadDeclarationVariableNode;
import org.jruby.truffle.language.locals.ReadLocalVariableNode;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.parser.ParseEnvironment;
import org.jruby.truffle.parser.ReadLocalNode;
import org.jruby.truffle.parser.Translator;

public class TranslatorEnvironment {
    private final RubyContext context;
    private final ParseEnvironment parseEnvironment;
    private final FrameDescriptor frameDescriptor;
    private final List<FrameSlot> flipFlopStates = new ArrayList<FrameSlot>();
    private final ReturnID returnID;
    private final int blockDepth;
    private BreakID breakID;
    private final boolean ownScopeForAssignments;
    private final boolean neverAssignInParentScope;
    protected final TranslatorEnvironment parent;
    private boolean needsDeclarationFrame = false;
    private final SharedMethodInfo sharedMethodInfo;
    private final String namedMethodName;
    private static AtomicInteger tempIndex = new AtomicInteger();
    public boolean hasRestParameter = false;

    public TranslatorEnvironment(RubyContext context, TranslatorEnvironment parent, ParseEnvironment parseEnvironment, ReturnID returnID, boolean ownScopeForAssignments, boolean neverAssignInParentScope, SharedMethodInfo sharedMethodInfo, String namedMethodName, int blockDepth, BreakID breakID, FrameDescriptor frameDescriptor) {
        this.context = context;
        this.parent = parent;
        this.frameDescriptor = frameDescriptor;
        this.parseEnvironment = parseEnvironment;
        this.returnID = returnID;
        this.ownScopeForAssignments = ownScopeForAssignments;
        this.neverAssignInParentScope = neverAssignInParentScope;
        this.sharedMethodInfo = sharedMethodInfo;
        this.namedMethodName = namedMethodName;
        this.blockDepth = blockDepth;
        this.breakID = breakID;
    }

    public TranslatorEnvironment(RubyContext context, TranslatorEnvironment parent, ParseEnvironment parseEnvironment, ReturnID returnID, boolean ownScopeForAssignments, boolean neverAssignInParentScope, SharedMethodInfo methodIdentifier, String namedMethodName, int blockDepth, BreakID breakID) {
        this(context, parent, parseEnvironment, returnID, ownScopeForAssignments, neverAssignInParentScope, methodIdentifier, namedMethodName, blockDepth, breakID, new FrameDescriptor(context.getCoreLibrary().getNilObject()));
    }

    public LexicalScope getLexicalScope() {
        return this.parseEnvironment.getLexicalScope();
    }

    public LexicalScope pushLexicalScope() {
        return this.parseEnvironment.pushLexicalScope();
    }

    public void popLexicalScope() {
        this.parseEnvironment.popLexicalScope();
    }

    public TranslatorEnvironment getParent() {
        return this.parent;
    }

    public FrameSlot declareVar(String name) {
        return this.getFrameDescriptor().findOrAddFrameSlot(name);
    }

    public FrameSlot declareVarInMethodScope(String name) {
        if (this.isBlock()) {
            return this.parent.declareVarInMethodScope(name);
        }
        return this.declareVar(name);
    }

    public ReadLocalNode findOrAddLocalVarNodeDangerous(String name, Source source, RubySourceSection sourceSection) {
        ReadLocalNode localVar = this.findLocalVarNode(name, source, sourceSection);
        if (localVar == null) {
            this.declareVar(name);
            localVar = this.findLocalVarNode(name, source, sourceSection);
        }
        return localVar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadLocalNode findLocalVarNode(String name, Source source, RubySourceSection sourceSection) {
        TranslatorEnvironment current = this;
        int level = -1;
        try {
            do {
                ++level;
                FrameSlot slot = current.getFrameDescriptor().findFrameSlot(name);
                if (slot == null) continue;
                LocalVariableType type = Translator.FRAME_LOCAL_GLOBAL_VARIABLES.contains(name) ? (Translator.ALWAYS_DEFINED_GLOBALS.contains(name) ? LocalVariableType.ALWAYS_DEFINED_GLOBAL : LocalVariableType.FRAME_LOCAL_GLOBAL) : LocalVariableType.FRAME_LOCAL;
                if (level == 0) {
                    ReadLocalVariableNode readLocalVariableNode = new ReadLocalVariableNode(this.context, sourceSection.toSourceSection(source), type, slot);
                    return readLocalVariableNode;
                }
                ReadDeclarationVariableNode readDeclarationVariableNode = new ReadDeclarationVariableNode(this.context, sourceSection.toSourceSection(source), type, level, slot);
                return readDeclarationVariableNode;
            } while ((current = current.parent) != null);
        }
        finally {
            if (current != null) {
                current = this;
                while (level-- > 0) {
                    current.needsDeclarationFrame = true;
                    current = current.parent;
                }
            }
        }
        return null;
    }

    public void setNeedsDeclarationFrame() {
        this.needsDeclarationFrame = true;
    }

    public boolean needsDeclarationFrame() {
        return this.needsDeclarationFrame;
    }

    public FrameDescriptor getFrameDescriptor() {
        return this.frameDescriptor;
    }

    public String allocateLocalTemp(String indicator) {
        String name = "rubytruffle_temp_" + indicator + "_" + tempIndex.getAndIncrement();
        this.declareVar(name);
        return name;
    }

    public ReturnID getReturnID() {
        return this.returnID;
    }

    public ParseEnvironment getParseEnvironment() {
        return this.parseEnvironment;
    }

    public boolean hasOwnScopeForAssignments() {
        return this.ownScopeForAssignments;
    }

    public boolean getNeverAssignInParentScope() {
        return this.neverAssignInParentScope;
    }

    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }

    public List<FrameSlot> getFlipFlopStates() {
        return this.flipFlopStates;
    }

    public String getNamedMethodName() {
        return this.namedMethodName;
    }

    public boolean isBlock() {
        return this.blockDepth > 0;
    }

    public int getBlockDepth() {
        return this.blockDepth;
    }

    public BreakID getBreakID() {
        return this.breakID;
    }

    public void setBreakIDForWhile(BreakID breakID) {
        this.breakID = breakID;
    }
}

