/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jruby.ParseResult;
import org.jruby.truffle.parser.ast.InvisibleNode;
import org.jruby.truffle.parser.ast.NilImplicitParseNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.types.INameNode;
import org.jruby.truffle.parser.ast.visitor.AbstractNodeVisitor;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;
import org.jruby.truffle.parser.lexer.ISourcePositionHolder;

public abstract class ParseNode
implements ISourcePositionHolder,
ParseResult {
    static final List<ParseNode> EMPTY_LIST = new ArrayList<ParseNode>();
    private ISourcePosition position;
    protected boolean containsVariableAssignment;
    protected boolean newline;

    public ParseNode(ISourcePosition position, boolean containsAssignment) {
        this.position = position;
        this.containsVariableAssignment = containsAssignment;
    }

    public void setNewline() {
        this.newline = true;
    }

    public boolean isNewline() {
        return this.newline;
    }

    @Override
    public ISourcePosition getPosition() {
        return this.position;
    }

    public int getLine() {
        return this.position.getLine();
    }

    @Override
    public void setPosition(ISourcePosition position) {
        this.position = position;
    }

    public abstract <T> T accept(NodeVisitor<T> var1);

    public abstract List<ParseNode> childNodes();

    protected static List<ParseNode> createList(ParseNode node) {
        return Collections.singletonList(node);
    }

    protected static List<ParseNode> createList(ParseNode node1, ParseNode node2) {
        ArrayList<ParseNode> list = new ArrayList<ParseNode>(2);
        list.add(node1);
        list.add(node2);
        return list;
    }

    protected static List<ParseNode> createList(ParseNode node1, ParseNode node2, ParseNode node3) {
        ArrayList<ParseNode> list = new ArrayList<ParseNode>(3);
        list.add(node1);
        list.add(node2);
        list.add(node3);
        return list;
    }

    protected static List<ParseNode> createList(ParseNode ... nodes) {
        ArrayList<ParseNode> list = new ArrayList<ParseNode>(nodes.length);
        for (ParseNode node : nodes) {
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    public String toString() {
        return this.toString(false, 0);
    }

    public String toString(boolean indent, int indentation) {
        if (this instanceof InvisibleNode) {
            return "";
        }
        StringBuilder builder = new StringBuilder(60);
        if (indent) {
            ParseNode.indent(indentation, builder);
        }
        builder.append("(").append(this.getNodeName());
        String moreState = this.toStringInternal();
        if (moreState != null) {
            builder.append("[").append(moreState).append("]");
        }
        if (this instanceof INameNode) {
            builder.append(":").append(((INameNode)((Object)this)).getName());
        }
        builder.append(" ").append(this.getPosition().getLine());
        if (!this.childNodes().isEmpty() && indent) {
            builder.append("\n");
        }
        for (ParseNode child : this.childNodes()) {
            if (!indent) {
                builder.append(", ");
            }
            if (child == null) {
                if (indent) {
                    ParseNode.indent(indentation + 1, builder);
                }
                builder.append("null");
            } else if (indent && child instanceof NilImplicitParseNode) {
                ParseNode.indent(indentation + 1, builder);
                builder.append(child.getClass().getSimpleName());
            } else {
                builder.append(child.toString(indent, indentation + 1));
            }
            if (!indent) continue;
            builder.append("\n");
        }
        if (!this.childNodes().isEmpty() && indent) {
            ParseNode.indent(indentation, builder);
        }
        builder.append(")");
        return builder.toString();
    }

    protected String toStringInternal() {
        return null;
    }

    private static void indent(int indentation, StringBuilder builder) {
        for (int n = 0; n < indentation; ++n) {
            builder.append("  ");
        }
    }

    protected String getNodeName() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public <T extends ParseNode> T findFirstChild(final Class<T> nodeClass) {
        return (T)((ParseNode)this.accept(new AbstractNodeVisitor<T>(){

            @Override
            protected T defaultVisit(ParseNode node) {
                if (nodeClass.isAssignableFrom(node.getClass())) {
                    return node;
                }
                return (ParseNode)this.visitFirstChild(node);
            }
        }));
    }

    public abstract NodeType getNodeType();

    public boolean isNil() {
        return false;
    }

    public boolean needsDefinitionCheck() {
        return true;
    }

    public boolean containsVariableAssignment() {
        return this.containsVariableAssignment;
    }
}

