/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.languagemodel;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tools.StringTools;

public class LanguageModelTest {
    private static final int SKIP_FIRST_ITEMS = 5;
    private static final String FILE = "/lt/performance-test/en.txt";

    protected void testPerformance(LuceneLanguageModel model, int ngramLength) throws Exception {
        try (FileInputStream fis = new FileInputStream(FILE);){
            String content = StringTools.readStream((InputStream)fis, (String)"UTF-8");
            WordTokenizer wordTokenizer = new WordTokenizer();
            List words = wordTokenizer.tokenize(content);
            String prevPrevWord = null;
            String prevWord = null;
            int i = 0;
            long totalMicros = 0L;
            for (String word : words) {
                if (word.trim().isEmpty()) continue;
                if (prevWord != null) {
                    long t1 = System.nanoTime() / 1000L;
                    long count = 0L;
                    if (ngramLength == 2) {
                        count = model.getCount(Arrays.asList(prevWord, word));
                    } else if (ngramLength == 3) {
                        if (prevPrevWord != null) {
                            count = model.getCount(Arrays.asList(prevPrevWord, prevWord, word));
                        }
                    } else {
                        throw new IllegalArgumentException("ngram length not supported: " + ngramLength);
                    }
                    long timeMicros = System.nanoTime() / 1000L - t1;
                    long timeMillis = timeMicros / 1000L;
                    if (ngramLength == 2) {
                        System.out.println(count + "\t\t" + prevWord + " " + word + ": " + timeMicros + "\u00b5s = " + timeMillis + "ms");
                    } else if (ngramLength == 3) {
                        System.out.println(count + "\t\t" + prevPrevWord + " " + prevWord + " " + word + ": " + timeMicros + "\u00b5s = " + timeMillis + "ms");
                    }
                    if (i > 5) {
                        totalMicros += timeMicros;
                    }
                    if (++i % 25 == 0) {
                        this.printStats(i, totalMicros);
                    }
                }
                prevPrevWord = prevWord;
                prevWord = word;
            }
            this.printStats(i, totalMicros);
        }
    }

    private void printStats(int i, long totalMicros) {
        long averageMicros = totalMicros / (long)i;
        System.out.println("*** Average: " + averageMicros + "\u00b5s = " + averageMicros / 1000L + "ms");
    }
}

