/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.ParseFieldRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class AggregatorParsers {
    public static final Pattern VALID_AGG_NAME = Pattern.compile("[^\\[\\]>]+");
    private final ParseFieldRegistry<Aggregator.Parser> aggregationParserRegistry;
    private final ParseFieldRegistry<PipelineAggregator.Parser> pipelineAggregationParserRegistry;

    public AggregatorParsers(ParseFieldRegistry<Aggregator.Parser> aggregationParserRegistry, ParseFieldRegistry<PipelineAggregator.Parser> pipelineAggregationParserRegistry) {
        this.aggregationParserRegistry = aggregationParserRegistry;
        this.pipelineAggregationParserRegistry = pipelineAggregationParserRegistry;
    }

    public Aggregator.Parser parser(String type, ParseFieldMatcher parseFieldMatcher) {
        return this.aggregationParserRegistry.lookupReturningNullIfNotFound(type, parseFieldMatcher);
    }

    public PipelineAggregator.Parser pipelineParser(String type, ParseFieldMatcher parseFieldMatcher) {
        return this.pipelineAggregationParserRegistry.lookupReturningNullIfNotFound(type, parseFieldMatcher);
    }

    public AggregatorFactories.Builder parseAggregators(QueryParseContext parseContext) throws IOException {
        return this.parseAggregators(parseContext, 0);
    }

    private AggregatorFactories.Builder parseAggregators(QueryParseContext parseContext, int level) throws IOException {
        Matcher validAggMatcher = VALID_AGG_NAME.matcher("");
        AggregatorFactories.Builder factories = new AggregatorFactories.Builder();
        XContentParser.Token token = null;
        XContentParser parser = parseContext.parser();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)token) + " in [aggs]: aggregations definitions must start with the name of the aggregation.", new Object[0]);
            }
            String aggregationName = parser.currentName();
            if (!validAggMatcher.reset(aggregationName).matches()) {
                throw new ParsingException(parser.getTokenLocation(), "Invalid aggregation name [" + aggregationName + "]. Aggregation names must be alpha-numeric and can only contain '_' and '-'", new Object[0]);
            }
            token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "Aggregation definition for [" + aggregationName + " starts with a [" + (Object)((Object)token) + "], expected a [" + (Object)((Object)XContentParser.Token.START_OBJECT) + "].", new Object[0]);
            }
            AggregationBuilder aggFactory = null;
            PipelineAggregationBuilder pipelineAggregatorFactory = null;
            AggregatorFactories.Builder subFactories = null;
            Map<String, Object> metaData = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) {
                    throw new ParsingException(parser.getTokenLocation(), "Expected [" + (Object)((Object)XContentParser.Token.FIELD_NAME) + "] under a [" + (Object)((Object)XContentParser.Token.START_OBJECT) + "], but got a [" + (Object)((Object)token) + "] in [" + aggregationName + "]", parser.getTokenLocation());
                }
                String fieldName = parser.currentName();
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    switch (fieldName) {
                        case "meta": {
                            metaData = parser.map();
                            break;
                        }
                        case "aggregations": 
                        case "aggs": {
                            if (subFactories != null) {
                                throw new ParsingException(parser.getTokenLocation(), "Found two sub aggregation definitions under [" + aggregationName + "]", new Object[0]);
                            }
                            subFactories = this.parseAggregators(parseContext, level + 1);
                            break;
                        }
                        default: {
                            if (aggFactory != null) {
                                throw new ParsingException(parser.getTokenLocation(), "Found two aggregation type definitions in [" + aggregationName + "]: [" + aggFactory.type + "] and [" + fieldName + "]", new Object[0]);
                            }
                            if (pipelineAggregatorFactory != null) {
                                throw new ParsingException(parser.getTokenLocation(), "Found two aggregation type definitions in [" + aggregationName + "]: [" + pipelineAggregatorFactory + "] and [" + fieldName + "]", new Object[0]);
                            }
                            Aggregator.Parser aggregatorParser = this.parser(fieldName, parseContext.getParseFieldMatcher());
                            if (aggregatorParser == null) {
                                PipelineAggregator.Parser pipelineAggregatorParser = this.pipelineParser(fieldName, parseContext.getParseFieldMatcher());
                                if (pipelineAggregatorParser == null) {
                                    throw new ParsingException(parser.getTokenLocation(), "Could not find aggregator type [" + fieldName + "] in [" + aggregationName + "]", new Object[0]);
                                }
                                pipelineAggregatorFactory = pipelineAggregatorParser.parse(aggregationName, parseContext);
                                break;
                            }
                            aggFactory = aggregatorParser.parse(aggregationName, parseContext);
                            break;
                        }
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Expected [" + (Object)((Object)XContentParser.Token.START_OBJECT) + "] under [" + fieldName + "], but got a [" + (Object)((Object)token) + "] in [" + aggregationName + "]", new Object[0]);
            }
            if (aggFactory == null && pipelineAggregatorFactory == null) {
                throw new ParsingException(parser.getTokenLocation(), "Missing definition for aggregation [" + aggregationName + "]", parser.getTokenLocation());
            }
            if (aggFactory != null) {
                assert (pipelineAggregatorFactory == null);
                if (metaData != null) {
                    aggFactory.setMetaData(metaData);
                }
                if (subFactories != null) {
                    aggFactory.subAggregations(subFactories);
                }
                factories.addAggregator(aggFactory);
                continue;
            }
            assert (pipelineAggregatorFactory != null);
            if (subFactories != null) {
                throw new ParsingException(parser.getTokenLocation(), "Aggregation [" + aggregationName + "] cannot define sub-aggregations", parser.getTokenLocation());
            }
            if (metaData != null) {
                pipelineAggregatorFactory.setMetaData(metaData);
            }
            factories.addPipelineAggregator(pipelineAggregatorFactory);
        }
        return factories;
    }
}

