/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicBuilder;
import org.elasticsearch.search.aggregations.support.XContentParseContext;

public class JLHScore
extends SignificanceHeuristic {
    public static final String NAME = "jlh";

    public JLHScore() {
    }

    public JLHScore(StreamInput in) {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        double supersetProbability;
        double subsetProbability;
        double absoluteProbabilityChange;
        this.checkFrequencyValidity(subsetFreq, subsetSize, supersetFreq, supersetSize, "JLHScore");
        if (subsetSize == 0L || supersetSize == 0L) {
            return 0.0;
        }
        if (supersetFreq == 0L) {
            supersetFreq = 1L;
        }
        if ((absoluteProbabilityChange = (subsetProbability = (double)subsetFreq / (double)subsetSize) - (supersetProbability = (double)supersetFreq / (double)supersetSize)) <= 0.0) {
            return 0.0;
        }
        double relativeProbabilityChange = subsetProbability / supersetProbability;
        return absoluteProbabilityChange * relativeProbabilityChange;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME).endObject();
        return builder;
    }

    public static SignificanceHeuristic parse(XContentParseContext context) throws IOException, QueryShardException {
        XContentParser parser = context.getParser();
        if (!parser.nextToken().equals((Object)XContentParser.Token.END_OBJECT)) {
            throw new ElasticsearchParseException("failed to parse [jlh] significance heuristic. expected an empty object, but found [{}] instead", new Object[]{parser.currentToken()});
        }
        return new JLHScore();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class JLHScoreBuilder
    implements SignificanceHeuristicBuilder {
        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(JLHScore.NAME).endObject();
            return builder;
        }
    }
}

