/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AbstractValuesSourceParser;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.aggregations.support.XContentParseContext;

public abstract class AbstractTermsParser
extends AbstractValuesSourceParser.AnyValuesSourceParser {
    public static final ParseField EXECUTION_HINT_FIELD_NAME = new ParseField("execution_hint", new String[0]);
    public static final ParseField SHARD_SIZE_FIELD_NAME = new ParseField("shard_size", new String[0]);
    public static final ParseField MIN_DOC_COUNT_FIELD_NAME = new ParseField("min_doc_count", new String[0]);
    public static final ParseField SHARD_MIN_DOC_COUNT_FIELD_NAME = new ParseField("shard_min_doc_count", new String[0]);
    public static final ParseField REQUIRED_SIZE_FIELD_NAME = new ParseField("size", new String[0]);
    public IncludeExclude.Parser incExcParser = new IncludeExclude.Parser();

    protected AbstractTermsParser() {
        super(true, true);
    }

    @Override
    protected final ValuesSourceAggregationBuilder<ValuesSource, ?> createFactory(String aggregationName, ValuesSourceType valuesSourceType, ValueType targetValueType, Map<ParseField, Object> otherOptions) {
        Long shardMinDocCount;
        Long minDocCount;
        Integer shardSize;
        TermsAggregator.BucketCountThresholds bucketCountThresholds = this.getDefaultBucketCountThresholds();
        Integer requiredSize = (Integer)otherOptions.get(REQUIRED_SIZE_FIELD_NAME);
        if (requiredSize != null && requiredSize != -1) {
            bucketCountThresholds.setRequiredSize(requiredSize);
        }
        if ((shardSize = (Integer)otherOptions.get(SHARD_SIZE_FIELD_NAME)) != null && shardSize != -1) {
            bucketCountThresholds.setShardSize(shardSize);
        }
        if ((minDocCount = (Long)otherOptions.get(MIN_DOC_COUNT_FIELD_NAME)) != null && minDocCount != -1L) {
            bucketCountThresholds.setMinDocCount(minDocCount);
        }
        if ((shardMinDocCount = (Long)otherOptions.get(SHARD_MIN_DOC_COUNT_FIELD_NAME)) != null && shardMinDocCount != -1L) {
            bucketCountThresholds.setShardMinDocCount(shardMinDocCount);
        }
        Aggregator.SubAggCollectionMode collectMode = (Aggregator.SubAggCollectionMode)otherOptions.get(Aggregator.SubAggCollectionMode.KEY);
        String executionHint = (String)otherOptions.get(EXECUTION_HINT_FIELD_NAME);
        IncludeExclude incExc = this.incExcParser.createIncludeExclude(otherOptions);
        return this.doCreateFactory(aggregationName, valuesSourceType, targetValueType, bucketCountThresholds, collectMode, executionHint, incExc, otherOptions);
    }

    protected abstract ValuesSourceAggregationBuilder<ValuesSource, ?> doCreateFactory(String var1, ValuesSourceType var2, ValueType var3, TermsAggregator.BucketCountThresholds var4, Aggregator.SubAggCollectionMode var5, String var6, IncludeExclude var7, Map<ParseField, Object> var8);

    @Override
    protected boolean token(String aggregationName, String currentFieldName, XContentParser.Token token, XContentParseContext context, Map<ParseField, Object> otherOptions) throws IOException {
        XContentParser parser = context.getParser();
        if (this.incExcParser.token(currentFieldName, token, parser, context.getParseFieldMatcher(), otherOptions)) {
            return true;
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            if (context.matchField(currentFieldName, EXECUTION_HINT_FIELD_NAME)) {
                otherOptions.put(EXECUTION_HINT_FIELD_NAME, parser.text());
                return true;
            }
            if (context.matchField(currentFieldName, Aggregator.SubAggCollectionMode.KEY)) {
                otherOptions.put(Aggregator.SubAggCollectionMode.KEY, Aggregator.SubAggCollectionMode.parse(parser.text(), context.getParseFieldMatcher()));
                return true;
            }
            if (context.matchField(currentFieldName, REQUIRED_SIZE_FIELD_NAME)) {
                otherOptions.put(REQUIRED_SIZE_FIELD_NAME, parser.intValue());
                return true;
            }
            if (this.parseSpecial(aggregationName, context, token, currentFieldName, otherOptions)) {
                return true;
            }
        } else if (token == XContentParser.Token.VALUE_NUMBER) {
            if (context.matchField(currentFieldName, REQUIRED_SIZE_FIELD_NAME)) {
                otherOptions.put(REQUIRED_SIZE_FIELD_NAME, parser.intValue());
                return true;
            }
            if (context.matchField(currentFieldName, SHARD_SIZE_FIELD_NAME)) {
                otherOptions.put(SHARD_SIZE_FIELD_NAME, parser.intValue());
                return true;
            }
            if (context.matchField(currentFieldName, MIN_DOC_COUNT_FIELD_NAME)) {
                otherOptions.put(MIN_DOC_COUNT_FIELD_NAME, parser.longValue());
                return true;
            }
            if (context.matchField(currentFieldName, SHARD_MIN_DOC_COUNT_FIELD_NAME)) {
                otherOptions.put(SHARD_MIN_DOC_COUNT_FIELD_NAME, parser.longValue());
                return true;
            }
            if (this.parseSpecial(aggregationName, context, token, currentFieldName, otherOptions)) {
                return true;
            }
        } else if (this.parseSpecial(aggregationName, context, token, currentFieldName, otherOptions)) {
            return true;
        }
        return false;
    }

    public abstract boolean parseSpecial(String var1, XContentParseContext var2, XContentParser.Token var3, String var4, Map<ParseField, Object> var5) throws IOException;

    protected abstract TermsAggregator.BucketCountThresholds getDefaultBucketCountThresholds();
}

