/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class RenameProcessor
extends AbstractProcessor {
    public static final String TYPE = "rename";
    private final String field;
    private final String targetField;
    private final boolean ignoreMissing;

    RenameProcessor(String tag, String field, String targetField, boolean ignoreMissing) {
        super(tag);
        this.field = field;
        this.targetField = targetField;
        this.ignoreMissing = ignoreMissing;
    }

    String getField() {
        return this.field;
    }

    String getTargetField() {
        return this.targetField;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public void execute(IngestDocument document) {
        if (!document.hasField(this.field, true)) {
            if (this.ignoreMissing) {
                return;
            }
            throw new IllegalArgumentException("field [" + this.field + "] doesn't exist");
        }
        if (document.hasField(this.targetField, true)) {
            throw new IllegalArgumentException("field [" + this.targetField + "] already exists");
        }
        Object value = document.getFieldValue(this.field, Object.class);
        document.removeField(this.field);
        try {
            document.setFieldValue(this.targetField, value);
        }
        catch (Exception e) {
            document.setFieldValue(this.field, value);
            throw e;
        }
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public RenameProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)RenameProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)RenameProcessor.TYPE, (String)processorTag, config, (String)"target_field");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)RenameProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            return new RenameProcessor(processorTag, field, targetField, ignoreMissing);
        }
    }
}

