/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.ModeController;
import freemind.view.mindmapview.EditNodeBase;
import freemind.view.mindmapview.NodeView;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileWriter;
import java.text.MessageFormat;
import javax.swing.JFrame;

public class EditNodeExternalApplication
extends EditNodeBase {
    private KeyEvent firstEvent;
    private boolean lastEditingWasSuccessful;

    public EditNodeExternalApplication(NodeView node, String text, KeyEvent firstEvent, ModeController controller, EditNodeBase.EditControl editControl) {
        super(node, text, controller, editControl);
        this.firstEvent = firstEvent;
    }

    public void show() {
        JFrame mainWindow = (JFrame)((Object)this.getFrame());
        this.lastEditingWasSuccessful = false;
        new Thread(){

            @Override
            public void run() {
                FileWriter writer = null;
                try {
                    File temporaryFile = File.createTempFile("tmm", ".html");
                    writer = new FileWriter(temporaryFile);
                    writer.write(EditNodeExternalApplication.this.text);
                    writer.close();
                    String htmlEditingCommand = EditNodeExternalApplication.this.getFrame().getProperty("html_editing_command");
                    String expandedHtmlEditingCommand = new MessageFormat(htmlEditingCommand).format(new String[]{temporaryFile.toString()});
                    Process htmlEditorProcess = Runtime.getRuntime().exec(expandedHtmlEditingCommand);
                    int result = htmlEditorProcess.waitFor();
                    String content = Tools.getFile(temporaryFile);
                    if (content == null) {
                        EditNodeExternalApplication.this.getEditControl().cancel();
                    }
                    EditNodeExternalApplication.this.getEditControl().ok(content);
                    EditNodeExternalApplication.this.lastEditingWasSuccessful = true;
                }
                catch (Exception e) {
                    Resources.getInstance().logException(e);
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }.start();
    }

    protected KeyEvent getFirstEvent() {
        return this.firstEvent;
    }
}

