/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.Namer;
import org.gradle.api.Rule;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.tasks.DefaultTaskCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealizableTaskCollection<T extends Task>
implements TaskCollection<T> {
    private final TaskCollection<T> delegate;
    private final Class<T> type;
    private final AtomicBoolean realized = new AtomicBoolean(false);
    private final MutableModelNode modelNode;

    public RealizableTaskCollection(Class<T> type, TaskCollection<T> delegate, MutableModelNode modelNode) {
        assert (!(delegate instanceof RealizableTaskCollection)) : "Attempt to wrap already realizable task collection in realizable wrapper: " + delegate;
        this.delegate = delegate;
        this.type = type;
        this.modelNode = modelNode;
    }

    public void realizeRuleTaskTypes() {
        if (this.realized.compareAndSet(false, true)) {
            this.modelNode.ensureAtLeast(ModelNode.State.SelfClosed);
            for (MutableModelNode node : this.modelNode.getLinks(ModelType.of(this.type))) {
                node.ensureAtLeast(ModelNode.State.GraphClosed);
            }
        }
    }

    private <S extends T> RealizableTaskCollection<S> realizable(Class<S> type, TaskCollection<S> collection) {
        return new RealizableTaskCollection<S>(type, collection, this.modelNode);
    }

    @Override
    public TaskCollection<T> matching(Spec<? super T> spec) {
        return this.realizable(this.type, this.delegate.matching(spec));
    }

    @Override
    public TaskCollection<T> matching(Closure closure) {
        return this.realizable(this.type, this.delegate.matching(closure));
    }

    @Override
    public T getByName(String name, Closure configureClosure) throws UnknownTaskException {
        return this.delegate.getByName(name, configureClosure);
    }

    @Override
    public T getByName(String name, Action<? super T> configureAction) throws UnknownTaskException {
        return (T)((Task)this.delegate.getByName(name, configureAction));
    }

    @Override
    public T getByName(String name) throws UnknownTaskException {
        return this.delegate.getByName(name);
    }

    @Override
    public <S extends T> TaskCollection<S> withType(Class<S> type) {
        return this.realizable(type, this.delegate.withType(type));
    }

    @Override
    public Action<? super T> whenTaskAdded(Action<? super T> action) {
        return this.delegate.whenTaskAdded(action);
    }

    @Override
    public void whenTaskAdded(Closure closure) {
        this.delegate.whenTaskAdded(closure);
    }

    @Override
    public T getAt(String name) throws UnknownTaskException {
        return this.delegate.getAt(name);
    }

    @Override
    public Set<T> findAll(Closure spec) {
        return this.delegate.findAll(spec);
    }

    @Override
    public boolean add(T e) {
        return this.delegate.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public Namer<T> getNamer() {
        return this.delegate.getNamer();
    }

    @Override
    public SortedMap<String, T> getAsMap() {
        return this.delegate.getAsMap();
    }

    @Override
    public SortedSet<String> getNames() {
        return this.delegate.getNames();
    }

    @Override
    public T findByName(String name) {
        return (T)((Task)this.delegate.findByName(name));
    }

    @Override
    public Rule addRule(Rule rule) {
        return this.delegate.addRule(rule);
    }

    @Override
    public Rule addRule(String description, Closure ruleAction) {
        return this.delegate.addRule(description, ruleAction);
    }

    @Override
    public List<Rule> getRules() {
        return this.delegate.getRules();
    }

    @Override
    public <S extends T> DomainObjectCollection<S> withType(Class<S> type, Action<? super S> configureAction) {
        return this.realizable(type, (DefaultTaskCollection)this.delegate.withType(type, configureAction));
    }

    @Override
    public <S extends T> DomainObjectCollection<S> withType(Class<S> type, Closure configureClosure) {
        return this.realizable(type, (DefaultTaskCollection)this.delegate.withType(type, configureClosure));
    }

    @Override
    public Action<? super T> whenObjectAdded(Action<? super T> action) {
        return this.delegate.whenObjectAdded(action);
    }

    @Override
    public void whenObjectAdded(Closure action) {
        this.delegate.whenObjectAdded(action);
    }

    @Override
    public Action<? super T> whenObjectRemoved(Action<? super T> action) {
        return this.delegate.whenObjectRemoved(action);
    }

    @Override
    public void whenObjectRemoved(Closure action) {
        this.delegate.whenObjectRemoved(action);
    }

    @Override
    public void all(Action<? super T> action) {
        this.delegate.all(action);
    }

    @Override
    public void all(Closure action) {
        this.delegate.all(action);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <R> R[] toArray(R[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }
}

