/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.functions.BuiltInFictitiousFunctionClassFactory;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FunctionTypesKt {
    public static final boolean isFunctionTypeOrSubtype(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FunctionTypesKt.isFunctionType($receiver) || (Boolean)DFS.dfsFromNode($receiver, isFunctionTypeOrSubtype.1.INSTANCE, new DFS.VisitedWithSet(), new DFS.AbstractNodeHandler<KotlinType, Boolean>(){
            private boolean result;

            public boolean beforeChildren(@NotNull KotlinType current) {
                Intrinsics.checkParameterIsNotNull(current, "current");
                if (FunctionTypesKt.isFunctionType(current)) {
                    this.result = true;
                }
                return !this.result;
            }

            @NotNull
            public Boolean result() {
                return this.result;
            }
        }) != false;
    }

    public static final boolean isFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor descriptor2 = $receiver.getConstructor().getDeclarationDescriptor();
        return descriptor2 != null && FunctionTypesKt.isNumberedFunctionClassFqName(DescriptorUtilsKt.getFqNameUnsafe(descriptor2));
    }

    public static final boolean isNonExtensionFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FunctionTypesKt.isFunctionType($receiver) && !FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($receiver);
    }

    public static final boolean isExtensionFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FunctionTypesKt.isFunctionType($receiver) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($receiver);
    }

    private static final boolean isTypeAnnotatedWithExtensionFunctionType(@NotNull KotlinType $receiver) {
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.extensionFunctionType;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.extensionFunctionType");
        return annotations2.findAnnotation(fqName2) != null;
    }

    public static final boolean isNumberedFunctionClassFqName(@NotNull FqNameUnsafe fqName2) {
        String shortName;
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        List<Name> segments = fqName2.pathSegments();
        if (segments.size() != 2) {
            return false;
        }
        if (Intrinsics.areEqual(KotlinBuiltIns.BUILT_INS_PACKAGE_NAME, CollectionsKt.first(segments)) ^ true) {
            return false;
        }
        String string = shortName = CollectionsKt.last(segments).asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "shortName");
        FqName fqName3 = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME");
        return BuiltInFictitiousFunctionClassFactory.Companion.isFunctionClassName(string, fqName3);
    }

    @Nullable
    public static final KotlinType getReceiverTypeFromFunctionType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean bl = FunctionTypesKt.isFunctionType(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not a function type: " + type2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType(type2) ? CollectionsKt.first(type2.getArguments()).getType() : (KotlinType)null;
    }

    @NotNull
    public static final KotlinType getReturnTypeFromFunctionType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean bl = FunctionTypesKt.isFunctionType(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not a function type: " + type2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinType kotlinType = CollectionsKt.last(type2.getArguments()).getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "type.arguments.last().type");
        return kotlinType;
    }

    @NotNull
    public static final List<TypeProjection> getValueParameterTypesFromFunctionType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean bl = FunctionTypesKt.isFunctionType(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not a function type: " + type2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List<TypeProjection> arguments = type2.getArguments();
        int first = FunctionTypesKt.isExtensionFunctionType(type2) ? 1 : 0;
        int last = arguments.size() - 1;
        boolean bl2 = first <= last;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Not an exact function type: " + type2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return arguments.subList(first, last);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> getFunctionTypeArgumentProjections(@Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> parameterTypes, @NotNull KotlinType returnType2) {
        void $receiver$iv;
        Object object;
        Intrinsics.checkParameterIsNotNull(parameterTypes, "parameterTypes");
        Intrinsics.checkParameterIsNotNull(returnType2, "returnType");
        getFunctionTypeArgumentProjections.1 defaultProjection$ = getFunctionTypeArgumentProjections.1.INSTANCE;
        ArrayList<TypeProjectionImpl> arguments = new ArrayList<TypeProjectionImpl>(parameterTypes.size() + (receiverType != null ? 1 : 0) + 1);
        KotlinType kotlinType = receiverType;
        if (kotlinType != null) {
            object = kotlinType;
            KotlinType it = object;
            arguments.add(getFunctionTypeArgumentProjections.1.INSTANCE.invoke(it));
        }
        object = parameterTypes;
        for (Object item$iv : $receiver$iv) {
            void p1;
            KotlinType kotlinType2 = (KotlinType)item$iv;
            Collection collection = arguments;
            TypeProjectionImpl typeProjectionImpl = getFunctionTypeArgumentProjections.1.INSTANCE.invoke((KotlinType)p1);
            collection.add(typeProjectionImpl);
        }
        arguments.add(defaultProjection$.invoke(returnType2));
        return arguments;
    }
}

