/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.augment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;

public abstract class PsiAugmentProvider {
    private static final Logger LOG = Logger.getInstance("#" + PsiAugmentProvider.class.getName());
    public static final ExtensionPointName<PsiAugmentProvider> EP_NAME = ExtensionPointName.create("org.jetbrains.kotlin.com.intellij.lang.psiAugmentProvider");

    @NotNull
    public abstract <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement var1, @NotNull Class<Psi> var2);

    @NotNull
    public static <Psi extends PsiElement> List<Psi> collectAugments(@NotNull PsiElement element, @NotNull Class<Psi> type2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        List result2 = Collections.emptyList();
        for (PsiAugmentProvider provider : DumbService.getInstance(element.getProject()).filterByDumbAwareness(Extensions.getExtensions(EP_NAME))) {
            List<Psi> augments = provider.getAugments(element, type2);
            if (augments.isEmpty()) continue;
            if (result2.isEmpty()) {
                result2 = new ArrayList(augments.size());
            }
            result2.addAll(augments);
        }
        List list2 = result2;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        return list2;
    }

    @Nullable
    protected PsiType inferType(PsiTypeElement typeElement) {
        return null;
    }

    @Nullable
    public static PsiType getInferredType(PsiTypeElement typeElement) {
        for (PsiAugmentProvider provider : Extensions.getExtensions(EP_NAME)) {
            try {
                PsiType type2 = provider.inferType(typeElement);
                if (type2 == null) continue;
                return type2;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("provider: " + provider, e);
            }
        }
        return null;
    }
}

