/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.textarea.Anchor;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

class FirstLine
extends Anchor {
    private int skew;
    private int preContentRemovedNumLines;

    FirstLine(DisplayManager displayManager, TextArea textArea) {
        super(displayManager, textArea);
    }

    @Override
    void preContentInserted(int n, int n2) {
        int n3 = 0;
        int n4 = this.getPhysicalLine();
        int n5 = 0;
        int n6 = 0;
        for (int i = n; i < n4; ++i) {
            if (this.getDisplayManager().isLineVisible(i)) {
                n3 += this.getDisplayManager().getScreenLineCount(i);
            }
            if (n6 < n2) {
                ++n5;
            }
            ++n6;
        }
        this.preContentInsertedScrollLines = n3;
    }

    @Override
    void contentInserted(int n, int n2) {
        int n3;
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "contentInserted() before:" + this);
        }
        if (n == (n3 = this.getPhysicalLine())) {
            this.setCallChanged(true);
        } else if (n < n3) {
            int n4 = 0;
            int n5 = n;
            int n6 = n3 + n2;
            int n7 = 0;
            int n8 = 0;
            while (n5 < n6) {
                if (this.getDisplayManager().isLineVisible(n5)) {
                    n4 += this.getDisplayManager().getScreenLineCount(n5);
                }
                if (n8 < n2) {
                    ++n7;
                }
                ++n5;
                ++n8;
            }
            this.movePhysicalLine(n7);
            this.moveScrollLine(n4 - this.preContentInsertedScrollLines);
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "contentInserted() after:" + this);
        }
        if (Debug.SCROLL_VERIFY) {
            this.scrollVerify();
        }
    }

    @Override
    void preContentRemoved(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = this.getPhysicalLine();
        int n6 = 0;
        int n7 = 0;
        for (int i = n; i < n5; ++i) {
            if (this.getDisplayManager().isLineVisible(i)) {
                n4 += this.getDisplayManager().getScreenLineCount(i);
            }
            if (n7 < n3) {
                ++n6;
            }
            ++n7;
        }
        this.preContentRemovedScrollLines = n4;
        this.preContentRemovedNumLines = n6;
    }

    @Override
    void contentRemoved(int n, int n2, int n3) {
        int n4;
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "contentRemoved() before:" + this);
        }
        if (n == (n4 = this.getPhysicalLine())) {
            this.setCallChanged(true);
        } else if (n < n4) {
            int n5 = 0;
            int n6 = n4 - n3;
            for (int i = n; i < n6; ++i) {
                if (!this.getDisplayManager().isLineVisible(i)) continue;
                n5 += this.getDisplayManager().getScreenLineCount(i);
            }
            this.movePhysicalLine(-this.preContentRemovedNumLines);
            this.moveScrollLine(n5 - this.preContentRemovedScrollLines);
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "contentRemoved() after:" + this);
        }
        if (Debug.SCROLL_VERIFY) {
            this.scrollVerify();
        }
    }

    @Override
    public void changed() {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "changed() before: " + this.getPhysicalLine() + ':' + this.getScrollLine() + ':' + this.getSkew());
        }
        if (Debug.SCROLL_VERIFY) {
            this.scrollVerify();
        }
        this.ensurePhysicalLineIsVisible();
        int n = this.getPhysicalLine();
        int n2 = this.getDisplayManager().getScreenLineCount(n);
        if (this.getSkew() >= n2) {
            this.setSkew(n2 - 1);
        }
        if (Debug.SCROLL_VERIFY) {
            this.scrollVerify();
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "changed() after: " + this.getPhysicalLine() + ':' + this.getScrollLine() + ':' + this.getSkew());
        }
    }

    private void scrollVerify() {
        int n;
        System.err.println("SCROLL_VERIFY");
        int n2 = 0;
        int n3 = this.getPhysicalLine();
        int n4 = this.getDisplayManager().getBuffer().getLineCount();
        for (n = 0; n < n4 && n < n3; ++n) {
            if (!this.getDisplayManager().isLineVisible(n)) continue;
            n2 += this.getDisplayManager().getScreenLineCount(n);
        }
        n = this.getScrollLine();
        if (n2 != n) {
            RuntimeException runtimeException = new RuntimeException("ScrollLine is " + n + " but should be " + n2 + " diff = " + (n2 - n));
            Log.log(9, this, runtimeException);
        }
    }

    @Override
    public void reset() {
        int n;
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "reset()");
        }
        int n2 = this.getPhysicalLine();
        int n3 = this.getDisplayManager().getFirstVisibleLine();
        int n4 = 0;
        while (n3 != -1 && n3 < n2) {
            n4 += this.getDisplayManager().getScreenLineCount(n3);
            n = this.getDisplayManager().getNextVisibleLine(n3);
            if (n == -1) break;
            n3 = n;
        }
        this.setPhysicalLine(n3);
        this.setScrollLine(n4);
        n = this.getDisplayManager().getScreenLineCount(n3);
        if (this.getSkew() >= n) {
            this.setSkew(n - 1);
        }
        this.getTextArea().updateScrollBar();
    }

    void physDown(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.getPhysicalLine();
        int n6 = this.getScrollLine();
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physDown() start: " + n5 + ':' + n6);
        }
        this.setSkew(0);
        if (!this.getDisplayManager().isLineVisible(n5)) {
            n4 = this.getDisplayManager().getLastVisibleLine();
            if (n5 > n4) {
                this.setPhysicalLine(n4);
            } else {
                n3 = this.getDisplayManager().getNextVisibleLine(n5);
                assert (n3 > 0);
                n -= n3 - n5;
                this.moveScrollLine(this.getDisplayManager().getScreenLineCount(n5));
                this.setPhysicalLine(n3);
            }
        }
        n5 = this.getPhysicalLine();
        n4 = 0;
        while ((n3 = this.getDisplayManager().getNextVisibleLine(n5)) != -1 && n3 <= n5 + n) {
            n4 += this.getDisplayManager().getScreenLineCount(n5);
            n -= n3 - n5;
            n5 = n3;
        }
        this.setPhysicalLine(n5);
        this.moveScrollLine(n4);
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physDown() end: " + this.getPhysicalLine() + ':' + this.getScrollLine());
        }
        if (n2 < 0) {
            this.scrollUp(-n2);
        } else if (n2 > 0) {
            this.scrollDown(n2);
        }
    }

    void physUp(int n, int n2) {
        int n3;
        int n4;
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physUp() start: " + this.getPhysicalLine() + ':' + this.getScrollLine());
        }
        this.setSkew(0);
        int n5 = this.getPhysicalLine();
        if (!this.getDisplayManager().isLineVisible(n5)) {
            n4 = this.getDisplayManager().getFirstVisibleLine();
            if (n5 < n4) {
                this.setPhysicalLine(n4);
            } else {
                n3 = this.getDisplayManager().getPrevVisibleLine(n5);
                n -= n5 - n3;
            }
        }
        n5 = this.getPhysicalLine();
        n4 = 0;
        while ((n3 = this.getDisplayManager().getPrevVisibleLine(n5)) != -1 && n3 >= n5 - n) {
            n4 -= this.getDisplayManager().getScreenLineCount(n3);
            n -= n5 - n3;
            n5 = n3;
        }
        this.setPhysicalLine(n5);
        this.moveScrollLine(n4);
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physUp() end: " + this.getPhysicalLine() + ':' + this.getScrollLine());
        }
        if (n2 < 0) {
            this.scrollUp(-n2);
        } else if (n2 > 0) {
            this.scrollDown(n2);
        }
    }

    void scrollDown(int n) {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "scrollDown()");
        }
        this.ensurePhysicalLineIsVisible();
        n += this.getSkew();
        this.setSkew(0);
        int n2 = this.getPhysicalLine();
        int n3 = 0;
        while (n > 0) {
            int n4 = this.getDisplayManager().getScreenLineCount(n2);
            if (n < n4) {
                this.setSkew(n);
                break;
            }
            int n5 = this.getDisplayManager().getNextVisibleLine(n2);
            if (n5 == -1) break;
            boolean bl = this.getDisplayManager().isLineVisible(n2);
            n2 = n5;
            if (!bl) continue;
            n -= n4;
            n3 += n4;
        }
        this.setPhysicalLine(n2);
        this.moveScrollLine(n3);
    }

    void scrollUp(int n) {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "scrollUp() before:" + this);
        }
        this.ensurePhysicalLineIsVisible();
        if (n <= this.getSkew()) {
            this.setSkew(this.getSkew() - n);
        } else {
            int n2;
            n -= this.getSkew();
            this.setSkew(0);
            int n3 = this.getPhysicalLine();
            int n4 = 0;
            while (n > 0 && (n2 = this.getDisplayManager().getPrevVisibleLine(n3)) != -1) {
                n3 = n2;
                int n5 = this.getDisplayManager().getScreenLineCount(n3);
                n4 -= n5;
                if (n < n5) {
                    this.setSkew(n5 - n);
                    break;
                }
                n -= n5;
            }
            this.setPhysicalLine(n3);
            this.moveScrollLine(n4);
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "scrollUp() after:" + this);
        }
    }

    void ensurePhysicalLineIsVisible() {
        int n = this.getPhysicalLine();
        if (!this.getDisplayManager().isLineVisible(n)) {
            if (n > this.getDisplayManager().getLastVisibleLine()) {
                this.setPhysicalLine(this.getDisplayManager().getLastVisibleLine());
                this.setScrollLine(this.getDisplayManager().getScrollLineCount() - 1);
            } else if (n < this.getDisplayManager().getFirstVisibleLine()) {
                this.setPhysicalLine(this.getDisplayManager().getFirstVisibleLine());
                this.setScrollLine(0);
            } else {
                int n2 = this.getDisplayManager().getNextVisibleLine(n);
                assert (n2 > 0);
                int n3 = 0;
                n3 = this.getDisplayManager().getScreenLineCount(n2);
                this.setPhysicalLine(n2);
                this.moveScrollLine(n3);
            }
        }
    }

    @Override
    public String toString() {
        return "FirstLine[" + this.getPhysicalLine() + ',' + this.getScrollLine() + ',' + this.getSkew() + ']';
    }

    int getSkew() {
        return this.skew;
    }

    void setSkew(int n) {
        if (this.skew != n) {
            this.skew = n;
            this.setCallChanged(true);
        }
    }
}

