/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.nbo.NBODialog;

class FileHndlr
extends JPanel {
    protected static final String sep = System.getProperty("line.separator");
    protected static final String EXTENSIONS = "31;32;33;34;35;36;37;38;39;40;41;42;46;nbo";
    protected JTextField tfDir;
    protected JTextField tfName;
    protected JTextField tfExt;
    protected File inputFile;
    protected String fileDir;
    protected String jobStem;
    protected String useExt;
    protected JButton browse;
    protected NBODialog dialog;
    protected boolean canReRun;

    public FileHndlr(String name, String ext, int mode, String useExt, NBODialog d) {
        this.dialog = d;
        this.canReRun = true;
        Properties props = JmolPanel.historyFile.getProperties();
        this.fileDir = props.getProperty("workingPath", System.getProperty("user.home"));
        this.useExt = useExt;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        this.tfDir = new JTextField();
        this.tfDir.setPreferredSize(new Dimension(110, 20));
        this.tfDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileHndlr.this.browsePressed();
            }
        });
        this.tfDir.setText(this.fileDir);
        this.add((Component)this.tfDir, c);
        c.gridx = 1;
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(new Dimension(100, 20));
        this.tfName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileHndlr.this.browsePressed();
            }
        });
        this.tfName.setText(name);
        this.add((Component)this.tfName, c);
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)new JLabel("         folder"), c);
        c.gridx = 1;
        this.add((Component)new JLabel("          name"), c);
        c.gridx = 2;
        c.gridy = 0;
        this.tfExt = new JTextField();
        this.tfExt.setPreferredSize(new Dimension(40, 20));
        this.tfExt.setText(ext);
        this.tfExt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileHndlr.this.browsePressed();
            }
        });
        if (mode != 3 && mode != 4) {
            this.add((Component)this.tfExt, c);
            c.gridy = 1;
            this.add((Component)new JLabel("  ext"), c);
        }
        c.gridx = 3;
        c.gridy = 0;
        c.gridheight = 2;
        this.browse = mode != 5 ? new JButton("Browse") : new JButton("Save");
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FileHndlr.this.browsePressed();
            }
        });
        this.add((Component)this.browse, c);
        this.jobStem = name;
        this.setInput(this.fileDir, name, ext);
    }

    protected boolean browsePressed() {
        int i;
        if (this.dialog.nboService.isWorking && this.dialog.statusLab.getText().startsWith("Running") && (i = JOptionPane.showConfirmDialog(this.dialog, "Warning, changing jobs while running GenNBO can effect output files.\nContinue anyway?")) == 1) {
            return false;
        }
        JFileChooser myChooser = new JFileChooser();
        myChooser.setFileFilter(new FileNameExtensionFilter(this.useExt, this.useExt));
        myChooser.setFileHidingEnabled(true);
        String folder = this.tfDir.getText();
        String name = this.tfName.getText();
        if (!folder.equals("")) {
            if (!folder.contains(":")) {
                folder = "C:/" + folder;
            }
            this.fileDir = folder + "/" + (name.equals("") ? " " : name);
        }
        myChooser.setSelectedFile(new File(this.fileDir));
        int button = myChooser.showDialog(this, GT._("Select"));
        if (button == 0) {
            this.dialog.nboService.restart();
            this.inputFile = myChooser.getSelectedFile();
            if (this.dialog.dialogMode == 'm') {
                return true;
            }
            if (!this.useExt.equals("47")) {
                this.jobStem = FileHndlr.getJobStem(this.inputFile);
                this.dialog.loadModelFromNBO(this.fileDir, this.jobStem, this.useExt);
                this.tfName.setText(this.jobStem);
                this.tfExt.setText(this.useExt);
                return true;
            }
            this.canReRun = true;
            this.setInputFile(this.inputFile);
            this.dialog.appendOutputWithCaret("Job: " + this.jobStem, 'b');
            this.fileDir = this.inputFile.getParent();
            this.saveWorkHistory();
        }
        return true;
    }

    protected void setInputFile(File inputFile) {
        this.clearInputFile();
        this.dialog.isOpenShell = false;
        this.inputFile = inputFile;
        if (inputFile.getName().indexOf(".") > 0) {
            this.jobStem = FileHndlr.getJobStem(inputFile);
        }
        this.setInput(inputFile.getParent(), this.jobStem, this.useExt);
        if (FileHndlr.getExt(inputFile).equals("47")) {
            if ((inputFile.getParent() + "/").equals(this.dialog.nboService.serverDir)) {
                JOptionPane.showMessageDialog(this, "Select a directory that does not contain the NBOServe executable,\nor select a new location for your NBOServe executable");
                return;
            }
            this.dialog.isJmolNBO = true;
            this.fileDir = inputFile.getParent();
            boolean canLoad = true;
            for (String x : EXTENSIONS.split(";")) {
                File f3 = FileHndlr.newNBOFile(inputFile, x);
                if (f3.exists() || this.dialog.dialogMode == 'm') continue;
                if (this.dialog.dialogMode != 'r') {
                    if (this.canReRun) {
                        this.canReRun = false;
                        this.dialog.runJob("PLOT", inputFile, "gennbo");
                    } else {
                        this.dialog.vwr.alert("Error occurred during run");
                    }
                    return;
                }
                canLoad = false;
            }
            if (canLoad) {
                this.dialog.isNewJob = true;
                if (this.dialog.dialogMode == 'v') {
                    if (this.dialog.basis.getSelectedIndex() != 9) {
                        this.dialog.basis.setSelectedIndex(5);
                    } else {
                        this.dialog.basis.setSelectedIndex(9);
                    }
                } else {
                    this.dialog.runScriptQueued("load " + this.fileDir + "/" + this.jobStem + ".47");
                }
            } else if (this.dialog.dialogMode == 'r') {
                this.dialog.loadModelFromNBO(this.fileDir, this.jobStem, this.useExt);
                this.tfName.setText(this.jobStem);
                this.tfExt.setText("47");
            }
        }
    }

    protected String[] read47File() {
        String[] fileData = new String[3];
        String nboKeywords = "";
        BufferedReader b = null;
        try {
            b = new BufferedReader(new FileReader(this.inputFile));
        }
        catch (FileNotFoundException e1) {
            return null;
        }
        SB data = new SB();
        try {
            String line;
            while ((line = b.readLine()) != null) {
                data.append(line + sep);
            }
            b.close();
        }
        catch (IOException e) {
            return null;
        }
        String[] tokens = PT.split(data.toString(), "$END");
        boolean atParams = false;
        SB fout = new SB();
        SB fout2 = new SB();
        if (tokens.length <= 0) {
            return null;
        }
        int i = 0;
        while (true) {
            String s = tokens[i];
            s = PT.trim(s, "\t\r\n ");
            if (!atParams) {
                if (s.indexOf("$NBO") >= 0) {
                    atParams = true;
                    nboKeywords = PT.split(s, "$NBO").length > 1 ? PT.split(s, "$NBO")[1] : "";
                    s = PT.split(s, "$NBO")[0];
                    Logger.info("Params read: " + nboKeywords);
                }
                if (!s.equals("")) {
                    fout.append(s).append(sep);
                }
                if (++i == tokens.length) break;
                if (atParams) continue;
                fout.append("$END").append(sep);
                continue;
            }
            fout2.append(s).append(sep);
            if (++i == tokens.length) break;
            fout2.append("$END").append(sep);
        }
        fileData[0] = fout.toString();
        fileData[1] = nboKeywords;
        fileData[2] = fout2.toString();
        return fileData;
    }

    protected boolean getChooseList() {
        File f = FileHndlr.newNBOFile(this.inputFile, "nbo");
        if (!f.exists() || f.length() == 0L) {
            return false;
        }
        String[] tokens = PT.split(this.getFileData(f.toString()), "\n $CHOOSE");
        int i = 1;
        if (tokens.length < 2) {
            this.dialog.alert("An error occurred during run, view .nbo output?");
            return false;
        }
        if (tokens[1].trim().startsWith("keylist")) {
            if (!tokens[1].contains("Structure accepted:")) {
                if (tokens[1].contains("missing END?")) {
                    this.dialog.alert("Plot files not found. Run now with PLOT keyword?");
                    return false;
                }
                if (tokens[2].contains("ignoring")) {
                    this.dialog.alert("Ignoring $CHOOSE list");
                } else {
                    return false;
                }
            }
            i = 3;
        }
        String data = tokens[i].substring(0, tokens[i].indexOf("$END"));
        this.dialog.setChooseList(data);
        return true;
    }

    protected String[] getRSList() {
        String data = this.getFileData(FileHndlr.newNBOFile(this.inputFile, "nbo").toString());
        String[] toks = PT.split(data, "TOPO matrix for the leading resonance structure:\n");
        if (toks.length < 2) {
            if (toks[0].contains("0 candidate reference structure(s)")) {
                this.dialog.vwr.alert("0 candidate reference structure(s) calculated by SR LEWISCandidate reference structure taken from NBO search");
            }
            return null;
        }
        String[] toks2 = PT.split(toks[1], "---------------------------------------------------------------------------");
        String[] rsList = new String[2];
        rsList[0] = toks2[0].substring(toks2[0].lastIndexOf(45), toks2[0].indexOf("Res")).trim();
        rsList[0] = rsList[0].replace("-\n", "");
        rsList[1] = toks2[1];
        return rsList;
    }

    public void clear() {
        this.tfName.setText("");
        this.tfExt.setText("");
    }

    protected static File newNBOFile(File f, String ext) {
        String fname = f.toString();
        if (fname.lastIndexOf(".") < 0) {
            return new File(fname + "." + ext);
        }
        return new File(fname.substring(0, fname.lastIndexOf(".")) + "." + ext);
    }

    protected void clearInputFile() {
        for (String x : EXTENSIONS.split(";")) {
            File f2 = new File(this.dialog.nboService.serverDir + "/" + this.jobStem + "." + x);
            f2.delete();
        }
        this.inputFile = null;
        if (this.dialog.dialogMode == 'v') {
            this.dialog.resetView();
        }
    }

    protected static String getJobStem(File inputFile) {
        String fname = inputFile.getName();
        return fname.substring(0, fname.lastIndexOf("."));
    }

    protected void saveWorkHistory() {
        Properties props = new Properties();
        props.setProperty("workingPath", this.fileDir);
        JmolPanel.historyFile.addProperties(props);
    }

    protected void setInput(String f, String n, String e) {
        this.tfName.setText(n);
        this.tfDir.setText(f);
        this.tfExt.setText(e);
        this.inputFile = new File(f + "\\" + n + "." + e);
    }

    protected static String getExt(File newFile) {
        String fname = newFile.toString();
        return fname.substring(fname.lastIndexOf(".") + 1);
    }

    protected String getFileData(String fileName) {
        return this.dialog.vwr.getFileAsString4(fileName, Integer.MAX_VALUE, false, false, false, "nbo");
    }

    static void writeToFile(String s, File file) throws IOException {
        PrintWriter writer = new PrintWriter(file);
        writer.print(s);
        writer.close();
    }
}

