/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.methods.CallBoundMethodNode;
import org.jruby.truffle.language.methods.CallBoundMethodNodeGen;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.yield.CallBlockNode;
import org.jruby.truffle.language.yield.CallBlockNodeGen;

@NodeChildren(value={@NodeChild(value="receiver"), @NodeChild(value="arguments")})
abstract class ForeignExecuteHelperNode
extends RubyNode {
    public ForeignExecuteHelperNode(RubyContext context) {
        super(context);
    }

    public abstract Object executeCall(VirtualFrame var1, Object var2, Object[] var3);

    @Specialization(guards={"isRubyProc(proc)"})
    protected Object callProc(VirtualFrame frame, DynamicObject proc, Object[] arguments, @Cached(value="createCallBlockNode()") CallBlockNode callBlockNode) {
        Object self = Layouts.PROC.getSelf(proc);
        return callBlockNode.executeCallBlock(frame, proc, self, null, arguments);
    }

    protected CallBlockNode createCallBlockNode() {
        return CallBlockNodeGen.create(this.getContext(), null, DeclarationContext.BLOCK, null, null, null, null);
    }

    @Specialization(guards={"isRubyMethod(method)"})
    protected Object callMethod(VirtualFrame frame, DynamicObject method, Object[] arguments, @Cached(value="createCallBoundMethodNode()") CallBoundMethodNode callBoundMethodNode) {
        return callBoundMethodNode.executeCallBoundMethod(frame, method, arguments, null);
    }

    protected CallBoundMethodNode createCallBoundMethodNode() {
        return CallBoundMethodNodeGen.create(this.getContext(), null, null, null, null);
    }
}

