/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.language.RubyNode;

public class AndNode
extends RubyNode {
    @Node.Child
    private RubyNode left;
    @Node.Child
    private RubyNode right;
    @Node.Child
    private BooleanCastNode leftCast;
    private final ConditionProfile conditionProfile = ConditionProfile.createCountingProfile();

    public AndNode(RubyNode left, RubyNode right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        boolean leftBoolean;
        Object leftValue = this.left.execute(frame);
        if (this.leftCast == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.leftCast = this.insert(BooleanCastNodeGen.create(null));
        }
        if (this.conditionProfile.profile(leftBoolean = this.leftCast.executeBoolean(frame, leftValue))) {
            return this.right.execute(frame);
        }
        return leftValue;
    }
}

