/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib.zoom;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public abstract class AreaTracker
extends AbstractTool {
    private Rectangle area;

    protected AreaTracker(DrawingEditor editor) {
        super(editor);
    }

    public Rectangle getArea() {
        return new Rectangle(this.area.x, this.area.y, this.area.width, this.area.height);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, e.getX(), e.getY());
        this.rubberBand(this.fAnchorX, this.fAnchorY, this.fAnchorX, this.fAnchorY);
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        this.eraseRubberBand();
        this.rubberBand(this.fAnchorX, this.fAnchorY, x, y);
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        super.mouseUp(e, x, y);
        this.eraseRubberBand();
    }

    private void rubberBand(int x1, int y1, int x2, int y2) {
        this.area = new Rectangle(new Point(x1, y1));
        this.area.add(new Point(x2, y2));
        this.drawXORRect(this.area);
    }

    private void eraseRubberBand() {
        this.drawXORRect(this.area);
    }

    private void drawXORRect(Rectangle r) {
        Graphics g = this.view().getGraphics();
        g.setXORMode(this.view().getBackground());
        g.setColor(Color.black);
        g.drawRect(r.x, r.y, r.width, r.height);
    }
}

