/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.List;

public class GetMetricStatisticsRequestMarshaller
implements Marshaller<Request<GetMetricStatisticsRequest>, GetMetricStatisticsRequest> {
    public Request<GetMetricStatisticsRequest> marshall(GetMetricStatisticsRequest getMetricStatisticsRequest) {
        if (getMetricStatisticsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getMetricStatisticsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "GetMetricStatistics");
        request.addParameter("Version", "2010-08-01");
        if (getMetricStatisticsRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)getMetricStatisticsRequest.getNamespace()));
        }
        if (getMetricStatisticsRequest.getMetricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString((String)getMetricStatisticsRequest.getMetricName()));
        }
        List<Dimension> dimensionsList = getMetricStatisticsRequest.getDimensions();
        int dimensionsListIndex = 1;
        for (Dimension dimensionsListValue : dimensionsList) {
            Dimension dimensionMember = dimensionsListValue;
            if (dimensionMember != null) {
                if (dimensionMember.getName() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionMember.getName()));
                }
                if (dimensionMember.getValue() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionMember.getValue()));
                }
            }
            ++dimensionsListIndex;
        }
        if (getMetricStatisticsRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)getMetricStatisticsRequest.getStartTime()));
        }
        if (getMetricStatisticsRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)getMetricStatisticsRequest.getEndTime()));
        }
        if (getMetricStatisticsRequest.getPeriod() != null) {
            request.addParameter("Period", StringUtils.fromInteger((Integer)getMetricStatisticsRequest.getPeriod()));
        }
        List<String> statisticsList = getMetricStatisticsRequest.getStatistics();
        int statisticsListIndex = 1;
        for (String statisticsListValue : statisticsList) {
            if (statisticsListValue != null) {
                request.addParameter("Statistics.member." + statisticsListIndex, StringUtils.fromString((String)statisticsListValue));
            }
            ++statisticsListIndex;
        }
        if (getMetricStatisticsRequest.getUnit() != null) {
            request.addParameter("Unit", StringUtils.fromString((String)getMetricStatisticsRequest.getUnit()));
        }
        return request;
    }
}

