/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.object.DynamicObject;
import java.lang.reflect.Array;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayMirror;

public abstract class ArrayHelpers {
    public static Object getStore(DynamicObject array) {
        return Layouts.ARRAY.getStore(array);
    }

    public static int getSize(DynamicObject array) {
        return Layouts.ARRAY.getSize(array);
    }

    public static void setStoreAndSize(DynamicObject array, Object store, int size) {
        assert (!(store instanceof ArrayMirror));
        Layouts.ARRAY.setStore(array, store);
        ArrayHelpers.setSize(array, size);
    }

    public static void setSize(DynamicObject array, int size) {
        assert (ArrayHelpers.getStore(array) != null || size == 0);
        assert (ArrayHelpers.getStore(array) == null || Array.getLength(ArrayHelpers.getStore(array)) >= size);
        Layouts.ARRAY.setSize(array, size);
    }

    public static DynamicObject createArray(RubyContext context, Object store, int size) {
        return Layouts.ARRAY.createArray(context.getCoreLibrary().getArrayFactory(), store, size);
    }
}

