/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.time;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.tz.FixedDateTimeZone;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.time.GetTimeZoneNode;
import org.jruby.truffle.core.time.GetTimeZoneNodeGen;
import org.jruby.truffle.core.time.TimeNodesFactory;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.util.StringUtils;
import org.jruby.util.RubyDateFormatter;

@CoreClass(value="Time")
public abstract class TimeNodes {
    private static final DateTime ZERO = new DateTime(0L);

    public static class TimeZoneParser {
        private static final Pattern TZ_PATTERN = Pattern.compile("([^-\\+\\d]+)?([\\+-]?)(\\d+)(?::(\\d+))?(?::(\\d+))?");
        private static final Map<String, String> LONG_TZNAME = Helpers.map((String[])new String[]{"MET", "CET", "ROC", "Asia/Taipei", "WET", "Europe/Lisbon"});

        public static String getShortZoneName(DynamicObject time, DateTimeZone zone) {
            DateTime dateTime = Layouts.TIME.getDateTime(time);
            return TimeZoneParser.getShortZoneName(dateTime, zone);
        }

        @CompilerDirectives.TruffleBoundary
        public static String getShortZoneName(DateTime dateTime, DateTimeZone zone) {
            return zone.getShortName(dateTime.getMillis());
        }

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        public static DateTimeZone parse(RubyNode node, String zone) {
            String upZone = zone.toUpperCase(Locale.ENGLISH);
            Matcher tzMatcher = TZ_PATTERN.matcher(zone);
            if (tzMatcher.matches()) {
                String zoneName = tzMatcher.group(1);
                String sign = tzMatcher.group(2);
                String hours = tzMatcher.group(3);
                String minutes = tzMatcher.group(4);
                String seconds = tzMatcher.group(5);
                if (zoneName == null) {
                    zoneName = "";
                }
                return TimeZoneParser.getTimeZoneFromHHMM(node, zoneName, sign.equals("-"), hours, minutes, seconds);
            }
            if (LONG_TZNAME.containsKey(upZone)) {
                zone = LONG_TZNAME.get(upZone);
            } else if (upZone.equals("UTC") || upZone.equals("GMT")) {
                zone = "Etc/" + upZone;
            }
            try {
                return DateTimeZone.forID((String)zone);
            }
            catch (IllegalArgumentException e) {
                return DateTimeZone.UTC;
            }
        }

        private static DateTimeZone getTimeZoneFromHHMM(RubyNode node, String name, boolean positive, String hours, String minutes, String seconds) {
            int h = Integer.parseInt(hours);
            int m = 0;
            int s = 0;
            if (minutes != null) {
                m = Integer.parseInt(minutes);
            }
            if (seconds != null) {
                s = Integer.parseInt(seconds);
            }
            if (h > 23 || m > 59) {
                throw new RaiseException(node.getContext().getCoreExceptions().argumentError("utc_offset out of range", node));
            }
            int offset = (positive ? 1 : -1) * (h * 3600 + m * 60 + s) * 1000;
            return TimeZoneParser.timeZoneWithOffset(name, offset);
        }

        private static DateTimeZone timeZoneWithOffset(String zoneName, int offset) {
            if (zoneName.isEmpty()) {
                return DateTimeZone.forOffsetMillis((int)offset);
            }
            return new FixedDateTimeZone(zoneName, null, offset, offset);
        }
    }

    @Primitive(name="time_utc_offset")
    public static abstract class TimeUTCOffsetPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object timeUTCOffset(DynamicObject time) {
            return Layouts.TIME.getDateTime(time).getZone().getOffset(Layouts.TIME.getDateTime(time).getMillis()) / 1000;
        }
    }

    @Primitive(name="time_set_nseconds", lowerFixnum={1})
    public static abstract class TimeSetNSecondsPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public long timeSetNSeconds(DynamicObject time, int nanoseconds) {
            Layouts.TIME.setDateTime(time, Layouts.TIME.getDateTime(time).withMillisOfSecond(nanoseconds / 1000000));
            Layouts.TIME.setNSec(time, nanoseconds % 1000000);
            return nanoseconds;
        }
    }

    @Primitive(name="time_nseconds")
    public static abstract class TimeNSecondsPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public long timeNSeconds(DynamicObject time) {
            return (long)(Layouts.TIME.getDateTime(time).getMillisOfSecond() % 1000) * 1000000L + Layouts.TIME.getNSec(time);
        }
    }

    @Primitive(name="time_s_from_array", needsSelf=true, lowerFixnum={1, 2, 3, 4, 5, 6, 7, 8})
    public static abstract class TimeSFromArrayPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        GetTimeZoneNode getTimeZoneNode = GetTimeZoneNodeGen.create();
        @Node.Child
        AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        public TimeSFromArrayPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!fromutc", "!isNil(utcoffset)"})
        public DynamicObject timeSFromArray(VirtualFrame frame, DynamicObject timeClass, int sec, int min, int hour, int mday, int month, int year, int nsec, int isdst, boolean fromutc, DynamicObject utcoffset, @Cached(value="new()") SnippetNode snippetNode) {
            DateTimeZone envZone = null;
            if (!fromutc && utcoffset == this.nil()) {
                envZone = this.getTimeZoneNode.executeGetTimeZone(frame);
            }
            int millis = TimeSFromArrayPrimitiveNode.cast(snippetNode.execute(frame, "(offset * 1000).to_i", "offset", utcoffset));
            return this.buildTime(timeClass, sec, min, hour, mday, month, year, nsec, isdst, fromutc, utcoffset, envZone, millis);
        }

        @Specialization(guards={"(fromutc || !isDynamicObject(utcoffset)) || isNil(utcoffset)"})
        public DynamicObject timeSFromArray(VirtualFrame frame, DynamicObject timeClass, int sec, int min, int hour, int mday, int month, int year, int nsec, int isdst, boolean fromutc, Object utcoffset) {
            DateTimeZone envZone = null;
            if (!fromutc && utcoffset == this.nil()) {
                envZone = this.getTimeZoneNode.executeGetTimeZone(frame);
            }
            return this.buildTime(timeClass, sec, min, hour, mday, month, year, nsec, isdst, fromutc, utcoffset, envZone, -1);
        }

        @Specialization(guards={"!isInteger(sec) || !isInteger(nsec)"})
        public DynamicObject timeSFromArrayFallback(VirtualFrame frame, DynamicObject timeClass, Object sec, int min, int hour, int mday, int month, int year, Object nsec, int isdst, boolean fromutc, Object utcoffset) {
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private DynamicObject buildTime(DynamicObject timeClass, int sec, int min, int hour, int mday, int month, int year, int nsec, int isdst, boolean fromutc, Object utcoffset, DateTimeZone envZone, int millis) {
            DynamicObject zoneToStore;
            boolean relativeOffset;
            DateTimeZone zone;
            if (sec < 0 || sec > 59 || min < 0 || min > 59 || hour < 0 || hour > 23 || mday < 1 || mday > 31 || month < 1 || month > 12) {
                throw new RaiseException(this.coreExceptions().argumentErrorOutOfRange(this));
            }
            DateTime dt = new DateTime(year, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            dt = dt.plusMonths(month - 1).plusDays(mday - 1).plusHours(hour).plusMinutes(min).plusSeconds(sec).plusMillis(nsec / 1000000);
            if (fromutc) {
                zone = DateTimeZone.UTC;
                relativeOffset = false;
                zoneToStore = this.nil();
            } else if (utcoffset == this.nil()) {
                zone = envZone;
                String zoneName = TimeZoneParser.getShortZoneName(dt.withZoneRetainFields(zone), zone);
                zoneToStore = this.createString(StringOperations.encodeRope(zoneName, (Encoding)UTF8Encoding.INSTANCE));
                relativeOffset = false;
            } else if (utcoffset instanceof Integer) {
                zone = DateTimeZone.forOffsetMillis((int)((Integer)utcoffset * 1000));
                relativeOffset = true;
                zoneToStore = this.nil();
            } else if (utcoffset instanceof Long) {
                zone = DateTimeZone.forOffsetMillis((int)((int)((Long)utcoffset).longValue() * 1000));
                relativeOffset = true;
                zoneToStore = this.nil();
            } else if (utcoffset instanceof DynamicObject) {
                zone = DateTimeZone.forOffsetMillis((int)millis);
                relativeOffset = true;
                zoneToStore = this.nil();
            } else {
                throw new UnsupportedOperationException(StringUtils.format("%s %s %s %s", isdst, fromutc, utcoffset, utcoffset.getClass()));
            }
            dt = dt.withZoneRetainFields(zone);
            if (isdst == 0) {
                dt = dt.withLaterOffsetAtOverlap();
            }
            if (isdst == 1) {
                dt = dt.withEarlierOffsetAtOverlap();
            }
            return this.allocateObjectNode.allocate(timeClass, dt, nsec % 1000000, zoneToStore, utcoffset, relativeOffset, fromutc);
        }

        private static int cast(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Long) {
                return (int)((Long)value).longValue();
            }
            throw new UnsupportedOperationException("Can't cast " + value.getClass());
        }
    }

    @Primitive(name="time_strftime")
    public static abstract class TimeStrftimePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(format)"})
        public DynamicObject timeStrftime(DynamicObject time, DynamicObject format) {
            RubyDateFormatter rdf = this.getContext().getJRubyRuntime().getCurrentContext().getRubyDateFormatter();
            return this.createString(rdf.formatToByteList(rdf.compilePattern(StringOperations.getByteListReadOnly(format), false), Layouts.TIME.getDateTime(time), Layouts.TIME.getNSec(time), null));
        }
    }

    @Primitive(name="time_decompose")
    public static abstract class TimeDecomposePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        public TimeDecomposePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject timeDecompose(DynamicObject time) {
            Object zone;
            boolean isdst;
            DateTime dateTime = Layouts.TIME.getDateTime(time);
            int sec = dateTime.getSecondOfMinute();
            int min = dateTime.getMinuteOfHour();
            int hour = dateTime.getHourOfDay();
            int day = dateTime.getDayOfMonth();
            int month = dateTime.getMonthOfYear();
            int year = dateTime.getYear();
            int wday = dateTime.getDayOfWeek();
            if (wday == 7) {
                wday = 0;
            }
            int yday = dateTime.getDayOfYear();
            boolean bl = isdst = !dateTime.getZone().isStandardOffset(dateTime.getMillis());
            if (Layouts.TIME.getRelativeOffset(time)) {
                zone = this.nil();
            } else {
                Object timeZone = Layouts.TIME.getZone(time);
                if (timeZone == this.nil()) {
                    String zoneString = TimeZoneParser.getShortZoneName(dateTime, dateTime.getZone());
                    zone = this.createString(StringOperations.encodeRope(zoneString, (Encoding)UTF8Encoding.INSTANCE));
                } else {
                    zone = timeZone;
                }
            }
            Object[] decomposed = new Object[]{sec, min, hour, day, month, year, wday, yday, isdst, zone};
            return this.createArray(decomposed, decomposed.length);
        }
    }

    @Primitive(name="time_useconds")
    public static abstract class TimeUSecondsPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public long timeUSeconds(DynamicObject time) {
            return (long)Layouts.TIME.getDateTime(time).getMillisOfSecond() * 1000L + Layouts.TIME.getNSec(time) / 1000L;
        }
    }

    @Primitive(name="time_seconds")
    public static abstract class TimeSecondsPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public long timeSeconds(DynamicObject time) {
            return Layouts.TIME.getDateTime(time).getMillis() / 1000L;
        }
    }

    @Primitive(name="time_s_specific", lowerFixnum={2})
    public static abstract class TimeSSpecificPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private GetTimeZoneNode getTimeZoneNode = GetTimeZoneNodeGen.create();
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        public TimeSSpecificPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isUTC"})
        public DynamicObject timeSSpecificUTC(DynamicObject timeClass, long seconds, int nanoseconds, boolean isUTC, Object offset) {
            long milliseconds = this.getMillis(seconds, nanoseconds);
            return this.allocateObjectNode.allocate(timeClass, this.utcTime(milliseconds), nanoseconds % 1000000, this.nil(), this.nil(), false, isUTC);
        }

        @Specialization(guards={"!isUTC", "isNil(offset)"})
        public DynamicObject timeSSpecific(VirtualFrame frame, DynamicObject timeClass, long seconds, int nanoseconds, boolean isUTC, Object offset) {
            long milliseconds = this.getMillis(seconds, nanoseconds);
            return this.allocateObjectNode.allocate(timeClass, this.localtime(milliseconds, this.getTimeZoneNode.executeGetTimeZone(frame)), nanoseconds % 1000000, this.nil(), offset, false, isUTC);
        }

        @Specialization(guards={"!isUTC"})
        public DynamicObject timeSSpecific(VirtualFrame frame, DynamicObject timeClass, long seconds, int nanoseconds, boolean isUTC, long offset) {
            long milliseconds = this.getMillis(seconds, nanoseconds);
            return this.allocateObjectNode.allocate(timeClass, this.offsetTime(milliseconds, offset), nanoseconds % 1000000, this.nil(), this.nil(), false, isUTC);
        }

        private long getMillis(long seconds, int nanoseconds) {
            try {
                return ExactMath.addExact(ExactMath.multiplyExact(seconds, 1000L), (long)(nanoseconds / 1000000));
            }
            catch (ArithmeticException e) {
                String message = StringUtils.format("UNIX epoch + %d seconds out of range for Time (Joda-Time limitation)", seconds);
                throw new RaiseException(this.coreExceptions().rangeError(message, (Node)this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private DateTime utcTime(long milliseconds) {
            return new DateTime(milliseconds, DateTimeZone.UTC);
        }

        @CompilerDirectives.TruffleBoundary
        private DateTime offsetTime(long milliseconds, long offset) {
            return new DateTime(milliseconds, DateTimeZone.forOffsetMillis((int)((int)offset * 1000)));
        }

        @CompilerDirectives.TruffleBoundary
        private DateTime localtime(long milliseconds, DateTimeZone timeZone) {
            return new DateTime(milliseconds, timeZone);
        }
    }

    @Primitive(name="time_s_now")
    public static abstract class TimeSNowPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();
        @Node.Child
        private GetTimeZoneNode getTimeZoneNode = GetTimeZoneNodeGen.create();

        public TimeSNowPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject timeSNow(VirtualFrame frame, DynamicObject timeClass) {
            return this.allocateObjectNode.allocate(timeClass, this.now(this.getTimeZoneNode.executeGetTimeZone(frame)), 0, this.nil(), this.nil(), false, false);
        }

        @CompilerDirectives.TruffleBoundary
        private DateTime now(DateTimeZone timeZone) {
            return DateTime.now((DateTimeZone)timeZone);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocate(rubyClass, ZERO, 0, this.coreLibrary().getNilObject(), 0, false, false);
        }
    }

    @CoreMethod(names={"internal_offset"})
    public static abstract class InternalOffsetCoreNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private InternalOffsetNode internalOffsetNode = TimeNodesFactory.InternalOffsetNodeFactory.create(null);

        public InternalOffsetCoreNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object allocate(DynamicObject time) {
            return this.internalOffsetNode.internalOffset(time);
        }
    }

    @CoreMethod(names={"gmt?"})
    public static abstract class GmtNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private InternalGMTNode internalGMTNode = TimeNodesFactory.InternalGMTNodeFactory.create(null);

        public GmtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean allocate(DynamicObject time) {
            return this.internalGMTNode.internalGMT(time);
        }
    }

    @CoreMethod(names={"gmtime"})
    public static abstract class GmTimeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject localtime(DynamicObject time) {
            DateTime dateTime = Layouts.TIME.getDateTime(time);
            Layouts.TIME.setIsUtc(time, true);
            Layouts.TIME.setRelativeOffset(time, false);
            Layouts.TIME.setZone(time, this.nil());
            Layouts.TIME.setDateTime(time, this.inUTC(dateTime));
            return time;
        }

        @CompilerDirectives.TruffleBoundary
        private DateTime inUTC(DateTime dateTime) {
            return dateTime.withZone(DateTimeZone.UTC);
        }
    }

    @CoreMethod(names={"dup_internal"}, required=1, visibility=Visibility.PROTECTED)
    public static abstract class DupInternalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        public DupInternalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject dup(DynamicObject time, DynamicObject klass) {
            return this.allocateObjectNode.allocate(klass, Layouts.TIME.getDateTime(time), Layouts.TIME.getNSec(time), Layouts.TIME.getZone(time), Layouts.TIME.getOffset(time), Layouts.TIME.getRelativeOffset(time), Layouts.TIME.getIsUtc(time));
        }
    }

    @CoreMethod(names={"add_internal!"}, required=2, visibility=Visibility.PROTECTED)
    public static abstract class AddInternalNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject addInternal(DynamicObject time, long seconds, long nanoSeconds) {
            DateTime dateTime = Layouts.TIME.getDateTime(time);
            long addMilis = ExactMath.addExact(ExactMath.multiplyExact(seconds, 1000L), nanoSeconds / 1000000L);
            Layouts.TIME.setDateTime(time, dateTime.plus(addMilis));
            Layouts.TIME.setNSec(time, (1000000L + Layouts.TIME.getNSec(time) + nanoSeconds % 1000000L) % 1000000L);
            return time;
        }
    }

    @CoreMethod(names={"localtime_internal"}, optional=1)
    public static abstract class LocalTimeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private GetTimeZoneNode getTimeZoneNode = GetTimeZoneNodeGen.create();

        public LocalTimeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject localtime(VirtualFrame frame, DynamicObject time, NotProvided offset) {
            DateTimeZone dateTimeZone = this.getTimeZoneNode.executeGetTimeZone(frame);
            String shortZoneName = TimeZoneParser.getShortZoneName(time, dateTimeZone);
            DynamicObject zone = this.createString(StringOperations.encodeRope(shortZoneName, (Encoding)UTF8Encoding.INSTANCE));
            DateTime dateTime = Layouts.TIME.getDateTime(time);
            Layouts.TIME.setIsUtc(time, false);
            Layouts.TIME.setRelativeOffset(time, false);
            Layouts.TIME.setZone(time, zone);
            Layouts.TIME.setDateTime(time, this.withZone(dateTime, dateTimeZone));
            return time;
        }

        @Specialization
        public DynamicObject localtime(DynamicObject time, long offset) {
            DateTime dateTime = Layouts.TIME.getDateTime(time);
            DateTimeZone zone = this.getDateTimeZone((int)offset);
            Layouts.TIME.setIsUtc(time, false);
            Layouts.TIME.setRelativeOffset(time, true);
            Layouts.TIME.setZone(time, this.nil());
            Layouts.TIME.setDateTime(time, this.withZone(dateTime, zone));
            return time;
        }

        @CompilerDirectives.TruffleBoundary
        public DateTimeZone getDateTimeZone(int offset) {
            return DateTimeZone.forOffsetMillis((int)(offset * 1000));
        }

        @CompilerDirectives.TruffleBoundary
        private DateTime withZone(DateTime dateTime, DateTimeZone zone) {
            return dateTime.withZone(zone);
        }
    }

    @NodeChild(type=RubyNode.class, value="self")
    public static abstract class InternalOffsetNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object internalOffset(DynamicObject time) {
            Object offset = Layouts.TIME.getOffset(time);
            if (offset == this.nil()) {
                DateTime dateTime = Layouts.TIME.getDateTime(time);
                return dateTime.getZone().getOffset(dateTime.getMillis()) / 1000;
            }
            return offset;
        }
    }

    @NodeChild(type=RubyNode.class, value="self")
    public static abstract class InternalGMTNode
    extends CoreMethodNode {
        @Specialization
        public boolean internalGMT(DynamicObject time) {
            return Layouts.TIME.getIsUtc(time);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyTime(from)"})
        public Object initializeCopy(DynamicObject self, DynamicObject from) {
            Layouts.TIME.setDateTime(self, Layouts.TIME.getDateTime(from));
            Layouts.TIME.setNSec(self, Layouts.TIME.getNSec(from));
            Layouts.TIME.setOffset(self, Layouts.TIME.getOffset(from));
            Layouts.TIME.setRelativeOffset(self, Layouts.TIME.getRelativeOffset(from));
            return self;
        }
    }
}

