/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class BlockPassNode
extends Node {
    private final Node bodyNode;
    private Node argsNode;

    public BlockPassNode(ISourcePosition position, Node bodyNode) {
        super(position, bodyNode != null && bodyNode.containsVariableAssignment());
        this.bodyNode = bodyNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.BLOCKPASSNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitBlockPassNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public void setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.argsNode, this.bodyNode);
    }
}

