/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.mapper.MapperRegistry;

public class MetaDataIndexUpgradeService
extends AbstractComponent {
    private final MapperRegistry mapperRegistry;
    private final IndexScopedSettings indexScopedSettings;

    @Inject
    public MetaDataIndexUpgradeService(Settings settings, MapperRegistry mapperRegistry, IndexScopedSettings indexScopedSettings) {
        super(settings);
        this.mapperRegistry = mapperRegistry;
        this.indexScopedSettings = indexScopedSettings;
    }

    public IndexMetaData upgradeIndexMetaData(IndexMetaData indexMetaData) {
        if (this.isUpgraded(indexMetaData)) {
            assert (indexMetaData == this.archiveBrokenIndexSettings(indexMetaData)) : "all settings must have been upgraded before";
            return indexMetaData;
        }
        this.checkSupportedVersion(indexMetaData);
        IndexMetaData newMetaData = indexMetaData;
        newMetaData = this.archiveBrokenIndexSettings(newMetaData);
        this.checkMappingsCompatibility(newMetaData);
        return this.markAsUpgraded(newMetaData);
    }

    boolean isUpgraded(IndexMetaData indexMetaData) {
        return indexMetaData.getUpgradedVersion().onOrAfter(Version.CURRENT);
    }

    private void checkSupportedVersion(IndexMetaData indexMetaData) {
        if (indexMetaData.getState() == IndexMetaData.State.OPEN && !MetaDataIndexUpgradeService.isSupportedVersion(indexMetaData)) {
            throw new IllegalStateException("The index [" + indexMetaData.getIndex() + "] was created before v2.0.0.beta1. It should be reindexed in Elasticsearch 2.x before upgrading to " + Version.CURRENT + ".");
        }
    }

    private static boolean isSupportedVersion(IndexMetaData indexMetaData) {
        return indexMetaData.getCreationVersion().onOrAfter(Version.V_2_0_0_beta1);
    }

    private void checkMappingsCompatibility(IndexMetaData indexMetaData) {
        try {
            IndexSettings indexSettings = new IndexSettings(indexMetaData, this.settings);
            SimilarityService similarityService = new SimilarityService(indexSettings, Collections.emptyMap());
            final NamedAnalyzer fakeDefault = new NamedAnalyzer("fake_default", AnalyzerScope.INDEX, new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    throw new UnsupportedOperationException("shouldn't be here");
                }
            });
            AbstractMap<String, NamedAnalyzer> analyzerMap = new AbstractMap<String, NamedAnalyzer>(){

                @Override
                public NamedAnalyzer get(Object key) {
                    assert (key instanceof String) : "key must be a string but was: " + key.getClass();
                    return new NamedAnalyzer((String)key, AnalyzerScope.INDEX, fakeDefault.analyzer());
                }

                @Override
                public Set<Map.Entry<String, NamedAnalyzer>> entrySet() {
                    return Collections.singletonMap(fakeDefault.name(), fakeDefault).entrySet();
                }
            };
            try (IndexAnalyzers fakeIndexAnalzyers = new IndexAnalyzers(indexSettings, fakeDefault, fakeDefault, fakeDefault, (Map<String, NamedAnalyzer>)analyzerMap);){
                MapperService mapperService = new MapperService(indexSettings, fakeIndexAnalzyers, similarityService, this.mapperRegistry, () -> null);
                for (ObjectCursor cursor : indexMetaData.getMappings().values()) {
                    MappingMetaData mappingMetaData = (MappingMetaData)cursor.value;
                    mapperService.merge(mappingMetaData.type(), mappingMetaData.source(), MapperService.MergeReason.MAPPING_RECOVERY, false);
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("unable to upgrade the mappings for the index [" + indexMetaData.getIndex() + "]", ex);
        }
    }

    private IndexMetaData markAsUpgraded(IndexMetaData indexMetaData) {
        Settings settings = Settings.builder().put(indexMetaData.getSettings()).put("index.version.upgraded", Version.CURRENT).build();
        return IndexMetaData.builder(indexMetaData).settings(settings).build();
    }

    IndexMetaData archiveBrokenIndexSettings(IndexMetaData indexMetaData) {
        Settings settings = indexMetaData.getSettings();
        Settings upgrade = this.indexScopedSettings.archiveUnknownOrInvalidSettings(settings, e -> this.logger.warn("{} ignoring unknown index setting: [{}] with value [{}]; archiving", (Object)indexMetaData.getIndex(), e.getKey(), e.getValue()), (e, ex) -> this.logger.warn(() -> new ParameterizedMessage("{} ignoring invalid index setting: [{}] with value [{}]; archiving", new Object[]{indexMetaData.getIndex(), e.getKey(), e.getValue()}), (Throwable)ex));
        if (upgrade != settings) {
            return IndexMetaData.builder(indexMetaData).settings(upgrade).build();
        }
        return indexMetaData;
    }
}

