/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.AckedClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.service.PendingClusterTask;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.PrioritizedRunnable;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.threadpool.ThreadPool;

public class ClusterService
extends AbstractLifecycleComponent {
    public static final Setting<TimeValue> CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING = Setting.positiveTimeSetting("cluster.service.slow_task_logging_threshold", TimeValue.timeValueSeconds(30L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String UPDATE_THREAD_NAME = "clusterService#updateTask";
    private final ThreadPool threadPool;
    private final ClusterName clusterName;
    private BiConsumer<ClusterChangedEvent, Discovery.AckListener> clusterStatePublisher;
    private final OperationRouting operationRouting;
    private final ClusterSettings clusterSettings;
    private TimeValue slowTaskLoggingThreshold;
    private volatile PrioritizedEsThreadPoolExecutor updateTasksExecutor;
    private final Collection<ClusterStateListener> priorityClusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Collection<ClusterStateListener> clusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Collection<ClusterStateListener> lastClusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    final Map<ClusterStateTaskExecutor, LinkedHashSet<UpdateTask>> updateTasksPerExecutor = new HashMap<ClusterStateTaskExecutor, LinkedHashSet<UpdateTask>>();
    private final Collection<ClusterStateListener> postAppliedListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Iterable<ClusterStateListener> preAppliedListeners = Iterables.concat(this.priorityClusterStateListeners, this.clusterStateListeners, this.lastClusterStateListeners);
    private final LocalNodeMasterListeners localNodeMasterListeners;
    private final Queue<NotifyTimeout> onGoingTimeouts = ConcurrentCollections.newQueue();
    private volatile ClusterState clusterState;
    private final ClusterBlocks.Builder initialBlocks;
    private NodeConnectionsService nodeConnectionsService;

    public ClusterService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool) {
        super(settings);
        this.operationRouting = new OperationRouting(settings, clusterSettings);
        this.threadPool = threadPool;
        this.clusterSettings = clusterSettings;
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.clusterState = ClusterState.builder(this.clusterName).build();
        this.clusterSettings.addSettingsUpdateConsumer(CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING, this::setSlowTaskLoggingThreshold);
        this.slowTaskLoggingThreshold = CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING.get(settings);
        this.localNodeMasterListeners = new LocalNodeMasterListeners(threadPool);
        this.initialBlocks = ClusterBlocks.builder();
    }

    private void setSlowTaskLoggingThreshold(TimeValue slowTaskLoggingThreshold) {
        this.slowTaskLoggingThreshold = slowTaskLoggingThreshold;
    }

    public synchronized void setClusterStatePublisher(BiConsumer<ClusterChangedEvent, Discovery.AckListener> publisher) {
        this.clusterStatePublisher = publisher;
    }

    public synchronized void setLocalNode(DiscoveryNode localNode) {
        assert (this.clusterState.nodes().getLocalNodeId() == null) : "local node is already set";
        DiscoveryNodes.Builder nodeBuilder = DiscoveryNodes.builder(this.clusterState.nodes()).add(localNode).localNodeId(localNode.getId());
        this.clusterState = ClusterState.builder(this.clusterState).nodes(nodeBuilder).build();
    }

    public synchronized void setNodeConnectionsService(NodeConnectionsService nodeConnectionsService) {
        assert (this.nodeConnectionsService == null) : "nodeConnectionsService is already set";
        this.nodeConnectionsService = nodeConnectionsService;
    }

    public synchronized void addInitialStateBlock(ClusterBlock block) throws IllegalStateException {
        if (this.lifecycle.started()) {
            throw new IllegalStateException("can't set initial block when started");
        }
        this.initialBlocks.addGlobalBlock(block);
    }

    public synchronized void removeInitialStateBlock(ClusterBlock block) throws IllegalStateException {
        this.removeInitialStateBlock(block.id());
    }

    public synchronized void removeInitialStateBlock(int blockId) throws IllegalStateException {
        if (this.lifecycle.started()) {
            throw new IllegalStateException("can't set initial block when started");
        }
        this.initialBlocks.removeGlobalBlock(blockId);
    }

    @Override
    protected synchronized void doStart() {
        Objects.requireNonNull(this.clusterStatePublisher, "please set a cluster state publisher before starting");
        Objects.requireNonNull(this.clusterState.nodes().getLocalNode(), "please set the local node before starting");
        Objects.requireNonNull(this.nodeConnectionsService, "please set the node connection service before starting");
        this.add(this.localNodeMasterListeners);
        this.clusterState = ClusterState.builder(this.clusterState).blocks(this.initialBlocks).build();
        this.updateTasksExecutor = EsExecutors.newSinglePrioritizing(UPDATE_THREAD_NAME, EsExecutors.daemonThreadFactory(this.settings, UPDATE_THREAD_NAME), this.threadPool.getThreadContext());
        this.clusterState = ClusterState.builder(this.clusterState).blocks(this.initialBlocks).build();
    }

    @Override
    protected synchronized void doStop() {
        for (NotifyTimeout onGoingTimeout : this.onGoingTimeouts) {
            onGoingTimeout.cancel();
            try {
                onGoingTimeout.cancel();
                onGoingTimeout.listener.onClose();
            }
            catch (Exception ex) {
                this.logger.debug("failed to notify listeners on shutdown", (Throwable)ex);
            }
        }
        ThreadPool.terminate(this.updateTasksExecutor, 10L, TimeUnit.SECONDS);
        this.postAppliedListeners.stream().filter(listener -> listener instanceof TimeoutClusterStateListener).map(listener -> (TimeoutClusterStateListener)listener).forEach(TimeoutClusterStateListener::onClose);
        this.remove(this.localNodeMasterListeners);
    }

    @Override
    protected synchronized void doClose() {
    }

    public DiscoveryNode localNode() {
        DiscoveryNode localNode = this.clusterState.getNodes().getLocalNode();
        if (localNode == null) {
            throw new IllegalStateException("No local node found. Is the node started?");
        }
        return localNode;
    }

    public OperationRouting operationRouting() {
        return this.operationRouting;
    }

    public ClusterState state() {
        return this.clusterState;
    }

    public void addFirst(ClusterStateListener listener) {
        this.priorityClusterStateListeners.add(listener);
    }

    public void addLast(ClusterStateListener listener) {
        this.lastClusterStateListeners.add(listener);
    }

    public void add(ClusterStateListener listener) {
        this.clusterStateListeners.add(listener);
    }

    public void remove(ClusterStateListener listener) {
        this.clusterStateListeners.remove(listener);
        this.priorityClusterStateListeners.remove(listener);
        this.lastClusterStateListeners.remove(listener);
        this.postAppliedListeners.remove(listener);
        Iterator it = this.onGoingTimeouts.iterator();
        while (it.hasNext()) {
            NotifyTimeout timeout = (NotifyTimeout)it.next();
            if (!timeout.listener.equals(listener)) continue;
            timeout.cancel();
            it.remove();
        }
    }

    public void add(LocalNodeMasterListener listener) {
        this.localNodeMasterListeners.add(listener);
    }

    public void remove(LocalNodeMasterListener listener) {
        this.localNodeMasterListeners.remove(listener);
    }

    public void add(final @Nullable TimeValue timeout, final TimeoutClusterStateListener listener) {
        if (this.lifecycle.stoppedOrClosed()) {
            listener.onClose();
            return;
        }
        try {
            this.updateTasksExecutor.execute(new SourcePrioritizedRunnable(Priority.HIGH, "_add_listener_"){

                @Override
                public void run() {
                    if (timeout != null) {
                        NotifyTimeout notifyTimeout = new NotifyTimeout(listener, timeout);
                        notifyTimeout.future = ClusterService.this.threadPool.schedule(timeout, "generic", notifyTimeout);
                        ClusterService.this.onGoingTimeouts.add(notifyTimeout);
                    }
                    ClusterService.this.postAppliedListeners.add(listener);
                    listener.postAdded();
                }
            });
        }
        catch (EsRejectedExecutionException e) {
            if (this.lifecycle.stoppedOrClosed()) {
                listener.onClose();
            }
            throw e;
        }
    }

    public void submitStateUpdateTask(String source, ClusterStateUpdateTask updateTask) {
        this.submitStateUpdateTask(source, updateTask, updateTask, updateTask, updateTask);
    }

    public <T> void submitStateUpdateTask(String source, T task, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor, ClusterStateTaskListener listener) {
        this.submitStateUpdateTasks(source, Collections.singletonMap(task, listener), config, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void submitStateUpdateTasks(String source, Map<T, ClusterStateTaskListener> tasks, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor) {
        block10: {
            if (!this.lifecycle.started()) {
                return;
            }
            if (tasks.isEmpty()) {
                return;
            }
            try {
                IdentityHashMap<T, ClusterStateTaskListener> tasksIdentity = new IdentityHashMap<T, ClusterStateTaskListener>(tasks);
                List updateTasks = tasksIdentity.entrySet().stream().map(entry -> new UpdateTask(source, entry.getKey(), config.priority(), executor, ClusterService.safe((ClusterStateTaskListener)entry.getValue(), this.logger))).collect(Collectors.toList());
                Map<ClusterStateTaskExecutor, LinkedHashSet<UpdateTask>> map = this.updateTasksPerExecutor;
                synchronized (map) {
                    LinkedHashSet existingTasks = this.updateTasksPerExecutor.computeIfAbsent(executor, k -> new LinkedHashSet(updateTasks.size()));
                    for (UpdateTask existing : existingTasks) {
                        if (!tasksIdentity.containsKey(existing.task)) continue;
                        throw new IllegalStateException("task [" + executor.describeTasks(Collections.singletonList(existing.task)) + "] with source [" + source + "] is already queued");
                    }
                    existingTasks.addAll(updateTasks);
                }
                UpdateTask firstTask = (UpdateTask)updateTasks.get(0);
                TimeValue timeout = config.timeout();
                if (timeout != null) {
                    this.updateTasksExecutor.execute(firstTask, this.threadPool.scheduler(), timeout, () -> this.threadPool.generic().execute(() -> {
                        ArrayList<UpdateTask> toRemove = new ArrayList<UpdateTask>();
                        for (UpdateTask task : updateTasks) {
                            if (task.processed.getAndSet(true)) continue;
                            this.logger.debug("cluster state update task [{}] timed out after [{}]", (Object)source, (Object)timeout);
                            toRemove.add(task);
                        }
                        if (!toRemove.isEmpty()) {
                            ClusterStateTaskExecutor clusterStateTaskExecutor = ((UpdateTask)toRemove.get(0)).executor;
                            Map<ClusterStateTaskExecutor, LinkedHashSet<UpdateTask>> map = this.updateTasksPerExecutor;
                            synchronized (map) {
                                LinkedHashSet<UpdateTask> existingTasks = this.updateTasksPerExecutor.get(clusterStateTaskExecutor);
                                if (existingTasks != null) {
                                    existingTasks.removeAll(toRemove);
                                    if (existingTasks.isEmpty()) {
                                        this.updateTasksPerExecutor.remove(clusterStateTaskExecutor);
                                    }
                                }
                            }
                            for (UpdateTask task : toRemove) {
                                task.listener.onFailure(source, new ProcessClusterEventTimeoutException(timeout, source));
                            }
                        }
                    }));
                } else {
                    this.updateTasksExecutor.execute(firstTask);
                }
            }
            catch (EsRejectedExecutionException e) {
                if (this.lifecycle.stoppedOrClosed()) break block10;
                throw e;
            }
        }
    }

    public List<PendingClusterTask> pendingTasks() {
        PrioritizedEsThreadPoolExecutor.Pending[] pendings = this.updateTasksExecutor.getPending();
        ArrayList<PendingClusterTask> pendingClusterTasks = new ArrayList<PendingClusterTask>(pendings.length);
        for (PrioritizedEsThreadPoolExecutor.Pending pending : pendings) {
            long timeInQueue;
            String source;
            Object task = pending.task;
            if (task == null) continue;
            if (task instanceof SourcePrioritizedRunnable) {
                SourcePrioritizedRunnable runnable = (SourcePrioritizedRunnable)task;
                source = runnable.source();
                timeInQueue = runnable.getAgeInMillis();
            } else {
                assert (false) : "expected SourcePrioritizedRunnable got " + task.getClass();
                source = "unknown [" + task.getClass() + "]";
                timeInQueue = 0L;
            }
            pendingClusterTasks.add(new PendingClusterTask(pending.insertionOrder, pending.priority, new Text(source), timeInQueue, pending.executing));
        }
        return pendingClusterTasks;
    }

    public int numberOfPendingTasks() {
        return this.updateTasksExecutor.getNumberOfPendingTasks();
    }

    public TimeValue getMaxTaskWaitTime() {
        return this.updateTasksExecutor.getMaxTaskWaitTime();
    }

    public static boolean assertClusterStateThread() {
        assert (Thread.currentThread().getName().contains(UPDATE_THREAD_NAME)) : "not called from the cluster state update thread";
        return true;
    }

    public static boolean assertNotClusterStateUpdateThread(String reason) {
        assert (!Thread.currentThread().getName().contains(UPDATE_THREAD_NAME)) : "Expected current thread [" + Thread.currentThread() + "] to not be the cluster state update thread. Reason: [" + reason + "]";
        return true;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void runTasksForExecutor(ClusterStateTaskExecutor<T> executor) {
        ClusterStateTaskExecutor.BatchResult<T> batchResult;
        ArrayList<UpdateTask> toExecute = new ArrayList<UpdateTask>();
        HashMap<String, ArrayList> processTasksBySource = new HashMap<String, ArrayList>();
        Map<ClusterStateTaskExecutor, LinkedHashSet<UpdateTask>> map = this.updateTasksPerExecutor;
        synchronized (map) {
            LinkedHashSet<UpdateTask> pending = this.updateTasksPerExecutor.remove(executor);
            if (pending != null) {
                for (UpdateTask task2 : pending) {
                    if (!task2.processed.getAndSet(true)) {
                        this.logger.trace("will process {}", (Object)task2);
                        toExecute.add(task2);
                        processTasksBySource.computeIfAbsent(task2.source, s -> new ArrayList()).add(task2.task);
                        continue;
                    }
                    this.logger.trace("skipping {}, already processed", (Object)task2);
                }
            }
        }
        if (toExecute.isEmpty()) {
            return;
        }
        String tasksSummary = processTasksBySource.entrySet().stream().map(entry -> {
            String tasks = executor.describeTasks((List)entry.getValue());
            return tasks.isEmpty() ? (String)entry.getKey() : (String)entry.getKey() + "[" + tasks + "]";
        }).reduce((s1, s2) -> s1 + ", " + s2).orElse("");
        if (!this.lifecycle.started()) {
            this.logger.debug("processing [{}]: ignoring, cluster_service not started", (Object)tasksSummary);
            return;
        }
        this.logger.debug("processing [{}]: execute", (Object)tasksSummary);
        ClusterState previousClusterState = this.clusterState;
        if (!previousClusterState.nodes().isLocalNodeElectedMaster() && executor.runOnlyOnMaster()) {
            this.logger.debug("failing [{}]: local node is no longer master", (Object)tasksSummary);
            toExecute.stream().forEach(task -> task.listener.onNoLongerMaster(task.source));
            return;
        }
        long startTimeNS = this.currentTimeInNanos();
        try {
            List inputs = toExecute.stream().map(tUpdateTask -> tUpdateTask.task).collect(Collectors.toList());
            batchResult = executor.execute(previousClusterState, inputs);
        }
        catch (Exception e) {
            TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(this.currentTimeInNanos() - startTimeNS)));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(() -> new ParameterizedMessage("failed to execute cluster state update in [{}], state:\nversion [{}], source [{}]\n{}{}{}", new Object[]{executionTime, previousClusterState.version(), tasksSummary, previousClusterState.nodes(), previousClusterState.routingTable(), previousClusterState.getRoutingNodes()}), (Throwable)e);
            }
            this.warnAboutSlowTaskIfNeeded(executionTime, tasksSummary);
            batchResult = ClusterStateTaskExecutor.BatchResult.builder().failures(toExecute.stream().map(updateTask -> updateTask.task)::iterator, e).build(previousClusterState);
        }
        assert (batchResult.executionResults != null);
        assert (batchResult.executionResults.size() == toExecute.size()) : String.format(Locale.ROOT, "expected [%d] task result%s but was [%d]", toExecute.size(), toExecute.size() == 1 ? "" : "s", batchResult.executionResults.size());
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertsEnabled) {
            for (UpdateTask updateTask2 : toExecute) {
                assert (batchResult.executionResults.containsKey(updateTask2.task)) : "missing task result for " + updateTask2;
            }
        }
        ClusterState newClusterState = batchResult.resultingState;
        ArrayList<UpdateTask> proccessedListeners = new ArrayList<UpdateTask>();
        for (UpdateTask updateTask3 : toExecute) {
            assert (batchResult.executionResults.containsKey(updateTask3.task)) : "missing " + updateTask3;
            ClusterStateTaskExecutor.TaskResult executionResult = batchResult.executionResults.get(updateTask3.task);
            executionResult.handle(() -> proccessedListeners.add(updateTask3), ex -> {
                this.logger.debug(() -> new ParameterizedMessage("cluster state update task {} failed", (Object)updateTask3), (Throwable)ex);
                updateTask.listener.onFailure(updateTask.source, (Exception)ex);
            });
        }
        if (previousClusterState == newClusterState) {
            for (UpdateTask task3 : proccessedListeners) {
                if (task3.listener instanceof AckedClusterStateTaskListener) {
                    ((AckedClusterStateTaskListener)task3.listener).onAllNodesAcked(null);
                }
                task3.listener.clusterStateProcessed(task3.source, previousClusterState, newClusterState);
            }
            TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(this.currentTimeInNanos() - startTimeNS)));
            this.logger.debug("processing [{}]: took [{}] no change in cluster_state", (Object)tasksSummary, (Object)executionTime);
            this.warnAboutSlowTaskIfNeeded(executionTime, tasksSummary);
            return;
        }
        try {
            String summary;
            ArrayList<AckCountDownListener> ackListeners = new ArrayList<AckCountDownListener>();
            if (newClusterState.nodes().isLocalNodeElectedMaster()) {
                ClusterState.Builder builder = ClusterState.builder(newClusterState).incrementVersion();
                if (previousClusterState.routingTable() != newClusterState.routingTable()) {
                    builder.routingTable(RoutingTable.builder(newClusterState.routingTable()).version(newClusterState.routingTable().version() + 1L).build());
                }
                if (previousClusterState.metaData() != newClusterState.metaData()) {
                    builder.metaData(MetaData.builder(newClusterState.metaData()).version(newClusterState.metaData().version() + 1L));
                }
                newClusterState = builder.build();
                for (UpdateTask task4 : proccessedListeners) {
                    if (!(task4.listener instanceof AckedClusterStateTaskListener)) continue;
                    AckedClusterStateTaskListener ackedListener = (AckedClusterStateTaskListener)task4.listener;
                    if (ackedListener.ackTimeout() == null || ackedListener.ackTimeout().millis() == 0L) {
                        ackedListener.onAckTimeout();
                        continue;
                    }
                    try {
                        ackListeners.add(new AckCountDownListener(ackedListener, newClusterState.version(), newClusterState.nodes(), this.threadPool));
                    }
                    catch (EsRejectedExecutionException ex2) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Couldn't schedule timeout thread - node might be shutting down", (Throwable)ex2);
                        }
                        ackedListener.onAckTimeout();
                    }
                }
            }
            DelegetingAckListener ackListener = new DelegetingAckListener(ackListeners);
            newClusterState.status(ClusterState.ClusterStateStatus.BEING_APPLIED);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("cluster state updated, source [{}]\n{}", (Object)tasksSummary, (Object)newClusterState);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("cluster state updated, version [{}], source [{}]", (Object)newClusterState.version(), (Object)tasksSummary);
            }
            ClusterChangedEvent clusterChangedEvent = new ClusterChangedEvent(tasksSummary, newClusterState, previousClusterState);
            DiscoveryNodes.Delta nodesDelta = clusterChangedEvent.nodesDelta();
            if (nodesDelta.hasChanges() && this.logger.isInfoEnabled() && (summary = nodesDelta.shortSummary()).length() > 0) {
                this.logger.info("{}, reason: {}", (Object)summary, (Object)tasksSummary);
            }
            this.nodeConnectionsService.connectToNodes(clusterChangedEvent.nodesDelta().addedNodes());
            if (newClusterState.nodes().isLocalNodeElectedMaster()) {
                this.logger.debug("publishing cluster state version [{}]", (Object)newClusterState.version());
                try {
                    this.clusterStatePublisher.accept(clusterChangedEvent, ackListener);
                }
                catch (Discovery.FailedToCommitClusterStateException t) {
                    long version = newClusterState.version();
                    this.logger.warn(() -> new ParameterizedMessage("failing [{}]: failed to commit cluster state version [{}]", (Object)tasksSummary, (Object)version), (Throwable)t);
                    this.nodeConnectionsService.disconnectFromNodes(clusterChangedEvent.nodesDelta().addedNodes());
                    proccessedListeners.forEach(task -> task.listener.onFailure(task.source, t));
                    return;
                }
            }
            this.clusterState = newClusterState;
            this.logger.debug("set local cluster state to version {}", (Object)newClusterState.version());
            try {
                if (!clusterChangedEvent.state().blocks().disableStatePersistence() && clusterChangedEvent.metaDataChanged()) {
                    Settings incomingSettings = clusterChangedEvent.state().metaData().settings();
                    this.clusterSettings.applySettings(incomingSettings);
                }
            }
            catch (Exception ex3) {
                this.logger.warn("failed to apply cluster settings", (Throwable)ex3);
            }
            for (ClusterStateListener listener : this.preAppliedListeners) {
                try {
                    listener.clusterChanged(clusterChangedEvent);
                }
                catch (Exception ex4) {
                    this.logger.warn("failed to notify ClusterStateListener", (Throwable)ex4);
                }
            }
            this.nodeConnectionsService.disconnectFromNodes(clusterChangedEvent.nodesDelta().removedNodes());
            newClusterState.status(ClusterState.ClusterStateStatus.APPLIED);
            for (ClusterStateListener listener : this.postAppliedListeners) {
                try {
                    listener.clusterChanged(clusterChangedEvent);
                }
                catch (Exception ex5) {
                    this.logger.warn("failed to notify ClusterStateListener", (Throwable)ex5);
                }
            }
            if (newClusterState.nodes().isLocalNodeElectedMaster()) {
                try {
                    ackListener.onNodeAck(newClusterState.nodes().getLocalNode(), null);
                }
                catch (Exception e) {
                    DiscoveryNode localNode = newClusterState.nodes().getLocalNode();
                    this.logger.debug(() -> new ParameterizedMessage("error while processing ack for master node [{}]", (Object)localNode), (Throwable)e);
                }
            }
            for (UpdateTask task5 : proccessedListeners) {
                task5.listener.clusterStateProcessed(task5.source, previousClusterState, newClusterState);
            }
            try {
                executor.clusterStatePublished(clusterChangedEvent);
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("exception thrown while notifying executor of new cluster state publication [{}]", (Object)tasksSummary), (Throwable)e);
            }
            TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(this.currentTimeInNanos() - startTimeNS)));
            this.logger.debug("processing [{}]: took [{}] done applying updated cluster_state (version: {}, uuid: {})", (Object)tasksSummary, (Object)executionTime, (Object)newClusterState.version(), (Object)newClusterState.stateUUID());
            this.warnAboutSlowTaskIfNeeded(executionTime, tasksSummary);
        }
        catch (Exception e) {
            TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(this.currentTimeInNanos() - startTimeNS)));
            long version = newClusterState.version();
            String stateUUID = newClusterState.stateUUID();
            String fullState = newClusterState.toString();
            this.logger.warn(() -> new ParameterizedMessage("failed to apply updated cluster state in [{}]:\nversion [{}], uuid [{}], source [{}]\n{}", new Object[]{executionTime, version, stateUUID, tasksSummary, fullState}), (Throwable)e);
        }
    }

    protected long currentTimeInNanos() {
        return System.nanoTime();
    }

    private static SafeClusterStateTaskListener safe(ClusterStateTaskListener listener, Logger logger) {
        if (listener instanceof AckedClusterStateTaskListener) {
            return new SafeAckedClusterStateTaskListener((AckedClusterStateTaskListener)listener, logger);
        }
        return new SafeClusterStateTaskListener(listener, logger);
    }

    private void warnAboutSlowTaskIfNeeded(TimeValue executionTime, String source) {
        if (executionTime.getMillis() > this.slowTaskLoggingThreshold.getMillis()) {
            this.logger.warn("cluster state update task [{}] took [{}] above the warn threshold of {}", (Object)source, (Object)executionTime, (Object)this.slowTaskLoggingThreshold);
        }
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    private static class AckCountDownListener
    implements Discovery.AckListener {
        private static final Logger logger = Loggers.getLogger(AckCountDownListener.class);
        private final AckedClusterStateTaskListener ackedTaskListener;
        private final CountDown countDown;
        private final DiscoveryNodes nodes;
        private final long clusterStateVersion;
        private final Future<?> ackTimeoutCallback;
        private Exception lastFailure;

        AckCountDownListener(AckedClusterStateTaskListener ackedTaskListener, long clusterStateVersion, DiscoveryNodes nodes, ThreadPool threadPool) {
            this.ackedTaskListener = ackedTaskListener;
            this.clusterStateVersion = clusterStateVersion;
            this.nodes = nodes;
            int countDown = 0;
            for (DiscoveryNode node : nodes) {
                if (!ackedTaskListener.mustAck(node)) continue;
                ++countDown;
            }
            countDown = Math.max(1, countDown);
            logger.trace("expecting {} acknowledgements for cluster_state update (version: {})", (Object)countDown, (Object)clusterStateVersion);
            this.countDown = new CountDown(countDown);
            this.ackTimeoutCallback = threadPool.schedule(ackedTaskListener.ackTimeout(), "generic", new Runnable(){

                @Override
                public void run() {
                    this.onTimeout();
                }
            });
        }

        @Override
        public void onNodeAck(DiscoveryNode node, @Nullable Exception e) {
            if (!this.ackedTaskListener.mustAck(node) && !node.equals(this.nodes.getMasterNode())) {
                return;
            }
            if (e == null) {
                logger.trace("ack received from node [{}], cluster_state update (version: {})", (Object)node, (Object)this.clusterStateVersion);
            } else {
                this.lastFailure = e;
                logger.debug(() -> new ParameterizedMessage("ack received from node [{}], cluster_state update (version: {})", (Object)node, (Object)this.clusterStateVersion), (Throwable)e);
            }
            if (this.countDown.countDown()) {
                logger.trace("all expected nodes acknowledged cluster_state update (version: {})", (Object)this.clusterStateVersion);
                FutureUtils.cancel(this.ackTimeoutCallback);
                this.ackedTaskListener.onAllNodesAcked(this.lastFailure);
            }
        }

        @Override
        public void onTimeout() {
            if (this.countDown.fastForward()) {
                logger.trace("timeout waiting for acknowledgement for cluster_state update (version: {})", (Object)this.clusterStateVersion);
                this.ackedTaskListener.onAckTimeout();
            }
        }
    }

    private static class DelegetingAckListener
    implements Discovery.AckListener {
        private final List<Discovery.AckListener> listeners;

        private DelegetingAckListener(List<Discovery.AckListener> listeners) {
            this.listeners = listeners;
        }

        @Override
        public void onNodeAck(DiscoveryNode node, @Nullable Exception e) {
            for (Discovery.AckListener listener : this.listeners) {
                listener.onNodeAck(node, e);
            }
        }

        @Override
        public void onTimeout() {
            throw new UnsupportedOperationException("no timeout delegation");
        }
    }

    private static class OffMasterRunnable
    implements Runnable {
        private final LocalNodeMasterListener listener;

        private OffMasterRunnable(LocalNodeMasterListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            this.listener.offMaster();
        }
    }

    private static class OnMasterRunnable
    implements Runnable {
        private final LocalNodeMasterListener listener;

        private OnMasterRunnable(LocalNodeMasterListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            this.listener.onMaster();
        }
    }

    private static class LocalNodeMasterListeners
    implements ClusterStateListener {
        private final List<LocalNodeMasterListener> listeners = new CopyOnWriteArrayList<LocalNodeMasterListener>();
        private final ThreadPool threadPool;
        private volatile boolean master = false;

        private LocalNodeMasterListeners(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        @Override
        public void clusterChanged(ClusterChangedEvent event) {
            if (!this.master && event.localNodeMaster()) {
                this.master = true;
                for (LocalNodeMasterListener listener : this.listeners) {
                    ExecutorService executor = this.threadPool.executor(listener.executorName());
                    executor.execute(new OnMasterRunnable(listener));
                }
                return;
            }
            if (this.master && !event.localNodeMaster()) {
                this.master = false;
                for (LocalNodeMasterListener listener : this.listeners) {
                    ExecutorService executor = this.threadPool.executor(listener.executorName());
                    executor.execute(new OffMasterRunnable(listener));
                }
            }
        }

        private void add(LocalNodeMasterListener listener) {
            this.listeners.add(listener);
        }

        private void remove(LocalNodeMasterListener listener) {
            this.listeners.remove(listener);
        }

        private void clear() {
            this.listeners.clear();
        }
    }

    class NotifyTimeout
    implements Runnable {
        final TimeoutClusterStateListener listener;
        final TimeValue timeout;
        volatile ScheduledFuture future;

        NotifyTimeout(TimeoutClusterStateListener listener, TimeValue timeout) {
            this.listener = listener;
            this.timeout = timeout;
        }

        public void cancel() {
            FutureUtils.cancel(this.future);
        }

        @Override
        public void run() {
            if (this.future != null && this.future.isCancelled()) {
                return;
            }
            if (ClusterService.this.lifecycle.stoppedOrClosed()) {
                this.listener.onClose();
            } else {
                this.listener.onTimeout(this.timeout);
            }
        }
    }

    class UpdateTask<T>
    extends SourcePrioritizedRunnable {
        public final T task;
        public final ClusterStateTaskListener listener;
        private final ClusterStateTaskExecutor<T> executor;
        public final AtomicBoolean processed;

        UpdateTask(String source, T task, Priority priority, ClusterStateTaskExecutor<T> executor, ClusterStateTaskListener listener) {
            super(priority, source);
            this.processed = new AtomicBoolean();
            this.task = task;
            this.executor = executor;
            this.listener = listener;
        }

        @Override
        public void run() {
            if (!this.processed.get()) {
                ClusterService.this.runTasksForExecutor(this.executor);
            }
        }

        public String toString() {
            String taskDescription = this.executor.describeTasks(Collections.singletonList(this.task));
            if (taskDescription.isEmpty()) {
                return "[" + this.source + "]";
            }
            return "[" + this.source + "[" + taskDescription + "]]";
        }
    }

    private static class SafeAckedClusterStateTaskListener
    extends SafeClusterStateTaskListener
    implements AckedClusterStateTaskListener {
        private final AckedClusterStateTaskListener listener;
        private final Logger logger;

        public SafeAckedClusterStateTaskListener(AckedClusterStateTaskListener listener, Logger logger) {
            super(listener, logger);
            this.listener = listener;
            this.logger = logger;
        }

        @Override
        public boolean mustAck(DiscoveryNode discoveryNode) {
            return this.listener.mustAck(discoveryNode);
        }

        @Override
        public void onAllNodesAcked(@Nullable Exception e) {
            try {
                this.listener.onAllNodesAcked(e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.logger.error("exception thrown by listener while notifying on all nodes acked", (Throwable)inner);
            }
        }

        @Override
        public void onAckTimeout() {
            try {
                this.listener.onAckTimeout();
            }
            catch (Exception e) {
                this.logger.error("exception thrown by listener while notifying on ack timeout", (Throwable)e);
            }
        }

        @Override
        public TimeValue ackTimeout() {
            return this.listener.ackTimeout();
        }
    }

    private static class SafeClusterStateTaskListener
    implements ClusterStateTaskListener {
        private final ClusterStateTaskListener listener;
        private final Logger logger;

        public SafeClusterStateTaskListener(ClusterStateTaskListener listener, Logger logger) {
            this.listener = listener;
            this.logger = logger;
        }

        @Override
        public void onFailure(String source, Exception e) {
            try {
                this.listener.onFailure(source, e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.logger.error(() -> new ParameterizedMessage("exception thrown by listener notifying of failure from [{}]", (Object)source), (Throwable)inner);
            }
        }

        @Override
        public void onNoLongerMaster(String source) {
            try {
                this.listener.onNoLongerMaster(source);
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("exception thrown by listener while notifying no longer master from [{}]", (Object)source), (Throwable)e);
            }
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            try {
                this.listener.clusterStateProcessed(source, oldState, newState);
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("exception thrown by listener while notifying of cluster state processed from [{}], old cluster state:\n{}\nnew cluster state:\n{}", new Object[]{source, oldState, newState}), (Throwable)e);
            }
        }
    }

    static abstract class SourcePrioritizedRunnable
    extends PrioritizedRunnable {
        protected final String source;

        public SourcePrioritizedRunnable(Priority priority, String source) {
            super(priority);
            this.source = source;
        }

        public String source() {
            return this.source;
        }
    }
}

