/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filters;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.filters.FiltersAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.internal.ContextIndexSearcher;

public class FiltersAggregatorFactory
extends AggregatorFactory<FiltersAggregatorFactory> {
    private final String[] keys;
    private final Weight[] weights;
    private final boolean keyed;
    private final boolean otherBucket;
    private final String otherBucketKey;

    public FiltersAggregatorFactory(String name, InternalAggregation.Type type, List<FiltersAggregator.KeyedFilter> filters, boolean keyed, boolean otherBucket, String otherBucketKey, AggregationContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactories, Map<String, Object> metaData) throws IOException {
        super(name, type, context, parent, subFactories, metaData);
        this.keyed = keyed;
        this.otherBucket = otherBucket;
        this.otherBucketKey = otherBucketKey;
        ContextIndexSearcher contextSearcher = context.searchContext().searcher();
        this.weights = new Weight[filters.size()];
        this.keys = new String[filters.size()];
        for (int i = 0; i < filters.size(); ++i) {
            FiltersAggregator.KeyedFilter keyedFilter = filters.get(i);
            this.keys[i] = keyedFilter.key();
            Query filter = keyedFilter.filter().toFilter(context.searchContext().getQueryShardContext());
            this.weights[i] = contextSearcher.createNormalizedWeight(filter, false);
        }
    }

    @Override
    public Aggregator createInternal(Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new FiltersAggregator(this.name, this.factories, this.keys, this.weights, this.keyed, this.otherBucket ? this.otherBucketKey : null, this.context, parent, pipelineAggregators, metaData);
    }
}

