/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;
import org.joda.time.DateTimeZone;

public abstract class ValuesSourceAggregationBuilder<VS extends ValuesSource, AB extends ValuesSourceAggregationBuilder<VS, AB>>
extends AbstractAggregationBuilder<AB> {
    private final ValuesSourceType valuesSourceType;
    private final ValueType targetValueType;
    private String field = null;
    private Script script = null;
    private ValueType valueType = null;
    private String format = null;
    private Object missing = null;
    private DateTimeZone timeZone = null;
    protected ValuesSourceConfig<VS> config;

    protected ValuesSourceAggregationBuilder(String name, InternalAggregation.Type type, ValuesSourceType valuesSourceType, ValueType targetValueType) {
        super(name, type);
        if (valuesSourceType == null) {
            throw new IllegalArgumentException("[valuesSourceType] must not be null: [" + name + "]");
        }
        this.valuesSourceType = valuesSourceType;
        this.targetValueType = targetValueType;
    }

    protected ValuesSourceAggregationBuilder(StreamInput in, InternalAggregation.Type type, ValuesSourceType valuesSourceType, ValueType targetValueType) throws IOException {
        super(in, type);
        assert (!this.serializeTargetValueType()) : "Wrong read constructor called for subclass that provides its targetValueType";
        this.valuesSourceType = valuesSourceType;
        this.targetValueType = targetValueType;
        this.read(in);
    }

    protected ValuesSourceAggregationBuilder(StreamInput in, InternalAggregation.Type type, ValuesSourceType valuesSourceType) throws IOException {
        super(in, type);
        assert (this.serializeTargetValueType()) : "Wrong read constructor called for subclass that serializes its targetValueType";
        this.valuesSourceType = valuesSourceType;
        this.targetValueType = in.readOptionalWriteable(ValueType::readFromStream);
        this.read(in);
    }

    private void read(StreamInput in) throws IOException {
        this.field = in.readOptionalString();
        if (in.readBoolean()) {
            this.script = new Script(in);
        }
        if (in.readBoolean()) {
            this.valueType = ValueType.readFromStream(in);
        }
        this.format = in.readOptionalString();
        this.missing = in.readGenericValue();
        if (in.readBoolean()) {
            this.timeZone = DateTimeZone.forID((String)in.readString());
        }
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        if (this.serializeTargetValueType()) {
            out.writeOptionalWriteable(this.targetValueType);
        }
        out.writeOptionalString(this.field);
        boolean hasScript = this.script != null;
        out.writeBoolean(hasScript);
        if (hasScript) {
            this.script.writeTo(out);
        }
        boolean hasValueType = this.valueType != null;
        out.writeBoolean(hasValueType);
        if (hasValueType) {
            this.valueType.writeTo(out);
        }
        out.writeOptionalString(this.format);
        out.writeGenericValue(this.missing);
        boolean hasTimeZone = this.timeZone != null;
        out.writeBoolean(hasTimeZone);
        if (hasTimeZone) {
            out.writeString(this.timeZone.getID());
        }
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    protected boolean serializeTargetValueType() {
        return false;
    }

    public AB field(String field) {
        if (field == null) {
            throw new IllegalArgumentException("[field] must not be null: [" + this.name + "]");
        }
        this.field = field;
        return (AB)this;
    }

    public String field() {
        return this.field;
    }

    public AB script(Script script) {
        if (script == null) {
            throw new IllegalArgumentException("[script] must not be null: [" + this.name + "]");
        }
        this.script = script;
        return (AB)this;
    }

    public Script script() {
        return this.script;
    }

    public AB valueType(ValueType valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("[valueType] must not be null: [" + this.name + "]");
        }
        this.valueType = valueType;
        return (AB)this;
    }

    public ValueType valueType() {
        return this.valueType;
    }

    public AB format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return (AB)this;
    }

    public String format() {
        return this.format;
    }

    public AB missing(Object missing) {
        if (missing == null) {
            throw new IllegalArgumentException("[missing] must not be null: [" + this.name + "]");
        }
        this.missing = missing;
        return (AB)this;
    }

    public Object missing() {
        return this.missing;
    }

    public AB timeZone(DateTimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("[timeZone] must not be null: [" + this.name + "]");
        }
        this.timeZone = timeZone;
        return (AB)this;
    }

    public DateTimeZone timeZone() {
        return this.timeZone;
    }

    protected final ValuesSourceAggregatorFactory<VS, ?> doBuild(AggregationContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        ValuesSourceConfig<VS> config = this.resolveConfig(context);
        ValuesSourceAggregatorFactory<VS, ?> factory = this.innerBuild(context, config, parent, subFactoriesBuilder);
        return factory;
    }

    protected ValuesSourceConfig<VS> resolveConfig(AggregationContext context) {
        ValuesSourceConfig<VS> config = this.config(context);
        return config;
    }

    protected abstract ValuesSourceAggregatorFactory<VS, ?> innerBuild(AggregationContext var1, ValuesSourceConfig<VS> var2, AggregatorFactory<?> var3, AggregatorFactories.Builder var4) throws IOException;

    public ValuesSourceConfig<VS> config(AggregationContext context) {
        ValueType valueType;
        ValueType valueType2 = valueType = this.valueType != null ? this.valueType : this.targetValueType;
        if (this.field == null) {
            ValuesSourceType valuesSourceType;
            if (this.script == null) {
                ValuesSourceConfig config = new ValuesSourceConfig(ValuesSourceType.ANY);
                config.format(ValuesSourceAggregationBuilder.resolveFormat(null, valueType));
                return config;
            }
            ValuesSourceType valuesSourceType2 = valuesSourceType = valueType != null ? valueType.getValuesSourceType() : this.valuesSourceType;
            if (valuesSourceType == null || valuesSourceType == ValuesSourceType.ANY) {
                valuesSourceType = ValuesSourceType.BYTES;
            }
            ValuesSourceConfig config = new ValuesSourceConfig(valuesSourceType);
            config.missing(this.missing);
            config.timezone(this.timeZone);
            config.format(ValuesSourceAggregationBuilder.resolveFormat(this.format, valueType));
            config.script(this.createScript(this.script, context.searchContext()));
            config.scriptValueType(valueType);
            return config;
        }
        MappedFieldType fieldType = context.searchContext().smartNameFieldType(this.field);
        if (fieldType == null) {
            ValuesSourceType valuesSourceType = valueType != null ? valueType.getValuesSourceType() : this.valuesSourceType;
            ValuesSourceConfig config = new ValuesSourceConfig(valuesSourceType);
            config.missing(this.missing);
            config.timezone(this.timeZone);
            config.format(ValuesSourceAggregationBuilder.resolveFormat(this.format, valueType));
            config.unmapped(true);
            if (valueType != null) {
                config.scriptValueType(valueType);
            }
            return config;
        }
        Object indexFieldData = context.searchContext().fieldData().getForField(fieldType);
        ValuesSourceConfig config = this.valuesSourceType == ValuesSourceType.ANY ? (indexFieldData instanceof IndexNumericFieldData ? new ValuesSourceConfig(ValuesSourceType.NUMERIC) : (indexFieldData instanceof IndexGeoPointFieldData ? new ValuesSourceConfig(ValuesSourceType.GEOPOINT) : new ValuesSourceConfig(ValuesSourceType.BYTES))) : new ValuesSourceConfig(this.valuesSourceType);
        config.fieldContext(new FieldContext(this.field, (IndexFieldData<?>)indexFieldData, fieldType));
        config.missing(this.missing);
        config.timezone(this.timeZone);
        config.script(this.createScript(this.script, context.searchContext()));
        config.format(fieldType.docValueFormat(this.format, this.timeZone));
        return config;
    }

    private SearchScript createScript(Script script, SearchContext context) {
        if (script == null) {
            return null;
        }
        return context.getQueryShardContext().getSearchScript(script, ScriptContext.Standard.AGGS);
    }

    private static DocValueFormat resolveFormat(@Nullable String format, @Nullable ValueType valueType) {
        if (valueType == null) {
            return DocValueFormat.RAW;
        }
        DocValueFormat valueFormat = valueType.defaultFormat;
        if (valueFormat instanceof DocValueFormat.Decimal && format != null) {
            valueFormat = new DocValueFormat.Decimal(format);
        }
        return valueFormat;
    }

    @Override
    public final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.script != null) {
            builder.field("script", this.script);
        }
        if (this.missing != null) {
            builder.field("missing", this.missing);
        }
        if (this.format != null) {
            builder.field("format", this.format);
        }
        if (this.timeZone != null) {
            builder.field("time_zone", this.timeZone);
        }
        if (this.valueType != null) {
            builder.field("value_type", this.valueType.getPreferredName());
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    protected final int doHashCode() {
        return Objects.hash(new Object[]{this.field, this.format, this.missing, this.script, this.targetValueType, this.timeZone, this.valueType, this.valuesSourceType, this.innerHashCode()});
    }

    protected abstract int innerHashCode();

    @Override
    protected final boolean doEquals(Object obj) {
        ValuesSourceAggregationBuilder other = (ValuesSourceAggregationBuilder)obj;
        if (!Objects.equals(this.field, other.field)) {
            return false;
        }
        if (!Objects.equals(this.format, other.format)) {
            return false;
        }
        if (!Objects.equals(this.missing, other.missing)) {
            return false;
        }
        if (!Objects.equals(this.script, other.script)) {
            return false;
        }
        if (!Objects.equals(this.targetValueType, other.targetValueType)) {
            return false;
        }
        if (!Objects.equals(this.timeZone, other.timeZone)) {
            return false;
        }
        if (!Objects.equals(this.valueType, other.valueType)) {
            return false;
        }
        if (!Objects.equals((Object)this.valuesSourceType, (Object)other.valuesSourceType)) {
            return false;
        }
        return this.innerEquals(obj);
    }

    protected abstract boolean innerEquals(Object var1);

    public static abstract class LeafOnly<VS extends ValuesSource, AB extends ValuesSourceAggregationBuilder<VS, AB>>
    extends ValuesSourceAggregationBuilder<VS, AB> {
        protected LeafOnly(String name, InternalAggregation.Type type, ValuesSourceType valuesSourceType, ValueType targetValueType) {
            super(name, type, valuesSourceType, targetValueType);
        }

        protected LeafOnly(StreamInput in, InternalAggregation.Type type, ValuesSourceType valuesSourceType, ValueType targetValueType) throws IOException {
            super(in, type, valuesSourceType, targetValueType);
        }

        protected LeafOnly(StreamInput in, InternalAggregation.Type type, ValuesSourceType valuesSourceType) throws IOException {
            super(in, type, valuesSourceType);
        }

        @Override
        public AB subAggregations(AggregatorFactories.Builder subFactories) {
            throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.type + "] cannot accept sub-aggregations");
        }
    }
}

