/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.percolator.PercolateRequest;
import org.elasticsearch.percolator.PercolateRequestBuilder;

@Deprecated
public class MultiPercolateRequest
extends ActionRequest
implements CompositeIndicesRequest {
    private String[] indices;
    private String documentType;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenAndForbidClosed();
    private List<PercolateRequest> requests = new ArrayList<PercolateRequest>();

    public MultiPercolateRequest add(PercolateRequestBuilder requestBuilder) {
        return this.add(requestBuilder.request());
    }

    public MultiPercolateRequest add(PercolateRequest request) {
        if (request.indices() == null && this.indices != null) {
            request.indices(this.indices);
        }
        if (request.documentType() == null && this.documentType != null) {
            request.documentType(this.documentType);
        }
        if (request.indicesOptions() == IndicesOptions.strictExpandOpenAndForbidClosed() && this.indicesOptions != IndicesOptions.strictExpandOpenAndForbidClosed()) {
            request.indicesOptions(this.indicesOptions);
        }
        this.requests.add(request);
        return this;
    }

    public MultiPercolateRequest add(byte[] data, int from, int length) throws Exception {
        return this.add((BytesReference)new BytesArray(data, from, length), true);
    }

    public MultiPercolateRequest add(BytesReference data, boolean allowExplicitIndex) throws IOException {
        int nextMarker;
        XContent xContent = XContentFactory.xContent((BytesReference)data);
        int from = 0;
        int length = data.length();
        byte marker = xContent.streamSeparator();
        while ((nextMarker = this.findNextMarker(marker, from, data, length)) != -1) {
            PercolateRequest percolateRequest;
            block23: {
                if (nextMarker == 0) {
                    from = nextMarker + 1;
                    continue;
                }
                percolateRequest = new PercolateRequest();
                if (this.indices != null) {
                    percolateRequest.indices(this.indices);
                }
                if (this.documentType != null) {
                    percolateRequest.documentType(this.documentType);
                }
                if (this.indicesOptions != IndicesOptions.strictExpandOpenAndForbidClosed()) {
                    percolateRequest.indicesOptions(this.indicesOptions);
                }
                if (nextMarker - from > 0) {
                    try (XContentParser parser = xContent.createParser(data.slice(from, nextMarker - from));){
                        XContentParser.Token token = parser.nextToken();
                        if (token == null) break block23;
                        assert (token == XContentParser.Token.START_OBJECT);
                        token = parser.nextToken();
                        if (token != XContentParser.Token.FIELD_NAME) {
                            throw new ElasticsearchParseException("Expected field", new Object[0]);
                        }
                        token = parser.nextToken();
                        if (token != XContentParser.Token.START_OBJECT) {
                            throw new ElasticsearchParseException("expected start object", new Object[0]);
                        }
                        String percolateAction = parser.currentName();
                        if ("percolate".equals(percolateAction)) {
                            this.parsePercolateAction(parser, percolateRequest, allowExplicitIndex);
                            break block23;
                        }
                        if ("count".equals(percolateAction)) {
                            percolateRequest.onlyCount(true);
                            this.parsePercolateAction(parser, percolateRequest, allowExplicitIndex);
                            break block23;
                        }
                        throw new ElasticsearchParseException("[{}] isn't a supported percolate operation", new Object[]{percolateAction});
                    }
                }
            }
            if ((nextMarker = this.findNextMarker(marker, from = nextMarker + 1, data, length)) == -1) break;
            percolateRequest.source(data.slice(from, nextMarker - from));
            from = nextMarker + 1;
            this.add(percolateRequest);
        }
        return this;
    }

    public List<? extends IndicesRequest> subRequests() {
        return this.requests;
    }

    private void parsePercolateAction(XContentParser parser, PercolateRequest percolateRequest, boolean allowExplicitIndex) throws IOException {
        String globalIndex = this.indices != null && this.indices.length > 0 ? this.indices[0] : null;
        Map header = parser.map();
        if (header.containsKey("id")) {
            GetRequest getRequest = new GetRequest(globalIndex);
            percolateRequest.getRequest(getRequest);
            for (Map.Entry entry : header.entrySet()) {
                Object value = entry.getValue();
                if ("id".equals(entry.getKey())) {
                    getRequest.id(XContentMapValues.nodeStringValue(value, null));
                    header.put("id", entry.getValue());
                    continue;
                }
                if ("index".equals(entry.getKey()) || "indices".equals(entry.getKey())) {
                    if (!allowExplicitIndex) {
                        throw new IllegalArgumentException("explicit index in multi percolate is not allowed");
                    }
                    getRequest.index(XContentMapValues.nodeStringValue(value, null));
                    continue;
                }
                if ("type".equals(entry.getKey())) {
                    getRequest.type(XContentMapValues.nodeStringValue(value, null));
                    continue;
                }
                if ("preference".equals(entry.getKey())) {
                    getRequest.preference(XContentMapValues.nodeStringValue(value, null));
                    continue;
                }
                if ("routing".equals(entry.getKey())) {
                    getRequest.routing(XContentMapValues.nodeStringValue(value, null));
                    continue;
                }
                if ("percolate_index".equals(entry.getKey()) || "percolate_indices".equals(entry.getKey()) || "percolateIndex".equals(entry.getKey()) || "percolateIndices".equals(entry.getKey())) {
                    percolateRequest.indices(XContentMapValues.nodeStringArrayValue(value));
                    continue;
                }
                if ("percolate_type".equals(entry.getKey()) || "percolateType".equals(entry.getKey())) {
                    percolateRequest.documentType(XContentMapValues.nodeStringValue(value, null));
                    continue;
                }
                if ("percolate_preference".equals(entry.getKey()) || "percolatePreference".equals(entry.getKey())) {
                    percolateRequest.preference(XContentMapValues.nodeStringValue(value, null));
                    continue;
                }
                if (!"percolate_routing".equals(entry.getKey()) && !"percolateRouting".equals(entry.getKey())) continue;
                percolateRequest.routing(XContentMapValues.nodeStringValue(value, null));
            }
            if ((percolateRequest.indices() == null || percolateRequest.indices().length == 0) && getRequest.index() != null) {
                percolateRequest.indices(getRequest.index());
            }
            if (percolateRequest.documentType() == null && getRequest.type() != null) {
                percolateRequest.documentType(getRequest.type());
            }
            if (percolateRequest.routing() == null && getRequest.routing() != null) {
                percolateRequest.routing(getRequest.routing());
            }
            if (percolateRequest.preference() == null && getRequest.preference() != null) {
                percolateRequest.preference(getRequest.preference());
            }
        } else {
            for (Map.Entry entry : header.entrySet()) {
                Object value = entry.getValue();
                if ("index".equals(entry.getKey()) || "indices".equals(entry.getKey())) {
                    if (!allowExplicitIndex) {
                        throw new IllegalArgumentException("explicit index in multi percolate is not allowed");
                    }
                    percolateRequest.indices(XContentMapValues.nodeStringArrayValue(value));
                    continue;
                }
                if ("type".equals(entry.getKey())) {
                    percolateRequest.documentType(XContentMapValues.nodeStringValue(value, null));
                    continue;
                }
                if ("preference".equals(entry.getKey())) {
                    percolateRequest.preference(XContentMapValues.nodeStringValue(value, null));
                    continue;
                }
                if (!"routing".equals(entry.getKey())) continue;
                percolateRequest.routing(XContentMapValues.nodeStringValue(value, null));
            }
        }
        percolateRequest.indicesOptions(IndicesOptions.fromMap((Map)header, (IndicesOptions)this.indicesOptions));
    }

    private int findNextMarker(byte marker, int from, BytesReference data, int length) {
        for (int i = from; i < length; ++i) {
            if (data.get(i) != marker) continue;
            return i;
        }
        return -1;
    }

    public List<PercolateRequest> requests() {
        return this.requests;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public MultiPercolateRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public MultiPercolateRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public String documentType() {
        return this.documentType;
    }

    public MultiPercolateRequest documentType(String type) {
        this.documentType = type;
        return this;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"no requests added", validationException);
        }
        for (int i = 0; i < this.requests.size(); ++i) {
            ActionRequestValidationException ex = this.requests.get(i).validate();
            if (ex == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors((Iterable)ex.validationErrors());
        }
        return validationException;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.documentType = in.readOptionalString();
        this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            PercolateRequest request = new PercolateRequest();
            request.readFrom(in);
            this.requests.add(request);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        out.writeOptionalString(this.documentType);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeVInt(this.requests.size());
        for (PercolateRequest request : this.requests) {
            request.writeTo(out);
        }
    }
}

