/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.hints;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.analysis.api.AnalyzerResponse;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.syntaxerr.AbstractCodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditFactory;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfoHintProvider;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.highlight.hints.ErrorInfoImpl;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.cnd.refactoring.api.ui.CsmRefactoringActionsFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class NoMatchingConstructor
extends AbstractCodeAudit {
    private NoMatchingConstructor(String id, String name, String description, String defaultSeverity, boolean defaultEnabled, AuditPreferences myPreferences) {
        super(id, name, description, defaultSeverity, defaultEnabled, myPreferences);
    }

    public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
        return kind == CsmErrorProvider.EditorEvent.FileBased;
    }

    public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        CsmFile file = request.getFile();
        if (file != null) {
            if (request.isCancelled()) {
                return;
            }
            this.visit(file.getDeclarations(), request, response);
        }
    }

    private void visit(Collection<? extends CsmOffsetableDeclaration> decls, CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : decls) {
            if (CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) {
                this.visit((CsmClass)csmOffsetableDeclaration, request, response);
                continue;
            }
            if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration)) continue;
            this.visit(((CsmNamespaceDefinition)csmOffsetableDeclaration).getDeclarations(), request, response);
        }
    }

    private void visit(CsmClass csmClass, CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        if (!request.getFile().equals(csmClass.getContainingFile())) {
            return;
        }
        for (Object member : csmClass.getMembers()) {
            if (!CsmKindUtilities.isConstructor((CsmObject)member)) continue;
            return;
        }
        boolean willProduceError = false;
        for (CsmInheritance parent : csmClass.getBaseClasses()) {
            CsmClass parentClass = CsmInheritanceUtilities.getCsmClass((CsmInheritance)parent);
            if (parentClass == null) continue;
            boolean flag = false;
            for (CsmMember member : parentClass.getMembers()) {
                if (!CsmKindUtilities.isConstructor((CsmObject)member)) continue;
                CsmConstructor testedCtor = (CsmConstructor)member;
                Collection parameters = testedCtor.getParameters();
                if (parameters.isEmpty()) {
                    CsmFunctionDefinition definition = testedCtor.getDefinition();
                    if (definition == null) break;
                    flag = definition.getDefinitionKind() == CsmFunctionDefinition.DefinitionKind.DELETE;
                    break;
                }
                CsmParameter first = (CsmParameter)parameters.iterator().next();
                if (first.getInitialValue() != null || first.isVarArgs()) {
                    CsmFunctionDefinition definition = testedCtor.getDefinition();
                    flag = definition.getDefinitionKind() == CsmFunctionDefinition.DefinitionKind.DELETE;
                    continue;
                }
                flag = true;
            }
            if (willProduceError) break;
            willProduceError = flag;
            break;
        }
        if (willProduceError && CsmFileInfoQuery.getDefault().isCpp11OrLater(request.getFile())) {
            for (CsmMember member : csmClass.getMembers()) {
                CsmDeclaration referencedDeclaration;
                if (member.getKind().equals((Object)CsmDeclaration.Kind.USING_DECLARATION) && CsmKindUtilities.isUsingDeclaration((CsmObject)member) && CsmKindUtilities.isConstructor((CsmObject)(referencedDeclaration = ((CsmUsingDeclaration)member).getReferencedDeclaration()))) {
                    CsmClass ctorClass = ((CsmConstructor)referencedDeclaration).getContainingClass();
                    for (CsmInheritance parent : csmClass.getBaseClasses()) {
                        CsmClass parentClass = CsmInheritanceUtilities.getCsmClass((CsmInheritance)parent);
                        if (parentClass == null || !parentClass.equals(ctorClass)) continue;
                        willProduceError = false;
                        break;
                    }
                }
                if (willProduceError) continue;
                break;
            }
        }
        if (willProduceError) {
            String message = NbBundle.getMessage(NoMatchingConstructor.class, (String)"NoMatchingConstructor.description");
            CsmErrorInfo.Severity severity = NoMatchingConstructor.toSeverity((String)this.minimalSeverity());
            if (response instanceof AnalyzerResponse) {
                ((AnalyzerResponse)response).addError(AnalyzerResponse.AnalyzerSeverity.DetectedError, null, csmClass.getContainingFile().getFileObject(), (CsmErrorInfo)new NoMatchingConstructorErrorInfoImpl(request.getDocument(), csmClass, "General", this.getID(), this.getName() + "\n" + message, severity, csmClass.getStartOffset(), csmClass.getLeftBracketOffset()));
            } else {
                response.addError((CsmErrorInfo)new NoMatchingConstructorErrorInfoImpl(request.getDocument(), csmClass, "General", this.getID(), message, severity, csmClass.getStartOffset(), csmClass.getLeftBracketOffset()));
            }
        }
    }

    private static final class AddConstructor
    implements Fix {
        private final BaseDocument doc;
        private final int startOffset;
        private final int endOffset;
        private final CsmClass clazz;

        public AddConstructor(BaseDocument doc, CsmClass csmClass, int startOffset, int endOffset) throws BadLocationException {
            this.doc = doc;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.clazz = csmClass;
        }

        public String getText() {
            return NbBundle.getMessage(NoMatchingConstructor.class, (String)"NoMatchingConstructor.fix");
        }

        public ChangeInfo implement() throws Exception {
            int carretOffset = 0;
            for (CsmMember member : this.clazz.getMembers()) {
                if (member.getVisibility() != CsmVisibility.PUBLIC) continue;
                int memberOffset = member.getStartOffset();
                carretOffset = memberOffset - CsmFileInfoQuery.getDefault().getLineColumnByOffset(this.clazz.getContainingFile(), memberOffset)[1];
            }
            CsmContext context = CsmContext.create((Document)this.doc, (int)this.startOffset, (int)this.endOffset, (int)carretOffset);
            InstanceContent ic = new InstanceContent();
            ic.add((Object)context);
            ic.add((Object)EditorRegistry.lastFocusedComponent());
            AbstractLookup lookup = new AbstractLookup((AbstractLookup.Content)ic);
            CsmCacheManager.enter();
            CsmRefactoringActionsFactory.showConstructorsGenerator((Lookup)lookup);
            CsmCacheManager.leave();
            return null;
        }
    }

    public static final class NoMatchingConstructorFixProvider
    extends CsmErrorInfoHintProvider {
        protected List<Fix> doGetFixes(CsmErrorInfo info, List<Fix> alreadyFound) {
            if (info instanceof NoMatchingConstructorErrorInfoImpl) {
                alreadyFound.addAll(this.createFixes((NoMatchingConstructorErrorInfoImpl)info));
            }
            return alreadyFound;
        }

        private List<? extends Fix> createFixes(NoMatchingConstructorErrorInfoImpl info) {
            try {
                return Collections.singletonList(new AddConstructor(info.doc, info.clazz, info.getStartOffset(), info.clazz.getEndOffset()));
            }
            catch (BadLocationException ex) {
                return Collections.emptyList();
            }
        }
    }

    private static final class NoMatchingConstructorErrorInfoImpl
    extends ErrorInfoImpl {
        private final BaseDocument doc;
        private final CsmClass clazz;

        public NoMatchingConstructorErrorInfoImpl(Document doc, CsmClass csmClass, String providerName, String audutName, String message, CsmErrorInfo.Severity severity, int startOffset, int endOffset) {
            super(providerName, audutName, message, severity, startOffset, endOffset);
            this.doc = (BaseDocument)doc;
            this.clazz = csmClass;
        }
    }

    public static final class Factory
    implements CodeAuditFactory {
        public AbstractCodeAudit create(AuditPreferences preferences) {
            String id = NbBundle.getMessage(NoMatchingConstructor.class, (String)"NoMatchingConstructor.name");
            String description = NbBundle.getMessage(NoMatchingConstructor.class, (String)"NoMatchingConstructor.description");
            return new NoMatchingConstructor(id, id, description, "error", true, preferences);
        }
    }
}

