/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remotefs.versioning.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remotefs.versioning.api.RemoteFileSystemConnectionListener;
import org.netbeans.modules.remotefs.versioning.api.RemoteFileSystemConnectionManager;
import org.openide.filesystems.FileSystem;
import org.openide.util.RequestProcessor;

public class RemoteFileSystemConnectionManagerImpl
extends RemoteFileSystemConnectionManager
implements ConnectionListener {
    private final Set<RemoteFileSystemConnectionListener> listeners = new HashSet<RemoteFileSystemConnectionListener>();
    private final RequestProcessor RP = new RequestProcessor("Remote VCS connection notifier", 20);
    private final HashMap<ExecutionEnvironment, Notifier> notifiers = new HashMap();
    private static final Logger LOGGER = Logger.getLogger("remote.vcs.logger");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Notifier getNotifier(ExecutionEnvironment env) {
        Notifier notifier = null;
        HashMap<ExecutionEnvironment, Notifier> hashMap = this.notifiers;
        synchronized (hashMap) {
            FileSystem fileSystem;
            notifier = this.notifiers.get(env);
            if (notifier == null && (fileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)env)) != null) {
                notifier = new Notifier(env, fileSystem);
                this.notifiers.put(env, notifier);
            }
        }
        return notifier;
    }

    public RemoteFileSystemConnectionManagerImpl() {
        ConnectionManager.getInstance().addConnectionListener((ConnectionListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteFileSystemConnectionListener(RemoteFileSystemConnectionListener listener) {
        Set<RemoteFileSystemConnectionListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteFileSystemConnectionListener(RemoteFileSystemConnectionListener listener) {
        Set<RemoteFileSystemConnectionListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public boolean isConnectedRemoteFileSystem(FileSystem fs) {
        return true;
    }

    public void connected(ExecutionEnvironment env) {
        Notifier notifier = this.getNotifier(env);
        if (notifier != null) {
            notifier.connected();
        }
    }

    public void disconnected(ExecutionEnvironment env) {
        Notifier notifier = this.getNotifier(env);
        if (notifier != null) {
            notifier.disconnected();
        }
    }

    private class Notifier
    implements Runnable {
        private final ExecutionEnvironment env;
        private final FileSystem fileSystem;
        private final Object eventLock = new Object();
        private Event lastScheduledEvent;
        private Event lastProcessedEvent;
        private final RequestProcessor.Task thisTask;

        public Notifier(ExecutionEnvironment env, FileSystem fileSystem) {
            this.env = env;
            this.fileSystem = fileSystem;
            this.lastProcessedEvent = null;
            this.lastScheduledEvent = null;
            this.thisTask = RemoteFileSystemConnectionManagerImpl.this.RP.create((Runnable)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runImpl() {
            Object object = this.eventLock;
            synchronized (object) {
                this.lastProcessedEvent = this.mergeEvents(this.lastProcessedEvent, this.lastScheduledEvent, true);
                this.lastScheduledEvent = null;
            }
            if (this.lastProcessedEvent != null) {
                ArrayList list = new ArrayList();
                Set set = RemoteFileSystemConnectionManagerImpl.this.listeners;
                synchronized (set) {
                    list.addAll(RemoteFileSystemConnectionManagerImpl.this.listeners);
                }
                for (RemoteFileSystemConnectionListener listener : list) {
                    if (this.lastProcessedEvent == Event.CONNECT) {
                        listener.connected(this.fileSystem);
                        continue;
                    }
                    listener.disconnected(this.fileSystem);
                }
            }
        }

        private boolean isStillActual(Event event) {
            switch (event) {
                case CONNECT: {
                    return ConnectionManager.getInstance().isConnectedTo(this.env);
                }
                case DISCONNECT: {
                    return !ConnectionManager.getInstance().isConnectedTo(this.env);
                }
            }
            throw new AssertionError((Object)event.name());
        }

        private Event mergeEvents(Event previous, Event current, boolean prevEventAlreadyProcessed) {
            if (current == null) {
                return null;
            }
            if (!this.isStillActual(current)) {
                return null;
            }
            if (previous == null) {
                return current;
            }
            if (previous == current) {
                String text = "Double " + (Object)((Object)current) + " notification";
                LOGGER.log(Level.FINE, text, new IllegalStateException(text));
                return null;
            }
            if (prevEventAlreadyProcessed) {
                return current;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connected() {
            Object object = this.eventLock;
            synchronized (object) {
                this.lastScheduledEvent = this.mergeEvents(this.lastScheduledEvent, Event.CONNECT, false);
                if (this.lastScheduledEvent != null) {
                    this.thisTask.schedule(0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnected() {
            Object object = this.eventLock;
            synchronized (object) {
                this.lastScheduledEvent = this.mergeEvents(this.lastScheduledEvent, Event.DISCONNECT, false);
                if (this.lastScheduledEvent != null) {
                    this.thisTask.schedule(0);
                }
            }
        }

        @Override
        public void run() {
            String oldThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName("Remote VCS connection notifier " + this.env);
            try {
                this.runImpl();
            }
            finally {
                Thread.currentThread().setName(oldThreadName);
            }
        }
    }

    private static enum Event {
        CONNECT,
        DISCONNECT;

    }
}

