/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.run;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.docker.api.DockerImageDetail;
import org.netbeans.modules.docker.ui.run.Bundle;
import org.netbeans.modules.docker.ui.run.PortMapping;
import org.netbeans.modules.docker.ui.run.RunPortBindingsVisual;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

public class RunPortBindingsPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final DockerImageDetail info;
    private RunPortBindingsVisual component;
    private WizardDescriptor wizard;

    public RunPortBindingsPanel(DockerImageDetail info) {
        this.info = info;
    }

    public RunPortBindingsVisual getComponent() {
        if (this.component == null) {
            this.component = new RunPortBindingsVisual(this.info);
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        this.wizard.putProperty("WizardPanel_errorMessage", null);
        this.wizard.putProperty("WizardPanel_infoMessage", null);
        this.wizard.putProperty("WizardPanel_warningMessage", null);
        List<PortMapping> mapping = this.component.getPortMapping();
        for (PortMapping m : mapping) {
            if (m.getPort() != null) continue;
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_MissingPort());
            return false;
        }
        HashSet<Integer> any = new HashSet<Integer>();
        HashSet<Integer> all = new HashSet<Integer>();
        HashMap<String, HashSet<Integer>> portMap = new HashMap<String, HashSet<Integer>>();
        for (PortMapping m : mapping) {
            Integer port = m.getHostPort();
            if (port == null) continue;
            if (m.getHostAddress() == null) {
                if (!any.add(port)) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_ConflictingPort(port.toString()));
                    return false;
                }
                if (!all.contains(port)) continue;
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_ConflictingPort(port.toString()));
                return false;
            }
            all.add(port);
            if (any.contains(port)) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_ConflictingPort(port.toString()));
                return false;
            }
            HashSet<Integer> ports = (HashSet<Integer>)portMap.get(m.getHostAddress());
            if (ports == null) {
                ports = new HashSet<Integer>();
                portMap.put(m.getHostAddress(), ports);
            }
            if (ports.add(port)) continue;
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.MSG_ConflictingPort(port.toString()));
            return false;
        }
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void readSettings(WizardDescriptor wiz) {
        Boolean portRandom;
        if (this.wizard == null) {
            this.wizard = wiz;
        }
        this.component.setRandomBind((portRandom = (Boolean)wiz.getProperty("portRandom")) != null ? portRandom : false);
        List<PortMapping> mapping = (List<PortMapping>)wiz.getProperty("portMapping");
        this.component.setPortMapping(mapping != null ? mapping : Collections.emptyList());
        this.changeSupport.fireChange();
    }

    public void storeSettings(WizardDescriptor wiz) {
        wiz.putProperty("portRandom", (Object)this.component.isRandomBind());
        wiz.putProperty("portMapping", this.component.getPortMapping());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }
}

