/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.List;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.openide.util.NbBundle;

public abstract class CCCCompilerConfiguration
extends BasicCompilerConfiguration {
    public static final boolean STANDARDS_SUPPORT = DebugUtils.getBoolean((String)"cnd.support.standards", (boolean)true);
    public static final int LIBRARY_LEVEL_NONE = 0;
    public static final int LIBRARY_LEVEL_RUNTIME = 1;
    public static final int LIBRARY_LEVEL_CLASSIC = 2;
    public static final int LIBRARY_LEVEL_BINARY = 3;
    public static final int LIBRARY_LEVEL_CONFORMING = 4;
    private static final String[] LIBRARY_LEVEL_NAMES = new String[]{CCCCompilerConfiguration.getString("NoneTxt"), CCCCompilerConfiguration.getString("RuntimeOnlyTxt"), CCCCompilerConfiguration.getString("ClassicIostreamsTxt"), CCCCompilerConfiguration.getString("BinaryStandardTxt"), CCCCompilerConfiguration.getString("ConformingStandardTxt")};
    public static final int STANDARDS_OLD = 0;
    public static final int STANDARDS_LEGACY = 1;
    public static final int STANDARDS_DEFAULT = 2;
    public static final int STANDARDS_MODERN = 3;
    private static final String[] STANDARDS_NAMES = new String[]{CCCCompilerConfiguration.getString("OldTxt"), CCCCompilerConfiguration.getString("LegacyTxt"), CCCCompilerConfiguration.getString("DefaultTxt"), CCCCompilerConfiguration.getString("ModernTxt")};
    public static final int LANGUAGE_EXT_NONE = 0;
    public static final int LANGUAGE_EXT_DEFAULT = 1;
    public static final int LANGUAGE_EXT_ALL = 2;
    private static final String[] LANGUAGE_EXT_NAMES = new String[]{CCCCompilerConfiguration.getString("NoneTxt"), CCCCompilerConfiguration.getString("DefaultTxt"), CCCCompilerConfiguration.getString("AllTxt")};
    private VectorConfiguration<String> includeDirectories;
    private static final int inheritIncludes = 0;
    private VectorConfiguration<String> includeFiles;
    private static final int inheritFiles = 1;
    private VectorConfiguration<String> preprocessorConfiguration;
    private VectorConfiguration<String> preprocessorUndefinedConfiguration;
    private static final int inheritPreprocessor = 3;
    private static final int inheritUndefinedPreprocessor = 4;
    private static final int useLinkerPkgConfigLibraries = 5;
    private int booleanFlags = 0;
    private final CppConfigurationContainer cppContainer;
    private static final String LIB_FLAG = " --libs ";
    private static final String FLAGS_FLAG = " --cflags ";
    private static final int DEFAULT_INDEX = 0;
    private static final int DIRTY_INDEX = 1;
    private static final int MODIFIED_INDEX = 2;
    private static final int VALUE_INDEX = 3;
    private static final int BOOLEAN_SIZE = 4;

    protected CCCCompilerConfiguration(String baseDir, CCCCompilerConfiguration master, MakeConfiguration owner) {
        super(baseDir, master, owner);
        this.cppContainer = !owner.isMakefileConfiguration() ? new ManagedCppConfigurationContainer(master) : new UnmanagedCppConfigurationContainer();
        this.includeDirectories = new VectorConfiguration<String>(master != null ? master.getIncludeDirectories() : null);
        this.set(0, new BooleanConfiguration(true));
        this.includeFiles = new VectorConfiguration<String>(master != null ? master.getIncludeFiles() : null);
        this.set(1, new BooleanConfiguration(true));
        this.preprocessorConfiguration = new VectorConfiguration<String>(master != null ? master.getPreprocessorConfiguration() : null);
        this.set(3, new BooleanConfiguration(true));
        this.preprocessorUndefinedConfiguration = new VectorConfiguration<String>(master != null ? master.getUndefinedPreprocessorConfiguration() : null);
        this.set(4, new BooleanConfiguration(true));
        this.set(5, new BooleanConfiguration(true));
    }

    public void fixupMasterLinks(CCCCompilerConfiguration compilerConfiguration) {
        super.fixupMasterLinks(compilerConfiguration);
        this.getMTLevel().setMaster(compilerConfiguration.getMTLevel());
        this.getLibraryLevel().setMaster(compilerConfiguration.getLibraryLevel());
        this.getStandardsEvolution().setMaster(compilerConfiguration.getStandardsEvolution());
        this.getLanguageExt().setMaster(compilerConfiguration.getLanguageExt());
    }

    @Override
    public boolean getModified() {
        return super.getModified() || this.cppContainer.getModified() || this.includeDirectories.getModified() || this.get(0).getModified() || this.includeFiles.getModified() || this.get(1).getModified() || this.preprocessorConfiguration.getModified() || this.get(3).getModified() || this.preprocessorUndefinedConfiguration.getModified() || this.get(4).getModified() || this.get(5).getModified();
    }

    public void setLibraryLevel(IntConfiguration libraryLevel) {
        this.cppContainer.setLibraryLevel(libraryLevel);
    }

    public IntConfiguration getLibraryLevel() {
        return this.cppContainer.getLibraryLevel();
    }

    public void setStandardsEvolution(IntConfiguration standardsEvolution) {
        this.cppContainer.setStandardsEvolution(standardsEvolution);
    }

    public IntConfiguration getStandardsEvolution() {
        return this.cppContainer.getStandardsEvolution();
    }

    public void setLanguageExt(IntConfiguration languageExt) {
        this.cppContainer.setLanguageExt(languageExt);
    }

    public IntConfiguration getLanguageExt() {
        return this.cppContainer.getLanguageExt();
    }

    public VectorConfiguration<String> getIncludeDirectories() {
        return this.includeDirectories;
    }

    public void setIncludeDirectories(VectorConfiguration<String> includeDirectories) {
        this.includeDirectories = includeDirectories;
    }

    public BooleanConfiguration getInheritIncludes() {
        return this.get(0);
    }

    public void setInheritIncludes(BooleanConfiguration inheritIncludes) {
        this.set(0, inheritIncludes);
    }

    public VectorConfiguration<String> getIncludeFiles() {
        return this.includeFiles;
    }

    public void setIncludeFiles(VectorConfiguration<String> includeFiles) {
        this.includeFiles = includeFiles;
    }

    public BooleanConfiguration getInheritFiles() {
        return this.get(1);
    }

    public void setInheritFiles(BooleanConfiguration inheritFiles) {
        this.set(1, inheritFiles);
    }

    public VectorConfiguration<String> getPreprocessorConfiguration() {
        return this.preprocessorConfiguration;
    }

    public void setPreprocessorConfiguration(VectorConfiguration<String> preprocessorConfiguration) {
        this.preprocessorConfiguration = preprocessorConfiguration;
    }

    public VectorConfiguration<String> getUndefinedPreprocessorConfiguration() {
        return this.preprocessorUndefinedConfiguration;
    }

    public void setUndefinedPreprocessorConfiguration(VectorConfiguration<String> preprocessorUndefinedConfiguration) {
        this.preprocessorUndefinedConfiguration = preprocessorUndefinedConfiguration;
    }

    public BooleanConfiguration getInheritPreprocessor() {
        return this.get(3);
    }

    public void setInheritPreprocessor(BooleanConfiguration inheritPreprocessor) {
        this.set(3, inheritPreprocessor);
    }

    public BooleanConfiguration getInheritUndefinedPreprocessor() {
        return this.get(4);
    }

    public void setInheritUndefinedPreprocessor(BooleanConfiguration inheritUndefinedPreprocessor) {
        this.set(4, inheritUndefinedPreprocessor);
    }

    public BooleanConfiguration getUseLinkerLibraries() {
        return this.get(5);
    }

    public void setUseLinkerLibraries(BooleanConfiguration useLinkerPkgConfigLibraries) {
        this.set(5, useLinkerPkgConfigLibraries);
    }

    public StringConfiguration getImportantFlags() {
        return this.cppContainer.getImportantFlags();
    }

    public void setImportantFlags(StringConfiguration importantFlags) {
        this.cppContainer.setImportantFlags(importantFlags);
    }

    protected void assign(CCCCompilerConfiguration conf) {
        super.assign(conf);
        this.getLibraryLevel().assign(conf.getLibraryLevel());
        this.getStandardsEvolution().assign(conf.getStandardsEvolution());
        this.getLanguageExt().assign(conf.getLanguageExt());
        this.getIncludeDirectories().assign(conf.getIncludeDirectories());
        this.getInheritIncludes().assign(conf.getInheritIncludes());
        this.getIncludeFiles().assign(conf.getIncludeFiles());
        this.getInheritFiles().assign(conf.getInheritFiles());
        this.getPreprocessorConfiguration().assign(conf.getPreprocessorConfiguration());
        this.getInheritPreprocessor().assign(conf.getInheritPreprocessor());
        this.getUndefinedPreprocessorConfiguration().assign(conf.getUndefinedPreprocessorConfiguration());
        this.getInheritUndefinedPreprocessor().assign(conf.getInheritUndefinedPreprocessor());
        this.getUseLinkerLibraries().assign(conf.getUseLinkerLibraries());
        this.getImportantFlags().assign(conf.getImportantFlags());
    }

    private CCCCompilerConfiguration getTopMaster() {
        List<BasicCompilerConfiguration> masters = this.getMasters(true);
        return (CCCCompilerConfiguration)masters.get(masters.size() - 1);
    }

    private static String getString(String s) {
        return NbBundle.getMessage(CCCCompilerConfiguration.class, (String)s);
    }

    protected String getLibrariesFlags() {
        CCCCompilerConfiguration topMaster = this.getTopMaster();
        if (!topMaster.getUseLinkerLibraries().getValue() || topMaster.getOwner() == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (LibraryItem lib : topMaster.getOwner().getLinkerConfiguration().getLibrariesConfiguration().getValue()) {
            int i;
            LibraryItem.OptionItem option;
            String task;
            if (lib.getType() != 4 || (task = (option = (LibraryItem.OptionItem)lib).getLibraryOption()).length() <= 2 || task.charAt(0) != '`' || task.charAt(task.length() - 1) != '`' || (i = task.indexOf(LIB_FLAG)) <= 0) continue;
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(task.substring(0, i));
            buf.append(FLAGS_FLAG);
            buf.append(task.substring(i + LIB_FLAG.length()));
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        return buf.toString();
    }

    protected abstract ToolchainManager.CompilerDescriptor getCompilerDescriptor(CompilerSet var1);

    protected String getUserIncludeFlag(CompilerSet cs) {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getCompilerDescriptor(cs);
        if (compilerDescriptor != null) {
            return compilerDescriptor.getUserIncludeFlag();
        }
        return "";
    }

    protected String getUserFileFlag(CompilerSet cs) {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getCompilerDescriptor(cs);
        if (compilerDescriptor != null) {
            return this.getCompilerDescriptor(cs).getUserFileFlag();
        }
        return "";
    }

    protected String getUserMacroFlag(CompilerSet cs) {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getCompilerDescriptor(cs);
        if (compilerDescriptor != null) {
            return this.getCompilerDescriptor(cs).getUserMacroFlag();
        }
        return "";
    }

    private void set(int i, BooleanConfiguration b) {
        this.booleanFlags = b.getDefault() ? (this.booleanFlags |= 1 << i * 4 + 0) : (this.booleanFlags &= ~(1 << i * 4 + 0));
        this.booleanFlags = b.getDirty() ? (this.booleanFlags |= 1 << i * 4 + 1) : (this.booleanFlags &= ~(1 << i * 4 + 1));
        this.booleanFlags = b.getModified() ? (this.booleanFlags |= 1 << i * 4 + 2) : (this.booleanFlags &= ~(1 << i * 4 + 2));
        this.booleanFlags = b.getValue() ? (this.booleanFlags |= 1 << i * 4 + 3) : (this.booleanFlags &= ~(1 << i * 4 + 3));
    }

    private BooleanConfiguration get(final int i) {
        return new BooleanConfiguration(){

            @Override
            public void setValue(boolean b) {
                if (b) {
                    CCCCompilerConfiguration.this.booleanFlags = CCCCompilerConfiguration.this.booleanFlags | 1 << i * 4 + 3;
                } else {
                    CCCCompilerConfiguration.this.booleanFlags = CCCCompilerConfiguration.this.booleanFlags & ~(1 << i * 4 + 3);
                }
                this.setModified(b != this.getDefault());
            }

            @Override
            public boolean getValue() {
                return (CCCCompilerConfiguration.this.booleanFlags & 1 << i * 4 + 3) != 0;
            }

            @Override
            public void setModified(boolean b) {
                if (b) {
                    CCCCompilerConfiguration.this.booleanFlags = CCCCompilerConfiguration.this.booleanFlags | 1 << i * 4 + 2;
                } else {
                    CCCCompilerConfiguration.this.booleanFlags = CCCCompilerConfiguration.this.booleanFlags & ~(1 << i * 4 + 2);
                }
            }

            @Override
            public boolean getModified() {
                return (CCCCompilerConfiguration.this.booleanFlags & 1 << i * 4 + 2) != 0;
            }

            @Override
            public void setDirty(boolean dirty) {
                if (dirty) {
                    CCCCompilerConfiguration.this.booleanFlags = CCCCompilerConfiguration.this.booleanFlags | 1 << i * 4 + 1;
                } else {
                    CCCCompilerConfiguration.this.booleanFlags = CCCCompilerConfiguration.this.booleanFlags & ~(1 << i * 4 + 1);
                }
            }

            @Override
            public boolean getDirty() {
                return (CCCCompilerConfiguration.this.booleanFlags & 1 << i * 4 + 1) != 0;
            }

            @Override
            public boolean getDefault() {
                return (CCCCompilerConfiguration.this.booleanFlags & 1 << i * 4 + 0) != 0;
            }

            @Override
            public void setDefault(boolean b) {
                if (b) {
                    CCCCompilerConfiguration.this.booleanFlags = CCCCompilerConfiguration.this.booleanFlags | 1 << i * 4 + 0;
                } else {
                    CCCCompilerConfiguration.this.booleanFlags = CCCCompilerConfiguration.this.booleanFlags & ~(1 << i * 4 + 0);
                }
                this.setModified(this.getValue() != b);
            }

            @Override
            public final void reset() {
                if (this.getDefault()) {
                    CCCCompilerConfiguration.this.booleanFlags = CCCCompilerConfiguration.this.booleanFlags | 1 << i * 4 + 3;
                } else {
                    CCCCompilerConfiguration.this.booleanFlags = CCCCompilerConfiguration.this.booleanFlags & ~(1 << i * 4 + 3);
                }
                this.setModified(false);
            }

            @Override
            public void assign(BooleanConfiguration conf) {
                boolean dirty = this.getDirty();
                this.setDirty(dirty |= conf.getValue() ^ this.getValue());
                this.setValue(conf.getValue());
                this.setModified(conf.getModified());
            }

            @Override
            @SuppressWarnings(value={"CN"})
            public BooleanConfiguration clone() {
                BooleanConfiguration clone = new BooleanConfiguration(this.getDefault());
                clone.setValue(this.getValue());
                clone.setModified(this.getModified());
                return clone;
            }

            @Override
            public String toString() {
                return "{value=" + this.getValue() + " modified=" + this.getModified() + " dirty=" + this.getDirty() + '}';
            }
        };
    }

    private static final class UnmanagedCppConfigurationContainer
    implements CppConfigurationContainer {
        private StringConfiguration importantFlags = new StringConfiguration(null, "");

        private UnmanagedCppConfigurationContainer() {
        }

        @Override
        public void setLibraryLevel(IntConfiguration libraryLevel) {
        }

        @Override
        public IntConfiguration getLibraryLevel() {
            return BasicCompilerConfiguration.UNSUPPORTED_INT_CONFIGURATION;
        }

        @Override
        public void setStandardsEvolution(IntConfiguration standardsEvolution) {
        }

        @Override
        public IntConfiguration getStandardsEvolution() {
            return BasicCompilerConfiguration.UNSUPPORTED_INT_CONFIGURATION;
        }

        @Override
        public void setLanguageExt(IntConfiguration languageExt) {
        }

        @Override
        public IntConfiguration getLanguageExt() {
            return BasicCompilerConfiguration.UNSUPPORTED_INT_CONFIGURATION;
        }

        @Override
        public void setImportantFlags(StringConfiguration importantFlags) {
            this.importantFlags = importantFlags;
        }

        @Override
        public StringConfiguration getImportantFlags() {
            return this.importantFlags;
        }

        @Override
        public boolean getModified() {
            return this.importantFlags.getValue() != null && !this.importantFlags.getValue().isEmpty();
        }
    }

    private static final class ManagedCppConfigurationContainer
    implements CppConfigurationContainer {
        private IntConfiguration libraryLevel;
        private IntConfiguration standardsEvolution;
        private IntConfiguration languageExt;

        private ManagedCppConfigurationContainer(CCCCompilerConfiguration master) {
            this.libraryLevel = new IntConfiguration(master != null ? master.getLibraryLevel() : null, 3, LIBRARY_LEVEL_NAMES, null);
            this.standardsEvolution = new IntConfiguration(master != null ? master.getStandardsEvolution() : null, 2, STANDARDS_NAMES, null);
            this.languageExt = new IntConfiguration(master != null ? master.getLanguageExt() : null, 1, LANGUAGE_EXT_NAMES, null);
        }

        @Override
        public void setLibraryLevel(IntConfiguration libraryLevel) {
            this.libraryLevel = libraryLevel;
        }

        @Override
        public IntConfiguration getLibraryLevel() {
            return this.libraryLevel;
        }

        @Override
        public void setStandardsEvolution(IntConfiguration standardsEvolution) {
            this.standardsEvolution = standardsEvolution;
        }

        @Override
        public IntConfiguration getStandardsEvolution() {
            return this.standardsEvolution;
        }

        @Override
        public void setLanguageExt(IntConfiguration languageExt) {
            this.languageExt = languageExt;
        }

        @Override
        public IntConfiguration getLanguageExt() {
            return this.languageExt;
        }

        @Override
        public void setImportantFlags(StringConfiguration importantFlags) {
        }

        @Override
        public StringConfiguration getImportantFlags() {
            return BasicCompilerConfiguration.UNSUPPORTED_STRING_CONFIGURATION;
        }

        @Override
        public boolean getModified() {
            return this.libraryLevel.getModified() || this.standardsEvolution.getModified() || this.languageExt.getModified();
        }
    }

    private static interface CppConfigurationContainer {
        public void setLibraryLevel(IntConfiguration var1);

        public IntConfiguration getLibraryLevel();

        public void setStandardsEvolution(IntConfiguration var1);

        public IntConfiguration getStandardsEvolution();

        public void setLanguageExt(IntConfiguration var1);

        public IntConfiguration getLanguageExt();

        public void setImportantFlags(StringConfiguration var1);

        public StringConfiguration getImportantFlags();

        public boolean getModified();
    }

    public static class OptionToString
    implements VectorConfiguration.ToString<String> {
        private final CompilerSet compilerSet;
        private final String prepend;

        public OptionToString(CompilerSet compilerSet, String prepend) {
            this.compilerSet = compilerSet;
            this.prepend = prepend;
        }

        @Override
        public String toString(String item) {
            if (0 < item.length()) {
                if (this.compilerSet != null) {
                    item = CppUtils.normalizeDriveLetter(this.compilerSet, item);
                }
                item = CndPathUtilities.escapeOddCharacters((String)item);
                return this.prepend == null ? item : this.prepend + item;
            }
            return "";
        }
    }
}

