/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandlerFactory;
import org.netbeans.modules.cnd.makeproject.spi.DebuggerChooserProvider;
import org.openide.util.Lookup;

public class DebuggerChooserConfiguration
implements Cloneable {
    private static DebuggerChooserProvider storage;
    private int value;
    private boolean modified;
    private boolean dirty = false;

    public DebuggerChooserConfiguration(Lookup lookup) {
        if (storage == null) {
            storage = DebuggerChooserProvider.getInstance();
        }
        this.reset();
    }

    private DebuggerChooserConfiguration(DebuggerChooserConfiguration conf) {
        this.value = conf.value;
        this.setModified(false);
    }

    public void setValue(int value) {
        this.value = value;
        this.setModified(true);
    }

    public void setValue(String s) {
        if (s != null) {
            for (int i = 0; i < storage.getNames().length; ++i) {
                if (!s.equals(storage.getName(i))) continue;
                this.setValue(i);
                break;
            }
        }
    }

    public int getValue() {
        return this.value;
    }

    public final void setModified(boolean b) {
        this.modified = b;
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public int getDefault() {
        return storage.getDefault();
    }

    public final void reset() {
        this.value = this.getDefault();
        this.setModified(false);
    }

    public String getName() {
        if (this.getValue() < storage.getNames().length) {
            return storage.getName(this.getValue());
        }
        return "???";
    }

    public ProjectActionHandlerFactory getNode() {
        if (this.getValue() < storage.getNodesSize()) {
            return storage.getNode(this.getValue());
        }
        return null;
    }

    public String[] getNames() {
        return storage.getNames();
    }

    public void assign(DebuggerChooserConfiguration conf) {
        this.dirty = this.getValue() != conf.getValue();
        this.setValue(conf.getValue());
        this.setModified(conf.getModified());
    }

    public DebuggerChooserConfiguration clone() {
        return new DebuggerChooserConfiguration(this);
    }
}

