/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.cnd.remote.utils.RemoteUtil;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class RemoteProjectSupport {
    private RemoteProjectSupport() {
    }

    public static ExecutionEnvironment getExecutionEnvironment(Lookup.Provider project) {
        MakeConfiguration mk = ConfigurationSupport.getProjectActiveConfiguration((Lookup.Provider)project);
        if (mk != null) {
            return mk.getDevelopmentHost().getExecutionEnvironment();
        }
        return null;
    }

    public static boolean projectExists(Lookup.Provider project) {
        FileObject nbprojectFO;
        RemoteProject rp = (RemoteProject)project.getLookup().lookup(RemoteProject.class);
        if (rp == null) {
            return false;
        }
        FileObject projDirFO = rp.getSourceBaseDirFileObject();
        return projDirFO != null && projDirFO.isValid() && (nbprojectFO = projDirFO.getFileObject("nbproject")) != null && nbprojectFO.isValid();
    }

    public static FileObject getPrivateStorage(Lookup.Provider project) {
        if (project == null) {
            return null;
        }
        RemoteProject rp = (RemoteProject)project.getLookup().lookup(RemoteProject.class);
        if (rp == null) {
            return null;
        }
        FileObject baseDir = rp.getSourceBaseDirFileObject();
        if (baseDir == null) {
            return null;
        }
        try {
            return FileUtil.createFolder((FileObject)baseDir, (String)"nbproject/private");
        }
        catch (IOException ex) {
            RemoteUtil.LOGGER.log(Level.INFO, ex.getMessage(), ex);
            return null;
        }
    }

    public static List<FSPath> getBuildResults(Lookup.Provider project) {
        MakeConfigurationDescriptor mcd = MakeConfigurationDescriptor.getMakeConfigurationDescriptor((Lookup.Provider)project);
        if (mcd != null) {
            MakeConfiguration conf = mcd.getActiveConfiguration();
            return RemoteProjectSupport.getBuildResults(conf);
        }
        return Collections.emptyList();
    }

    public static List<FSPath> getBuildResults(MakeConfiguration conf) {
        String binaryPath;
        String string = binaryPath = conf == null ? null : conf.getAbsoluteOutputValue();
        if (binaryPath != null) {
            return Collections.singletonList(new FSPath(conf.getFileSystem(), binaryPath));
        }
        return Collections.emptyList();
    }

    public static List<FSPath> getProjectSourceDirs(Lookup.Provider project, AtomicReference<String> runDir) {
        MakeConfiguration conf = ConfigurationSupport.getProjectActiveConfiguration((Lookup.Provider)project);
        RemoteProject rp = (RemoteProject)project.getLookup().lookup(RemoteProject.class);
        if (rp == null) {
            return Collections.emptyList();
        }
        FileObject baseDir = rp.getSourceBaseDirFileObject();
        if (baseDir == null) {
            return Collections.emptyList();
        }
        if (conf == null) {
            return Collections.singletonList(FSPath.toFSPath((FileObject)baseDir));
        }
        return RemoteProjectSupport.getProjectSourceDirs(project, conf, runDir);
    }

    public static List<FSPath> getProjectSourceDirs(Lookup.Provider project, MakeConfiguration conf, AtomicReference<String> runDir) {
        MakeConfigurationDescriptor mcs;
        RemoteProject rp = (RemoteProject)project.getLookup().lookup(RemoteProject.class);
        if (rp == null) {
            return Collections.emptyList();
        }
        FileObject baseDir = rp.getSourceBaseDirFileObject();
        if (baseDir == null) {
            return Collections.emptyList();
        }
        if (conf == null) {
            return Collections.singletonList(FSPath.toFSPath((FileObject)baseDir));
        }
        if (runDir != null) {
            String d = conf.getMakefileConfiguration().getBuildCommandWorkingDirValue();
            FileSystem fs = conf.getBaseFSPath().getFileSystem();
            if (!CndPathUtilities.isPathAbsolute((CharSequence)d)) {
                d = conf.getBaseFSPath().getPath() + FileSystemProvider.getFileSeparatorChar((FileSystem)fs) + d;
            }
            d = FileSystemProvider.normalizeAbsolutePath((String)d, (FileSystem)fs);
            runDir.set(d);
        }
        HashSet<FSPath> sourceFilesAndDirs = new HashSet<FSPath>();
        if (!conf.isMakefileConfiguration()) {
            sourceFilesAndDirs.add(FSPath.toFSPath((FileObject)baseDir));
        }
        if ((mcs = MakeConfigurationDescriptor.getMakeConfigurationDescriptor((Lookup.Provider)project)) == null) {
            return Collections.emptyList();
        }
        if (!mcs.getBaseDirFileObject().isValid()) {
            return new ArrayList<FSPath>(sourceFilesAndDirs);
        }
        for (String soorceRoot : mcs.getSourceRoots()) {
            FileObject fo = FileSystemProvider.getFileObject((FileObject)baseDir, (String)soorceRoot);
            if (fo == null) continue;
            sourceFilesAndDirs.add(FSPath.toFSPath((FileObject)fo));
        }
        RemoteProjectSupport.addExtraFiles(mcs, sourceFilesAndDirs);
        ArrayList<Project> subProjects = new ArrayList<Project>(conf.getSubProjects());
        for (LibraryItem.ProjectItem requiredProject : conf.getRequiredProjectsConfiguration().getValue()) {
            Project p = requiredProject.getProject(conf.getBaseFSPath());
            if (p == null) continue;
            subProjects.add(p);
        }
        for (Project subProject : subProjects) {
            if (!subProject.getProjectDirectory().isValid()) continue;
            sourceFilesAndDirs.add(FSPath.toFSPath((FileObject)subProject.getProjectDirectory()));
            MakeConfigurationDescriptor subMcs = MakeConfigurationDescriptor.getMakeConfigurationDescriptor((Lookup.Provider)subProject);
            for (String soorceRoot : mcs.getSourceRoots()) {
                FileObject fo = FileSystemProvider.getFileObject((FileObject)subProject.getProjectDirectory(), (String)soorceRoot);
                if (fo == null) continue;
                sourceFilesAndDirs.add(FSPath.toFSPath((FileObject)fo));
            }
            if (subMcs == null) continue;
            RemoteProjectSupport.addExtraFiles(subMcs, sourceFilesAndDirs);
        }
        return new ArrayList<FSPath>(sourceFilesAndDirs);
    }

    private static void addExtraFiles(MakeConfigurationDescriptor subMcs, Set<FSPath> filesToSync) {
        RemoteProjectSupport.addExtraFiles(subMcs, filesToSync, subMcs.getProjectItems());
        RemoteProjectSupport.addExtraFiles(subMcs, filesToSync, subMcs.getExternalFileItemsAsArray());
    }

    private static void addExtraFiles(MakeConfigurationDescriptor subMcs, Set<FSPath> filesToSync, Item[] items) {
        SharabilityFilter filter = new SharabilityFilter();
        for (Item item : items) {
            FileObject fo = item.getFileObject();
            if (fo == null || !fo.isValid()) {
                filesToSync.add(item.getFSPath());
                continue;
            }
            if (!filter.accept(fo)) {
                filesToSync.add(item.getFSPath());
                continue;
            }
            if (RemoteProjectSupport.isContained(item.getNormalizedPath(), filesToSync)) continue;
            filesToSync.add(item.getFSPath());
        }
    }

    private static boolean isContained(String itemAbsPath, Set<FSPath> paths) {
        for (FSPath dir : paths) {
            char c;
            String alreadyAddedPath = dir.getPath();
            if (!itemAbsPath.startsWith(alreadyAddedPath) || itemAbsPath.length() <= alreadyAddedPath.length() || (c = itemAbsPath.charAt(alreadyAddedPath.length())) != '\\' && c != '/') continue;
            return true;
        }
        return false;
    }
}

