/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ConfSelectorPanel
extends JPanel {
    private final Configuration[] configurationItems;
    private final JCheckBox[] checkBoxes;
    private final JButton[] actionButtons;
    private JPanel buttonPanel;
    private JPanel confPanel;
    private JButton deselectAllButton;
    private JPanel innerPanel;
    private JLabel label;
    private JScrollPane scrollPanel;
    private JButton selectAllButton;
    private static ResourceBundle bundle;

    public ConfSelectorPanel(String labelText, char mn, Configuration[] configurationItems, JButton[] actionButtons) {
        GridBagConstraints gridBagConstraints;
        int i;
        this.initComponents();
        this.configurationItems = configurationItems;
        this.actionButtons = actionButtons;
        this.label.setText(labelText);
        this.label.setDisplayedMnemonic(mn);
        CheckBoxActionListener checkBoxActionListener = new CheckBoxActionListener();
        this.checkBoxes = new JCheckBox[configurationItems.length];
        for (i = 0; i < configurationItems.length; ++i) {
            JCheckBox checkBox = new JCheckBox();
            checkBox.addActionListener(checkBoxActionListener);
            checkBox.setBackground(new Color(255, 255, 255));
            checkBox.setText(configurationItems[i].toString());
            checkBox.setSelected(true);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            gridBagConstraints.anchor = 18;
            if (i == configurationItems.length - 1) {
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
            }
            this.innerPanel.add((Component)checkBox, gridBagConstraints);
            this.checkBoxes[i] = checkBox;
            checkBox.getAccessibleContext().setAccessibleDescription("");
        }
        if (actionButtons != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 4, 0);
            for (i = 0; i < actionButtons.length; ++i) {
                ++gridBagConstraints.gridy;
                this.buttonPanel.add((Component)actionButtons[i], gridBagConstraints);
            }
        }
        this.innerPanel.setBackground(new Color(255, 255, 255));
        this.setPreferredSize(new Dimension(350, 250));
        this.getAccessibleContext().setAccessibleDescription(ConfSelectorPanel.getString("SELECTED_CONF_AD"));
        this.label.setDisplayedMnemonic(ConfSelectorPanel.getString("SELECTED_CONF_MN").charAt(0));
        this.selectAllButton.getAccessibleContext().setAccessibleDescription(ConfSelectorPanel.getString("SELECT_ALL_BUTTON_AD"));
        this.deselectAllButton.getAccessibleContext().setAccessibleDescription(ConfSelectorPanel.getString("DESELECT_ALL_BUTTON_AD"));
        this.checkCheckBoxes();
    }

    public void restoreSelection(String recentSelectionKey) {
        this.storeOrRestoreSelection(recentSelectionKey, false);
    }

    public void storeSelection(String recentSelectionKey) {
        this.storeOrRestoreSelection(recentSelectionKey, true);
    }

    private void storeOrRestoreSelection(String recentSelectionKey, boolean store) {
        if (this.checkBoxes == null || this.configurationItems == null || this.checkBoxes.length != this.configurationItems.length) {
            return;
        }
        Preferences prefs = NbPreferences.forModule(ConfSelectorPanel.class);
        for (int i = 0; i < this.configurationItems.length; ++i) {
            String value;
            String key = recentSelectionKey + this.configurationItems[i].getName();
            if (store) {
                value = Boolean.toString(this.checkBoxes[i].isSelected());
                prefs.put(key, value);
                continue;
            }
            value = prefs.get(key, Boolean.TRUE.toString());
            this.checkBoxes[i].setSelected(Boolean.parseBoolean(value));
        }
    }

    public final void checkCheckBoxes() {
        int i;
        boolean oneSelected = false;
        for (i = 0; i < this.checkBoxes.length; ++i) {
            if (!this.checkBoxes[i].isSelected()) continue;
            oneSelected = true;
            break;
        }
        if (this.actionButtons != null) {
            for (i = 0; i < this.actionButtons.length; ++i) {
                this.actionButtons[i].setEnabled(oneSelected);
            }
        }
    }

    public Configuration[] getSelectedConfs() {
        ArrayList<Configuration> vector = new ArrayList<Configuration>();
        for (int i = 0; i < this.configurationItems.length; ++i) {
            if (!this.checkBoxes[i].isSelected()) continue;
            vector.add(this.configurationItems[i]);
        }
        return vector.toArray(new Configuration[vector.size()]);
    }

    private void initComponents() {
        this.label = new JLabel();
        this.confPanel = new JPanel();
        this.scrollPanel = new JScrollPane();
        this.innerPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.selectAllButton = new JButton();
        this.deselectAllButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.label.setLabelFor(this.innerPanel);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.label, (String)bundle.getString("SELECTED_CONF_LBL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 2, 0);
        this.add((Component)this.label, gridBagConstraints);
        this.confPanel.setLayout(new GridBagLayout());
        this.innerPanel.setBackground(new Color(255, 255, 255));
        this.innerPanel.setLayout(new GridBagLayout());
        this.scrollPanel.setViewportView(this.innerPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.confPanel.add((Component)this.scrollPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.confPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.selectAllButton, (String)bundle.getString("SELECT_ALL_BUTTON_TXT"));
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfSelectorPanel.this.selectAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.buttonPanel.add((Component)this.selectAllButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.deselectAllButton, (String)bundle.getString("DESELECT_ALL_BUTTON_TXT"));
        this.deselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfSelectorPanel.this.deselectAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.deselectAllButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 12);
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void deselectAllButtonActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            this.checkBoxes[i].setSelected(false);
        }
        this.checkCheckBoxes();
    }

    private void selectAllButtonActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            this.checkBoxes[i].setSelected(true);
        }
        this.checkCheckBoxes();
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(ConfSelectorPanel.class);
        }
        return bundle.getString(s);
    }

    private class CheckBoxActionListener
    implements ActionListener {
        private CheckBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ConfSelectorPanel.this.checkCheckBoxes();
        }
    }
}

