/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.ignore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.FileInformation;
import org.netbeans.modules.git.remote.FileStatusCache;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitStatus;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.NotificationListener;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.remote.ui.ignore.UnignoreAction;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class IgnoreAction
extends MultipleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(IgnoreAction.class.getName());

    @Override
    protected RequestProcessor.Task performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        return this.ignore(repository, roots);
    }

    @Override
    protected boolean enable(Node[] activatedNodes) {
        boolean enabled = super.enable(activatedNodes);
        if (enabled) {
            VCSContext ctx = this.getCurrentContext(activatedNodes);
            FileStatusCache cache = Git.getInstance().getFileStatusCache();
            enabled = cache.containsFiles(ctx, EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.NEW_HEAD_WORKING_TREE), true);
            if (!enabled) {
                for (VCSFileProxy root : ctx.getRootFiles()) {
                    FileInformation status = cache.getStatus(root);
                    if (!status.isDirectory() || status.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) continue;
                    enabled = true;
                    break;
                }
            }
        }
        return enabled;
    }

    public void ignoreFolders(VCSFileProxy repository, VCSFileProxy[] roots) {
        VCSFileProxy[] toIgnore = this.filterFolders(repository, roots);
        this.ignore(repository, toIgnore);
    }

    private RequestProcessor.Task ignore(VCSFileProxy repository, VCSFileProxy[] roots) {
        final VCSFileProxy[] toIgnore = IgnoreAction.filterRoots(roots);
        if (toIgnore.length == 0) {
            return null;
        }
        GitProgressSupport supp = new GitProgressSupport(){
            private final Set<VCSFileProxy> notifiedFiles = new HashSet<VCSFileProxy>();
            private VCSFileProxy[] modifiedIgnores = new VCSFileProxy[0];

            @Override
            protected void perform() {
                try {
                    GitClient client = this.getClient();
                    VCSFileProxy[] toRemoveFromIndex = IgnoreAction.getForRemovalFromIndex(toIgnore);
                    if (toRemoveFromIndex.length > 0) {
                        client.remove(toIgnore, true, this.getProgressMonitor());
                    }
                    client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(toIgnore));
                    client.addNotificationListener((NotificationListener)new FileListener(){

                        public void notifyFile(VCSFileProxy file, String relativePathToRoot) {
                            notifiedFiles.add(file);
                        }
                    });
                    this.modifiedIgnores = client.ignore(toIgnore, this.getProgressMonitor());
                    ((IgnoreAction)SystemAction.get(IgnoreAction.class)).setEnabled(false);
                    ((UnignoreAction)SystemAction.get(UnignoreAction.class)).setEnabled(false);
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                finally {
                    if (this.modifiedIgnores.length > 0) {
                        VersioningSupport.refreshFor((VCSFileProxy[])this.modifiedIgnores);
                        this.notifiedFiles.addAll(Arrays.asList(this.modifiedIgnores));
                    }
                    if (!this.notifiedFiles.isEmpty()) {
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), this.notifiedFiles));
                    }
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(IgnoreAction.class, (String)"LBL_IgnoreAction.progressName"));
        return supp.getTask();
    }

    private static VCSFileProxy[] filterRoots(VCSFileProxy[] roots) {
        LinkedList<VCSFileProxy> toIgnore = new LinkedList<VCSFileProxy>();
        FileStatusCache cache = Git.getInstance().getFileStatusCache();
        for (VCSFileProxy root : roots) {
            FileInformation info = cache.getStatus(root);
            if (!info.isDirectory() && !info.containsStatus(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.NEW_HEAD_WORKING_TREE))) continue;
            toIgnore.add(root);
        }
        return toIgnore.toArray(new VCSFileProxy[toIgnore.size()]);
    }

    private static VCSFileProxy[] getForRemovalFromIndex(VCSFileProxy[] roots) {
        ArrayList<VCSFileProxy> ret = new ArrayList<VCSFileProxy>(roots.length);
        FileStatusCache cache = Git.getInstance().getFileStatusCache();
        for (VCSFileProxy root : roots) {
            FileInformation info = cache.getStatus(root);
            if (!info.containsStatus(FileInformation.Status.NEW_HEAD_INDEX)) continue;
            ret.add(root);
        }
        return ret.toArray(new VCSFileProxy[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VCSFileProxy[] filterFolders(VCSFileProxy repository, VCSFileProxy[] roots) {
        Map<Object, Object> statuses;
        LinkedList<VCSFileProxy> unignoredFolders = new LinkedList<VCSFileProxy>();
        GitClient client = null;
        try {
            client = Git.getInstance().getClient(repository);
            statuses = client.getStatus(roots, GitUtils.NULL_PROGRESS_MONITOR);
        }
        catch (GitException ex) {
            LOG.log(Level.INFO, null, ex);
            statuses = Collections.emptyMap();
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        for (VCSFileProxy f : roots) {
            GitStatus st = (GitStatus)statuses.get(f);
            if (st == null || st.getStatusIndexWC() != GitStatus.Status.STATUS_IGNORED) {
                unignoredFolders.add(f);
                continue;
            }
            LOG.log(Level.FINE, "File {0} already ignored", f);
        }
        return unignoredFolders.toArray(new VCSFileProxy[unignoredFolders.size()]);
    }
}

