/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.lib.ddl.CommandNotSupportedException;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.ProcedureNodeProvider;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Procedure;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProcedureNode
extends BaseNode {
    private static final Logger LOG = Logger.getLogger(ProcedureNode.class.getName());
    private static final String ICON_VALID_P = "org/netbeans/modules/db/resources/procedure.png";
    private static final String ICON_VALID_F = "org/netbeans/modules/db/resources/function.png";
    private static final String ICON_VALID_T = "org/netbeans/modules/db/resources/trigger.png";
    private static final String ICON_INVALID_P = "org/netbeans/modules/db/resources/procedure-invalid.png";
    private static final String ICON_INVALID_F = "org/netbeans/modules/db/resources/function-invalid.png";
    private static final String ICON_INVALID_T = "org/netbeans/modules/db/resources/trigger-invalid.png";
    private static final String FOLDER = "Procedure";
    private static final String DELIMITER = "@@";
    private static final String SPACE = " ";
    private static final String NEW_LINE = "\n";
    private static final String TRIGGER = "TRIGGER";
    private static final String FUNCTION = "FUNCTION";
    private static final String PROCEDURE = "PROCEDURE";
    private String name = "";
    private final MetadataElementHandle<Procedure> procedureHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private Type type;
    private String schemaName;
    private String catalogName;

    public static ProcedureNode create(NodeDataLookup dataLookup, ProcedureNodeProvider provider, String schema) {
        DatabaseConnection conn = (DatabaseConnection)dataLookup.lookup(DatabaseConnection.class);
        ProcedureNode node = conn != null && "MySQL".equalsIgnoreCase(conn.getDriverName()) ? new MySQL(dataLookup, provider, schema) : (conn != null && conn.getDriverName() != null && conn.getDriverName().startsWith("Oracle") ? new Oracle(dataLookup, provider, schema) : new ProcedureNode(dataLookup, provider));
        node.setup();
        return node;
    }

    private ProcedureNode(NodeDataLookup lookup, NodeProvider provider) {
        super(new ChildNodeFactory((Lookup)lookup), lookup, FOLDER, provider);
        this.procedureHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    @Override
    protected void initialize() {
        boolean connected = this.connection.isConnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Procedure proc = (Procedure)ProcedureNode.this.procedureHandle.resolve(metaData);
                        ProcedureNode.this.name = proc.getName();
                        ProcedureNode.this.type = proc.getReturnValue() == null ? Type.Procedure : Type.Function;
                        ProcedureNode.this.updateProperties(proc);
                        ProcedureNode.this.schemaName = proc.getParent().getName();
                        ProcedureNode.this.catalogName = proc.getParent().getParent().getName();
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, e, true);
            }
        }
    }

    private void updateProperties(Procedure proc) {
        PropertySupport.Name ps = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)ps);
        if (proc.getReturnValue() == null) {
            this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureNode.class, (String)"StoredProcedure"));
        } else {
            this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureNode.class, (String)"StoredFunction"));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    protected Type getType() {
        return this.type;
    }

    @Override
    public String getIconBase() {
        if (this.getType() == null) {
            return null;
        }
        switch (this.getType()) {
            case Function: {
                return ICON_VALID_F;
            }
            case Procedure: {
                return ICON_VALID_P;
            }
            case Trigger: {
                return ICON_VALID_T;
            }
        }
        return null;
    }

    public String getShortDescription() {
        switch (this.getType()) {
            case Function: {
                return NbBundle.getMessage(ProcedureNode.class, (String)"ND_Function");
            }
            case Procedure: {
                return NbBundle.getMessage(ProcedureNode.class, (String)"ND_Procedure");
            }
            case Trigger: {
                return NbBundle.getMessage(ProcedureNode.class, (String)"ND_Trigger");
            }
        }
        return null;
    }

    @Override
    public boolean canDestroy() {
        DatabaseConnector connector = this.connection.getConnector();
        return connector.supportsCommand("DropProcedureCommand");
    }

    @Override
    public void destroy() {
        DatabaseConnector connector = this.connection.getConnector();
        Specification spec = connector.getDatabaseSpecification();
        try {
            AbstractCommand command = null;
            switch (this.getType()) {
                case Function: {
                    command = spec.createCommandDropFunction(this.getName());
                    break;
                }
                case Procedure: {
                    command = spec.createCommandDropProcedure(this.getName());
                    break;
                }
                case Trigger: {
                    command = spec.createCommandDropTrigger(this.getName());
                    break;
                }
                default: {
                    assert (false) : "Unknown type " + (Object)((Object)this.getType());
                    break;
                }
            }
            if (command == null) {
                LOG.log(Level.INFO, "No command found for droping {0}", this.getName());
                return;
            }
            if (this.getOwner() != null) {
                command.setObjectOwner(this.getOwner());
            }
            command.execute();
            this.remove();
        }
        catch (DDLException e) {
            LOG.log(Level.INFO, "{0} while deleting {1} {2}", new Object[]{e, ProcedureNode.getTypeName(this.getType()), this.getName()});
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
        }
        catch (CommandNotSupportedException e) {
            LOG.log(Level.INFO, "{0} while deleting {1} {2}", new Object[]{e, ProcedureNode.getTypeName(this.getType()), this.getName()});
        }
    }

    private String getOwner() {
        String owner = this.schemaName == null ? this.catalogName : this.schemaName;
        return owner;
    }

    public boolean isViewSourceSupported() {
        return false;
    }

    public boolean isEditSourceSupported() {
        return false;
    }

    public String getParams() {
        return "";
    }

    public String getBody() {
        return "";
    }

    public String getSource() {
        return "";
    }

    public String getDDL() {
        return "";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProcedureNode.class);
    }

    private static String getTypeName(Type t) {
        String name = "";
        switch (t) {
            case Function: {
                name = FUNCTION;
                break;
            }
            case Procedure: {
                name = PROCEDURE;
                break;
            }
            case Trigger: {
                name = TRIGGER;
                break;
            }
            default: {
                assert (false) : "Unknown type " + (Object)((Object)t);
                break;
            }
        }
        return name;
    }

    private static void updateProcedureProperties(ProcedureNode node, ProcedureNodeProvider provider) {
        PropertySupport.Name ps = new PropertySupport.Name((Node)node);
        node.addProperty((Node.Property)ps);
        Type type = provider.getType(node.getName());
        if (type == null) {
            LOG.log(Level.INFO, "Unknown type of object {0}", node.getName());
            return;
        }
        switch (type) {
            case Function: {
                ProcedureNode.setTypeProperty(node, "StoredFunction");
                break;
            }
            case Procedure: {
                ProcedureNode.setTypeProperty(node, "StoredProcedure");
                break;
            }
            case Trigger: {
                ProcedureNode.setTypeProperty(node, "StoredTrigger");
                break;
            }
            default: {
                assert (false) : "Unknown type " + (Object)((Object)provider.getType(node.getName()));
                break;
            }
        }
    }

    private static void setTypeProperty(ProcedureNode node, String bundleKey) {
        node.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureNode.class, (String)bundleKey));
    }

    public static class Oracle
    extends ProcedureNode {
        private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
        private final ProcedureNodeProvider provider;
        private final String schema;

        private Oracle(NodeDataLookup lookup, ProcedureNodeProvider provider, String schema) {
            super(lookup, provider);
            this.provider = provider;
            this.schema = schema;
        }

        @Override
        protected void initialize() {
            super.initialize();
            ProcedureNode.updateProcedureProperties((ProcedureNode)this, this.provider);
        }

        @Override
        public Type getType() {
            return this.provider.getType(this.getName());
        }

        @Override
        public String getShortDescription() {
            switch (this.provider.getType(this.getName())) {
                case Function: {
                    return this.provider.getStatus(this.getName()) ? NbBundle.getMessage(ProcedureNode.class, (String)"ND_Function") : NbBundle.getMessage(ProcedureNode.class, (String)"ND_Function_Invalid");
                }
                case Procedure: {
                    return this.provider.getStatus(this.getName()) ? NbBundle.getMessage(ProcedureNode.class, (String)"ND_Procedure") : NbBundle.getMessage(ProcedureNode.class, (String)"ND_Procedure_Invalid");
                }
                case Trigger: {
                    return this.provider.getStatus(this.getName()) ? NbBundle.getMessage(ProcedureNode.class, (String)"ND_Trigger") : NbBundle.getMessage(ProcedureNode.class, (String)"ND_Trigger_Invalid");
                }
            }
            return null;
        }

        @Override
        public String getIconBase() {
            Type type = this.getType();
            if (type == null) {
                return null;
            }
            switch (type) {
                case Function: {
                    return this.provider.getStatus(this.getName()) ? ProcedureNode.ICON_VALID_F : ProcedureNode.ICON_INVALID_F;
                }
                case Procedure: {
                    return this.provider.getStatus(this.getName()) ? ProcedureNode.ICON_VALID_P : ProcedureNode.ICON_INVALID_P;
                }
                case Trigger: {
                    return this.provider.getStatus(this.getName()) ? ProcedureNode.ICON_VALID_T : ProcedureNode.ICON_INVALID_T;
                }
            }
            return null;
        }

        @Override
        public boolean isViewSourceSupported() {
            return true;
        }

        @Override
        public String getBody() {
            String source = this.getSource();
            String body = "";
            int beginIdx = source.indexOf("BEGIN");
            if (beginIdx != -1) {
                body = source.substring(beginIdx);
            }
            return body;
        }

        @Override
        public String getParams() {
            String source = this.getSource();
            String params = "";
            int beginIdx = source.indexOf("BEGIN");
            int lIdx = source.indexOf(40);
            int rIdx = source.indexOf(41);
            if (lIdx != -1 && rIdx != -1 && lIdx < beginIdx) {
                params = source.substring(lIdx, rIdx + 1);
            }
            return params;
        }

        @Override
        public String getSource() {
            StringBuilder sb = new StringBuilder();
            String owner = "";
            try {
                String escapedName = this.getName().replace("'", "''");
                String escapedSchemaName = this.schema.toUpperCase().replace("'", "''");
                try (Statement stat = this.connection.getJDBCConnection().createStatement();){
                    String q = "SELECT TEXT, OWNER FROM SYS.ALL_SOURCE WHERE NAME = '" + escapedName + "' AND OWNER='" + escapedSchemaName + "'" + " ORDER BY LINE";
                    try (ResultSet rs = stat.executeQuery(q);){
                        while (rs.next()) {
                            sb.append(rs.getString("text"));
                            owner = rs.getString("owner");
                        }
                    }
                }
            }
            catch (SQLException ex) {
                LOG.log(Level.INFO, "{0} while get source of {1} {2}", new Object[]{ex, ProcedureNode.getTypeName(this.getType()), this.getName()});
            }
            return this.fqn(sb.toString(), owner);
        }

        @Override
        public boolean isEditSourceSupported() {
            return true;
        }

        @Override
        public String getDDL() {
            StringBuilder expression = new StringBuilder();
            expression.append("DELIMITER ").append(ProcedureNode.DELIMITER).append(ProcedureNode.NEW_LINE);
            expression.append("CREATE OR REPLACE ").append(this.getSource());
            expression.append(ProcedureNode.SPACE).append(ProcedureNode.DELIMITER).append(ProcedureNode.NEW_LINE);
            expression.append("DELIMITER ; ").append(ProcedureNode.NEW_LINE);
            return expression.toString();
        }

        private String fqn(String source, String owner) {
            String upperSource = source.toUpperCase();
            String toFind = ProcedureNode.getTypeName(this.getType()) + ProcedureNode.SPACE;
            String res = source;
            int nameIdx = upperSource.indexOf(toFind);
            if (nameIdx != -1) {
                if (upperSource.substring(nameIdx + toFind.length()).trim().startsWith(owner.toUpperCase() + '.')) {
                    return source;
                }
                res = source.substring(0, nameIdx + toFind.length()) + owner + '.' + source.substring(nameIdx + toFind.length()).trim();
            }
            return res;
        }
    }

    public static class MySQL
    extends ProcedureNode {
        private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
        private final ProcedureNodeProvider provider;

        private MySQL(NodeDataLookup lookup, ProcedureNodeProvider provider, String schema) {
            super(lookup, provider);
            this.provider = provider;
        }

        @Override
        protected void initialize() {
            super.initialize();
            ProcedureNode.updateProcedureProperties((ProcedureNode)this, this.provider);
        }

        @Override
        public Type getType() {
            return this.provider.getType(this.getName());
        }

        @Override
        public String getShortDescription() {
            switch (this.provider.getType(this.getName())) {
                case Function: {
                    return this.provider.getStatus(this.getName()) ? NbBundle.getMessage(ProcedureNode.class, (String)"ND_Function") : NbBundle.getMessage(ProcedureNode.class, (String)"ND_Function_Invalid");
                }
                case Procedure: {
                    return this.provider.getStatus(this.getName()) ? NbBundle.getMessage(ProcedureNode.class, (String)"ND_Procedure") : NbBundle.getMessage(ProcedureNode.class, (String)"ND_Procedure_Invalid");
                }
                case Trigger: {
                    return this.provider.getStatus(this.getName()) ? NbBundle.getMessage(ProcedureNode.class, (String)"ND_Trigger") : NbBundle.getMessage(ProcedureNode.class, (String)"ND_Trigger_Invalid");
                }
            }
            return null;
        }

        @Override
        public String getIconBase() {
            Type type = this.getType();
            if (type == null) {
                return null;
            }
            switch (type) {
                case Function: {
                    return this.provider.getStatus(this.getName()) ? ProcedureNode.ICON_VALID_F : ProcedureNode.ICON_INVALID_F;
                }
                case Procedure: {
                    return this.provider.getStatus(this.getName()) ? ProcedureNode.ICON_VALID_P : ProcedureNode.ICON_INVALID_P;
                }
                case Trigger: {
                    return this.provider.getStatus(this.getName()) ? ProcedureNode.ICON_VALID_T : ProcedureNode.ICON_INVALID_T;
                }
            }
            return null;
        }

        @Override
        public boolean isViewSourceSupported() {
            return true;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public String getSource() {
            source = "";
            try {
                query = "";
                escapedName = "";
                function = false;
                switch (2.$SwitchMap$org$netbeans$modules$db$explorer$node$ProcedureNode$Type[this.getType().ordinal()]) {
                    case 1: {
                        function = true;
                    }
                    case 2: {
                        escapedName = this.getName().replace("'", "''");
                        query = "SELECT param_list, returns, body, db FROM mysql.proc WHERE name = '" + escapedName + "';";
                        stat = this.connection.getJDBCConnection().createStatement();
                        var6_8 = null;
                        rs = stat.executeQuery(query);
                        var8_16 = null;
                        try {
                            while (rs.next()) {
                                parent = rs.getString("db");
                                parent = parent != null && parent.trim().length() > 0 ? parent + '.' : "";
                                params = rs.getString("param_list");
                                returns = null;
                                if (function) {
                                    returns = rs.getString("returns");
                                }
                                body = rs.getString("body");
                                source = ProcedureNode.access$1000(this.getType()) + " " + parent + this.getName() + "\n" + "(" + params + ")" + "\n" + (function != false ? "RETURNS " + returns + "\n" : "") + body;
                            }
                        }
                        catch (Throwable parent) {
                            var8_16 = parent;
                            throw parent;
                        }
                        finally {
                            if (rs != null) {
                                if (var8_16 != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable parent) {
                                        var8_16.addSuppressed(parent);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                        }
                        if (stat == null) break;
                        if (var6_8 == null) ** GOTO lbl51
                        try {
                            stat.close();
                        }
                        catch (Throwable rs) {
                            var6_8.addSuppressed(rs);
                        }
                        break;
lbl51:
                        // 1 sources

                        stat.close();
                        break;
                        catch (Throwable rs) {
                            try {
                                var6_8 = rs;
                                throw rs;
                            }
                            catch (Throwable var15_34) {
                                if (stat != null) {
                                    if (var6_8 != null) {
                                        try {
                                            stat.close();
                                        }
                                        catch (Throwable var16_36) {
                                            var6_8.addSuppressed(var16_36);
                                        }
                                    } else {
                                        stat.close();
                                    }
                                }
                                throw var15_34;
                            }
                        }
                    }
                    case 3: {
                        escapedName = this.getName().replace("'", "''");
                        query = "SELECT ACTION_STATEMENT, EVENT_OBJECT_SCHEMA, EVENT_OBJECT_TABLE, ACTION_TIMING, EVENT_MANIPULATION, TRIGGER_SCHEMA FROM information_schema.triggers WHERE TRIGGER_NAME = '" + escapedName + "';";
                        stat = this.connection.getJDBCConnection().createStatement();
                        var6_9 = null;
                        rs = stat.executeQuery(query);
                        var8_17 = null;
                        try {
                            while (rs.next()) {
                                parent = rs.getString("TRIGGER_SCHEMA");
                                parent = parent != null && parent.trim().length() > 0 ? parent + '.' : "";
                                trigger_body = rs.getString("ACTION_STATEMENT");
                                trigger_time = rs.getString("ACTION_TIMING");
                                trigger_event = rs.getString("EVENT_MANIPULATION");
                                tbl_schema = rs.getString("EVENT_OBJECT_SCHEMA");
                                tbl_table_name = rs.getString("EVENT_OBJECT_TABLE");
                                tbl_name = tbl_schema == null || tbl_schema.length() == 0 ? tbl_table_name : tbl_schema + '.' + tbl_table_name;
                                source = "TRIGGER " + parent + this.getName() + '\n' + trigger_time + ' ' + trigger_event + " ON " + tbl_name + '\n' + "FOR EACH ROW" + '\n' + trigger_body;
                            }
                        }
                        catch (Throwable var9_23) {
                            var8_17 = var9_23;
                            throw var9_23;
                        }
                        finally {
                            if (rs != null) {
                                if (var8_17 != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable var9_22) {
                                        var8_17.addSuppressed(var9_22);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                        }
                        if (stat == null) break;
                        if (var6_9 == null) ** GOTO lbl111
                        try {
                            stat.close();
                        }
                        catch (Throwable var7_14) {
                            var6_9.addSuppressed(var7_14);
                        }
                        break;
lbl111:
                        // 1 sources

                        stat.close();
                        break;
                        catch (Throwable var7_15) {
                            try {
                                var6_9 = var7_15;
                                throw var7_15;
                            }
                            catch (Throwable var19_39) {
                                if (stat != null) {
                                    if (var6_9 != null) {
                                        try {
                                            stat.close();
                                        }
                                        catch (Throwable var20_40) {
                                            var6_9.addSuppressed(var20_40);
                                        }
                                    } else {
                                        stat.close();
                                    }
                                }
                                throw var19_39;
                            }
                        }
                    }
                    default: {
                        if (!MySQL.$assertionsDisabled) {
                            throw new AssertionError((Object)("Unknown type" + (Object)this.getType()));
                        }
                        break;
                    }
                }
            }
            catch (SQLException ex) {
                ProcedureNode.access$1100().log(Level.INFO, "{0} while get source of {1} {2}", new Object[]{ex, ProcedureNode.access$1000(this.getType()), this.getName()});
            }
            return source;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public String getParams() {
            params = "";
            escapedName = "";
            query = "";
            try {
                switch (2.$SwitchMap$org$netbeans$modules$db$explorer$node$ProcedureNode$Type[this.getType().ordinal()]) {
                    case 1: 
                    case 2: {
                        escapedName = this.getName().replace("'", "''");
                        query = "SELECT param_list FROM mysql.proc WHERE name = '" + escapedName + "';";
                        stat = this.connection.getJDBCConnection().createStatement();
                        var5_7 = null;
                        rs = stat.executeQuery(query);
                        var7_15 = null;
                        try {
                            while (rs.next()) {
                                params = rs.getString("param_list");
                            }
                        }
                        catch (Throwable var8_18) {
                            var7_15 = var8_18;
                            throw var8_18;
                        }
                        finally {
                            if (rs != null) {
                                if (var7_15 != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable var8_17) {
                                        var7_15.addSuppressed(var8_17);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                        }
                        if (stat == null) break;
                        if (var5_7 == null) ** GOTO lbl41
                        try {
                            stat.close();
                        }
                        catch (Throwable rs) {
                            var5_7.addSuppressed(rs);
                        }
                        break;
lbl41:
                        // 1 sources

                        stat.close();
                        break;
                        catch (Throwable rs) {
                            try {
                                var5_7 = rs;
                                throw rs;
                            }
                            catch (Throwable var11_26) {
                                if (stat != null) {
                                    if (var5_7 != null) {
                                        try {
                                            stat.close();
                                        }
                                        catch (Throwable var12_28) {
                                            var5_7.addSuppressed(var12_28);
                                        }
                                    } else {
                                        stat.close();
                                    }
                                }
                                throw var11_26;
                            }
                        }
                    }
                    case 3: {
                        escapedName = this.getName().replace("'", "''");
                        query = "SELECT ACTION_STATEMENT, EVENT_OBJECT_SCHEMA, EVENT_OBJECT_TABLE, ACTION_TIMING, EVENT_MANIPULATION FROM information_schema.triggers WHERE TRIGGER_NAME = '" + escapedName + "';";
                        stat = this.connection.getJDBCConnection().createStatement();
                        var5_8 = null;
                        rs = stat.executeQuery(query);
                        var7_16 = null;
                        try {
                            while (rs.next()) {
                                trigger_time = rs.getString("ACTION_TIMING");
                                trigger_event = rs.getString("EVENT_MANIPULATION");
                                tbl_schema = rs.getString("EVENT_OBJECT_SCHEMA");
                                tbl_table_name = rs.getString("EVENT_OBJECT_TABLE");
                                tbl_name = tbl_schema == null || tbl_schema.length() == 0 ? tbl_table_name : tbl_schema + '.' + tbl_table_name;
                                params = trigger_time + ' ' + trigger_event + " ON " + tbl_name + '\n' + "FOR EACH ROW" + '\n';
                            }
                        }
                        catch (Throwable var8_21) {
                            var7_16 = var8_21;
                            throw var8_21;
                        }
                        finally {
                            if (rs != null) {
                                if (var7_16 != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable var8_20) {
                                        var7_16.addSuppressed(var8_20);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                        }
                        if (stat == null) break;
                        if (var5_8 == null) ** GOTO lbl98
                        try {
                            stat.close();
                        }
                        catch (Throwable var6_13) {
                            var5_8.addSuppressed(var6_13);
                        }
                        break;
lbl98:
                        // 1 sources

                        stat.close();
                        break;
                        catch (Throwable var6_14) {
                            try {
                                var5_8 = var6_14;
                                throw var6_14;
                            }
                            catch (Throwable var15_32) {
                                if (stat != null) {
                                    if (var5_8 != null) {
                                        try {
                                            stat.close();
                                        }
                                        catch (Throwable var16_33) {
                                            var5_8.addSuppressed(var16_33);
                                        }
                                    } else {
                                        stat.close();
                                    }
                                }
                                throw var15_32;
                            }
                        }
                    }
                    default: {
                        if (!MySQL.$assertionsDisabled) {
                            throw new AssertionError((Object)("Unknown type " + (Object)this.getType()));
                        }
                        break;
                    }
                }
            }
            catch (SQLException ex) {
                ProcedureNode.access$1100().log(Level.INFO, "{0} while get params of {1} {2}", new Object[]{ex, ProcedureNode.access$1000(this.getType()), this.getName()});
            }
            return params;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public String getBody() {
            body = "";
            escapedName = "";
            query = "";
            try {
                switch (2.$SwitchMap$org$netbeans$modules$db$explorer$node$ProcedureNode$Type[this.getType().ordinal()]) {
                    case 1: 
                    case 2: {
                        escapedName = this.getName().replace("'", "''");
                        query = "SELECT body FROM mysql.proc WHERE name = '" + escapedName + "';";
                        stat = this.connection.getJDBCConnection().createStatement();
                        var5_7 = null;
                        rs = stat.executeQuery(query);
                        var7_15 = null;
                        try {
                            while (rs.next()) {
                                body = rs.getString("body");
                            }
                        }
                        catch (Throwable var8_18) {
                            var7_15 = var8_18;
                            throw var8_18;
                        }
                        finally {
                            if (rs != null) {
                                if (var7_15 != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable var8_17) {
                                        var7_15.addSuppressed(var8_17);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                        }
                        if (stat == null) break;
                        if (var5_7 == null) ** GOTO lbl41
                        try {
                            stat.close();
                        }
                        catch (Throwable rs) {
                            var5_7.addSuppressed(rs);
                        }
                        break;
lbl41:
                        // 1 sources

                        stat.close();
                        break;
                        catch (Throwable rs) {
                            try {
                                var5_7 = rs;
                                throw rs;
                            }
                            catch (Throwable var11_23) {
                                if (stat != null) {
                                    if (var5_7 != null) {
                                        try {
                                            stat.close();
                                        }
                                        catch (Throwable var12_24) {
                                            var5_7.addSuppressed(var12_24);
                                        }
                                    } else {
                                        stat.close();
                                    }
                                }
                                throw var11_23;
                            }
                        }
                    }
                    case 3: {
                        escapedName = this.getName().replace("'", "''");
                        query = "SELECT ACTION_STATEMENT FROM information_schema.triggers WHERE TRIGGER_NAME = '" + escapedName + "';";
                        stat = this.connection.getJDBCConnection().createStatement();
                        var5_8 = null;
                        rs = stat.executeQuery(query);
                        var7_16 = null;
                        try {
                            while (rs.next()) {
                                body = rs.getString("ACTION_STATEMENT");
                            }
                        }
                        catch (Throwable var8_20) {
                            var7_16 = var8_20;
                            throw var8_20;
                        }
                        finally {
                            if (rs != null) {
                                if (var7_16 != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable var8_19) {
                                        var7_16.addSuppressed(var8_19);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                        }
                        if (stat == null) break;
                        if (var5_8 == null) ** GOTO lbl93
                        try {
                            stat.close();
                        }
                        catch (Throwable var6_13) {
                            var5_8.addSuppressed(var6_13);
                        }
                        break;
lbl93:
                        // 1 sources

                        stat.close();
                        break;
                        catch (Throwable var6_14) {
                            try {
                                var5_8 = var6_14;
                                throw var6_14;
                            }
                            catch (Throwable var15_27) {
                                if (stat != null) {
                                    if (var5_8 != null) {
                                        try {
                                            stat.close();
                                        }
                                        catch (Throwable var16_28) {
                                            var5_8.addSuppressed(var16_28);
                                        }
                                    } else {
                                        stat.close();
                                    }
                                }
                                throw var15_27;
                            }
                        }
                    }
                    default: {
                        if (!MySQL.$assertionsDisabled) {
                            throw new AssertionError((Object)("Unknown type" + (Object)this.getType()));
                        }
                        break;
                    }
                }
            }
            catch (SQLException ex) {
                ProcedureNode.access$1100().log(Level.INFO, "{0} while get body of {1} {2}", new Object[]{ex, ProcedureNode.access$1000(this.getType()), this.getName()});
            }
            return body;
        }

        @Override
        public boolean isEditSourceSupported() {
            return true;
        }

        @Override
        public String getDDL() {
            StringBuilder expression = new StringBuilder();
            String escapedName = this.getName().replace("'", "''");
            expression.append("DELIMITER ").append(ProcedureNode.DELIMITER).append(ProcedureNode.NEW_LINE);
            expression.append("DROP ").append(ProcedureNode.getTypeName(this.getType())).append(ProcedureNode.SPACE).append(escapedName).append(ProcedureNode.SPACE).append(ProcedureNode.DELIMITER).append(ProcedureNode.NEW_LINE);
            expression.append("CREATE ").append(this.getSource());
            expression.append(ProcedureNode.SPACE).append(ProcedureNode.DELIMITER).append(ProcedureNode.SPACE).append(ProcedureNode.NEW_LINE);
            expression.append("DELIMITER ; ").append(ProcedureNode.NEW_LINE);
            return expression.toString();
        }
    }

    public static enum Type {
        Procedure,
        Function,
        Trigger;

    }
}

