/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.ScriptsSourceGroup;
import org.netbeans.modules.javacard.project.deps.ui.DependenciesNode;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.spi.actions.Single;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.NodeList;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidators;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.NewTemplateAction;
import org.openide.actions.PasteAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.WindowManager;

public class JCProjectSourceNodeFactory
implements NodeFactory {
    public NodeList<?> createNodes(Project p) {
        JCProject project = (JCProject)p.getLookup().lookup(JCProject.class);
        assert (project != null);
        return new JCNodeList(project);
    }

    private static class PackageViewFilterNode
    extends FilterNode {
        Action[] actions;

        public PackageViewFilterNode(SourceGroup sourceGroup, Project project) throws DataObjectNotFoundException {
            super(sourceGroup instanceof ScriptsSourceGroup ? DataObject.find((FileObject)sourceGroup.getRootFolder()).getNodeDelegate() : PackageView.createPackageView((SourceGroup)sourceGroup));
            if (sourceGroup instanceof ScriptsSourceGroup) {
                super.disableDelegation(12);
                this.setDisplayName(sourceGroup.getDisplayName());
            }
        }

        public Action[] getActions(boolean context) {
            if (!context) {
                if (this.actions == null) {
                    Action[] superActions = super.getActions(context);
                    this.actions = new Action[superActions.length + 1];
                    System.arraycopy(superActions, 0, this.actions, 0, superActions.length);
                    this.actions[superActions.length] = null;
                }
                return this.actions;
            }
            return super.getActions(context);
        }
    }

    private static class SourceGroupKey {
        public final SourceGroup group;
        public final FileObject fileObject;

        SourceGroupKey(SourceGroup group) {
            this.group = group;
            this.fileObject = group.getRootFolder();
        }

        public int hashCode() {
            int hash = 5;
            String disp = this.group.getDisplayName();
            hash = 79 * hash + (this.fileObject != null ? this.fileObject.hashCode() : 0);
            hash = 79 * hash + (disp != null ? disp.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            boolean twoNull;
            if (!(obj instanceof SourceGroupKey)) {
                return false;
            }
            SourceGroupKey otherKey = (SourceGroupKey)obj;
            if (!(this.fileObject == otherKey.fileObject || this.fileObject != null && this.fileObject.equals(otherKey.fileObject))) {
                return false;
            }
            String thisDisplayName = this.group.getDisplayName();
            String otherDisplayName = otherKey.group.getDisplayName();
            boolean oneNull = thisDisplayName == null;
            boolean bl = twoNull = otherDisplayName == null;
            return oneNull == twoNull && (thisDisplayName == null || thisDisplayName.equals(otherDisplayName));
        }
    }

    private static final class AddTemplateAction
    extends Single<DataFolder> {
        private final boolean html;

        AddTemplateAction(boolean html) {
            super(DataFolder.class);
            String key = html ? "ACTION_NEW_HTML" : "ACTION_NEW_SCRIPT";
            this.putValue("Name", NbBundle.getMessage(AddTemplateAction.class, (String)key));
            this.html = html;
        }

        protected void actionPerformed(DataFolder target) {
            DataObject tpl = this.getTemplate();
            assert (tpl != null);
            NotifyDescriptor.InputLine line = new NotifyDescriptor.InputLine(NbBundle.getMessage(AddTemplateAction.class, (String)"TTL_NEW_FILE_ACTION"), NbBundle.getMessage(AddTemplateAction.class, (String)"NEW_FILE_ACTION", (Object)tpl.getName()));
            if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)line))) {
                String filename = line.getInputText();
                Problems problems = new Problems();
                StringValidators.REQUIRE_VALID_FILENAME.validate(problems, NbBundle.getMessage(JCProjectSourceNodeFactory.class, (String)"FILENAME"), filename);
                if (filename.length() == 0) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JCProjectSourceNodeFactory.class, (String)"WARN_FILENAME_INCORRECT"), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    return;
                }
                if (problems.hasFatal()) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)problems.getLeadProblem().getMessage(), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    return;
                }
                try {
                    DataObject ob = tpl.createFromTemplate(target, filename);
                    EditCookie ec = (EditCookie)ob.getLookup().lookup(EditCookie.class);
                    if (ec == null) {
                        OpenCookie oc = (OpenCookie)ob.getLookup().lookup(OpenCookie.class);
                        if (oc != null) {
                            oc.open();
                        }
                    } else {
                        ec.edit();
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), ex.getLocalizedMessage());
                }
            }
        }

        private DataObject getTemplate() {
            String template = this.html ? "Templates/Other/html.html" : "Templates/Other/ApduTemplate.scr";
            FileObject fo = FileUtil.getConfigFile((String)template);
            if (fo != null) {
                try {
                    return DataObject.find((FileObject)fo);
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }

        protected boolean isEnabled(DataFolder target) {
            return this.getTemplate() != null && target.getPrimaryFile().canWrite();
        }
    }

    private static class ScriptsNode
    extends FilterNode {
        ScriptsNode(FileObject fileObject, JCProject project) throws DataObjectNotFoundException {
            this(fileObject == null ? Node.EMPTY : DataObject.find((FileObject)fileObject).getNodeDelegate(), project);
        }

        private ScriptsNode(Node n, JCProject project) {
            super(n, (Children)new FilterNode.Children(n), (Lookup)new ProxyLookup(new Lookup[]{n.getLookup(), Lookups.fixed((Object[])new Object[]{project})}));
            this.disableDelegation(2);
            this.disableDelegation(32);
            this.disableDelegation(8);
            this.disableDelegation(128);
            this.disableDelegation(1);
            this.disableDelegation(16);
            this.disableDelegation(4);
            this.setName(n.getName());
            String key = project.kind().isApplet() ? "SCRIPTS_NODE_NAME" : "WEB_PAGES_NODE_NAME";
            this.setDisplayName(NbBundle.getMessage(ScriptsNode.class, (String)key));
        }

        public Action[] getActions(boolean context) {
            JCProject p = (JCProject)this.getLookup().lookup(JCProject.class);
            return new Action[]{new AddTemplateAction(p.kind() == ProjectKind.WEB), SystemAction.get(NewTemplateAction.class), SystemAction.get(PasteAction.class)};
        }

        public String getHtmlDisplayName() {
            if (this.getLookup().lookup(DataObject.class) == null) {
                return "<font color=\"nb.errorForeground\">" + this.getDisplayName();
            }
            return null;
        }

        public Image getIcon(int type) {
            JCProject p = (JCProject)this.getLookup().lookup(JCProject.class);
            return ImageUtilities.loadImage((String)(p.kind().isApplet() ? "org/netbeans/modules/javacard/resources/scripts.png" : "org/netbeans/modules/javacard/resources/webpages.png"));
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }
    }

    private static class JCNodeList
    implements NodeList<Object>,
    ChangeListener {
        private JCProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public JCNodeList(JCProject proj) {
            this.project = proj;
        }

        public List<Object> keys() {
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.emptyList();
            }
            Sources sources = this.getSources();
            SourceGroup[] groups = sources.getSourceGroups("java");
            ArrayList<Object> result = new ArrayList<Object>(groups.length);
            for (int i = 0; i < groups.length; ++i) {
                result.add(new SourceGroupKey(groups[i]));
            }
            if (!this.project.kind().isLibrary()) {
                result.add((Object)ProjectNodeKinds.SCRIPTS_OR_WEB_PAGES);
            }
            result.add((Object)ProjectNodeKinds.IMPORTANT_FILES);
            result.add((Object)ProjectNodeKinds.LIBRARIES);
            return result;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public Node node(Object key) {
            if (key instanceof SourceGroupKey) {
                SourceGroupKey sgKey = (SourceGroupKey)key;
                try {
                    return new PackageViewFilterNode(sgKey.group, this.project);
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else if (key instanceof ProjectNodeKinds) {
                switch ((ProjectNodeKinds)((Object)key)) {
                    case IMPORTANT_FILES: {
                        return new ImportantFilesNode(this.project);
                    }
                    case LIBRARIES: {
                        return new DependenciesNode(this.project);
                    }
                    case SCRIPTS_OR_WEB_PAGES: {
                        try {
                            return new ScriptsNode(this.project.getProjectDirectory().getFileObject(this.project.kind().isApplet() ? "scripts" : "html"), this.project);
                        }
                        catch (DataObjectNotFoundException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            break;
                        }
                    }
                    default: {
                        throw new AssertionError((Object)(key + ""));
                    }
                }
            }
            throw new AssertionError(key.getClass());
        }

        public void addNotify() {
            this.getSources().addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            this.getSources().removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JCNodeList.this.changeSupport.fireChange();
                }
            });
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }
    }

    static enum ProjectNodeKinds {
        IMPORTANT_FILES,
        SCRIPTS_OR_WEB_PAGES,
        LIBRARIES;

    }

    private static class ImportantFilesNode
    extends AbstractNode {
        public ImportantFilesNode(JCProject project) {
            super(NodeFactorySupport.createCompositeChildren((Project)project, (String)project.kind().importantFilesPath()), Lookups.singleton((Object)project));
            this.setDisplayName(NbBundle.getMessage(JCProjectSourceNodeFactory.class, (String)"LBL_IMPORTANT_FILES"));
            this.setIconBaseWithExtension("org/netbeans/modules/javacard/resources/importantfiles.png");
        }
    }
}

