/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.deps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javacard.project.deps.ArtifactKind;
import org.netbeans.modules.javacard.project.deps.Dependencies;
import org.netbeans.modules.javacard.project.deps.DependenciesResolver;
import org.netbeans.modules.javacard.project.deps.Dependency;
import org.netbeans.modules.javacard.project.deps.ResolvedDependency;
import org.openide.util.ChangeSupport;

public abstract class ResolvedDependencies {
    private final List<ResolvedDependency> deps = Collections.synchronizedList(new ArrayList());
    private final Dependencies dependencies;
    protected final DependenciesResolver resolver;
    private final Dependencies origDependencies;
    private final ChangeSupport supp = new ChangeSupport((Object)this);

    public ResolvedDependencies(Dependencies dependencies, DependenciesResolver resolver) {
        this.dependencies = dependencies.copy();
        this.origDependencies = dependencies;
        this.resolver = resolver;
        for (Dependency dep : dependencies.all()) {
            this.deps.add(new ResolvedDependency(dep, resolver));
        }
    }

    public final List<? extends ResolvedDependency> all() {
        HashSet<String> ids = new HashSet<String>(this.deps.size());
        ArrayList<ResolvedDependency> result = new ArrayList<ResolvedDependency>();
        for (ResolvedDependency d : this.deps) {
            if (ids.contains(d.dep().getID())) continue;
            result.add(d);
            ids.add(d.dep().getID());
        }
        return result;
    }

    public final ResolvedDependency add(Dependency d, Map<ArtifactKind, String> paths) {
        this.dependencies.add(d);
        ResolvedDependency r = new ResolvedDependency(d, this.resolver, paths);
        this.deps.add(r);
        this.supp.fireChange();
        return r;
    }

    public final void remove(ResolvedDependency r) {
        String id = r.dep().getID();
        this.removeById(id);
        this.deps.remove(r);
        this.supp.fireChange();
    }

    private void removeById(String id) {
        Iterator<Object> it = this.deps.iterator();
        while (it.hasNext()) {
            ResolvedDependency resolvedDependency = it.next();
            if (!resolvedDependency.getDependency().getID().equals(id)) continue;
            it.remove();
        }
        for (Dependency dependency : new ArrayList<Dependency>(this.dependencies.all())) {
            if (!dependency.getID().equals(id)) continue;
            this.dependencies.remove(dependency);
        }
    }

    public final Dependencies getDependencies() {
        Dependencies result = new Dependencies();
        for (ResolvedDependency r : this.deps) {
            result.add(r.getDependency());
        }
        return result;
    }

    public void removeChangeListener(ChangeListener listener) {
        this.supp.removeChangeListener(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.supp.addChangeListener(listener);
    }

    public final boolean isValid() {
        boolean result = true;
        for (ResolvedDependency r : this.deps) {
            if (r.isValid()) continue;
            result = false;
            break;
        }
        return result;
    }

    public final boolean moveUp(ResolvedDependency d) {
        boolean result;
        int ix = this.deps.indexOf(d);
        assert (ix >= 0);
        boolean bl = result = ix > 0;
        if (result) {
            this.deps.remove(d);
            this.deps.add(ix - 1, d);
            this.supp.fireChange();
        }
        return result;
    }

    public final boolean moveDown(ResolvedDependency d) {
        boolean result;
        int ix = this.deps.indexOf(d);
        assert (ix >= 0);
        boolean bl = result = ix < this.deps.size() - 1;
        if (result) {
            this.deps.remove(d);
            this.deps.add(ix + 1, d);
            this.supp.fireChange();
        }
        return result;
    }

    public final boolean canMoveUp(ResolvedDependency d) {
        return !this.deps.isEmpty() && !d.equals(this.deps.get(0));
    }

    public final boolean canMoveDown(ResolvedDependency d) {
        return !this.deps.isEmpty() && !d.equals(this.deps.get(this.deps.size() - 1));
    }

    public final boolean isModified() {
        boolean result;
        block1: {
            ResolvedDependency r;
            boolean bl = result = !this.origDependencies.equals(this.getDependencies());
            if (result) break block1;
            Iterator<ResolvedDependency> iterator = this.deps.iterator();
            while (iterator.hasNext() && !(result = (r = iterator.next()).isPathsModified() | r.dep().getDeploymentStrategy() != r.getDeploymentStrategy())) {
            }
        }
        return result;
    }

    public final void save() throws IOException {
        if (!this.isModified()) {
            return;
        }
        this.doSave();
    }

    public ResolvedDependency get(String id) {
        for (ResolvedDependency d : this.deps) {
            if (!id.equals(d.getDependency().getID())) continue;
            return d;
        }
        ArrayList<ResolvedDependency> old = new ArrayList<ResolvedDependency>(this.deps);
        this.deps.clear();
        ResolvedDependency result = null;
        for (Dependency dep : this.dependencies.all()) {
            ResolvedDependency rd = null;
            for (ResolvedDependency oldRd : old) {
                if (!dep.getID().equals(oldRd.dep().getID())) continue;
                rd = oldRd;
                break;
            }
            if (rd == null) {
                rd = new ResolvedDependency(dep, this.resolver);
            }
            if (id.equals(dep.getID())) {
                result = rd;
            }
            this.deps.add(rd);
        }
        return result;
    }

    protected Dependencies getOriginalDependencies() {
        return this.origDependencies.copy();
    }

    protected abstract void doSave() throws IOException;
}

