/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.toolchains.impl;

import org.clang.driver.Action;
import org.clang.driver.Driver;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.MinGWToolChainStatics;
import org.clang.driver.options;
import org.clang.driver.tools.impl.GccStatics;
import org.clang.driver.tools.impl.MinGWStatics;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;
import org.llvm.support.sys.path;

public class MinGW
extends ToolChain
implements Destructors.ClassWithDestructor {
    private std.string Base = new std.string();
    private std.string GccLibDir = new std.string();
    private std.string Ver = new std.string();
    private std.string Arch = new std.string();
    private std_ptr.unique_ptr<GccStatics.Preprocessor> Preprocessor = new std_ptr.unique_ptr();
    private std_ptr.unique_ptr<GccStatics.Compiler> Compiler = new std_ptr.unique_ptr();

    public MinGW(Driver D, Triple Triple2, ArgList Args) {
        super(D, Triple2, Args);
        this.getProgramPaths().push_back((Object)new std.string(this.getDriver().getInstalledDir()));
        if (this.getDriver().SysRoot.size() != 0) {
            this.Base.$assign(this.getDriver().SysRoot);
        } else {
            this.Base.$assign((CharSequence)"/usr");
        }
        llvm.$addassign_str_StringRef((std.string)this.Base, (StringRef)path.get_separator());
        this.findGccLibDir();
        this.getFilePaths().push_back((Object)this.GccLibDir);
        this.getFilePaths().push_back((Object)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(std.$add_str$C((std.string)this.Base, (std.string)this.Arch)), (Twine)new Twine(path.get_separator())), (Twine)new Twine("lib")).str());
        this.getFilePaths().push_back((Object)std.$add_str$C_T((std.string)this.Base, (CharSequence)"lib"));
        this.getFilePaths().push_back((Object)std.$add_str_T((std.string)std.$add_str$C((std.string)this.Base, (std.string)this.Arch), (String)"/sys-root/mingw/lib"));
    }

    @Override
    public boolean IsIntegratedAssemblerDefault() {
        return true;
    }

    @Override
    public boolean IsUnwindTablesDefault() {
        return this.getArch() == Triple.ArchType.x86_64;
    }

    @Override
    public boolean isPICDefault() {
        return this.getArch() == Triple.ArchType.x86_64;
    }

    @Override
    public boolean isPIEDefault() {
        return false;
    }

    @Override
    public boolean isPICDefaultForced() {
        return this.getArch() == Triple.ArchType.x86_64;
    }

    public boolean UseSEHExceptions() {
        return this.getArch() == Triple.ArchType.x86_64;
    }

    @Override
    public void AddClangSystemIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
        if (DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdinc.getValue()))) {
            return;
        }
        if (!DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nobuiltininc.getValue()))) {
            SmallString P = new SmallString(new StringRef(this.getDriver().ResourceDir), 1024);
            path.append((SmallString)P, (Twine)new Twine(NativePointer.$include));
            MinGW.addSystemInclude(DriverArgs, CC1Args, new Twine(P.str()));
        }
        if (DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdlibinc.getValue()))) {
            return;
        }
        if (this.GetRuntimeLibType(DriverArgs) == ToolChain.RuntimeLibType.RLT_Libgcc) {
            SmallString IncludeDir = new SmallString(new StringRef(this.GccLibDir), 1024);
            path.append((SmallString)IncludeDir, (Twine)new Twine(NativePointer.$include));
            MinGW.addSystemInclude(DriverArgs, CC1Args, new Twine(IncludeDir.c_str()));
            IncludeDir.$addassign("-fixed");
            MinGW.addSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_str_T((std.string)std.$add_str$C((std.string)this.Base, (std.string)this.Arch), (String)"/sys-root/mingw/include")));
            MinGW.addSystemInclude(DriverArgs, CC1Args, new Twine(IncludeDir.c_str()));
        }
        MinGW.addSystemInclude(DriverArgs, CC1Args, llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(std.$add_str$C((std.string)this.Base, (std.string)this.Arch)), (Twine)new Twine(path.get_separator())), (Twine)new Twine(NativePointer.$include)));
        MinGW.addSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_str$C_T((std.string)this.Base, (CharSequence)"include")));
    }

    @Override
    public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
        if (DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdlibinc.getValue())) || DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdincxx.getValue()))) {
            return;
        }
        switch (this.GetCXXStdlibType(DriverArgs)) {
            case CST_Libcxx: {
                MinGW.addSystemInclude(DriverArgs, CC1Args, llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(std.$add_str$C_T((std.string)this.Base, (CharSequence)"include")), (Twine)new Twine(path.get_separator())), (Twine)new Twine("c++")), (Twine)new Twine(path.get_separator())), (Twine)new Twine("v1")));
                break;
            }
            case CST_Libstdcxx: {
                SmallVector CppIncludeBases = new SmallVector(4);
                CppIncludeBases.emplace_back((Object)new SmallString(this.Base));
                path.append((SmallString)((SmallString)CppIncludeBases.$at(0)), (Twine)new Twine(this.Arch), (Twine)new Twine(NativePointer.$include), (Twine)new Twine("c++"));
                CppIncludeBases.emplace_back((Object)new SmallString(this.Base));
                path.append((SmallString)((SmallString)CppIncludeBases.$at(1)), (Twine)new Twine(this.Arch), (Twine)new Twine(NativePointer.$include), (Twine)new Twine("c++"), (Twine)new Twine(this.Ver));
                CppIncludeBases.emplace_back((Object)new SmallString(this.Base));
                path.append((SmallString)((SmallString)CppIncludeBases.$at(2)), (Twine)new Twine(NativePointer.$include), (Twine)new Twine("c++"), (Twine)new Twine(this.Ver));
                CppIncludeBases.emplace_back((Object)new SmallString(this.GccLibDir));
                path.append((SmallString)((SmallString)CppIncludeBases.$at(3)), (Twine)new Twine(NativePointer.$include), (Twine)new Twine("c++"));
                for (SmallString CppIncludeBase : CppIncludeBases) {
                    MinGW.addSystemInclude(DriverArgs, CC1Args, new Twine(CppIncludeBase));
                    CppIncludeBase.$addassign(path.get_separator());
                    MinGW.addSystemInclude(DriverArgs, CC1Args, llvm.$add_Twine((Twine)new Twine(CppIncludeBase), (Twine)new Twine(this.Arch)));
                    MinGW.addSystemInclude(DriverArgs, CC1Args, llvm.$add_StringRef_char$ptr$C((StringRef)CppIncludeBase.$StringRef(), (String)"backward"));
                }
                break;
            }
        }
    }

    @Override
    protected Tool getTool(Action.ActionClass AC) {
        switch (AC) {
            case PreprocessJobClass: {
                if (!this.Preprocessor.$bool()) {
                    this.Preprocessor.reset((Object)new GccStatics.Preprocessor(this));
                }
                return (Tool)this.Preprocessor.get();
            }
            case CompileJobClass: {
                if (!this.Compiler.$bool()) {
                    this.Compiler.reset((Object)new GccStatics.Compiler(this));
                }
                return (Tool)this.Compiler.get();
            }
        }
        return super.getTool(AC);
    }

    @Override
    protected Tool buildLinker() {
        return new MinGWStatics.Linker(this);
    }

    @Override
    protected Tool buildAssembler() {
        return new MinGWStatics.Assembler(this);
    }

    private void findGccLibDir() {
        SmallVector Archs = new SmallVector(2);
        Archs.emplace_back((Object)new SmallString(this.getTriple().getArchName().str()));
        ((SmallString)Archs.$at(0)).$addassign("-w64-mingw32");
        Archs.emplace_back((Object)new SmallString("mingw32"));
        this.Arch.$assignMove(((SmallString)Archs.$at(0)).str().$basic_string());
        for (StringRef CandidateLib : new StringRef[]{new StringRef("lib"), new StringRef("lib64")}) {
            for (SmallString A : Archs) {
                StringRef CandidateArch = A.$StringRef();
                SmallString LibDir = new SmallString(new StringRef(this.Base), 1024);
                path.append((SmallString)LibDir, (Twine)new Twine(CandidateLib), (Twine)new Twine("gcc"), (Twine)new Twine(CandidateArch));
                if (!MinGWToolChainStatics.findGccVersion(LibDir.$StringRef(), this.GccLibDir, this.Ver)) continue;
                this.Arch.$assignMove(CandidateArch.$basic_string());
                return;
            }
        }
    }

    @Override
    public void $destroy() {
        this.Compiler.$destroy();
        this.Preprocessor.$destroy();
        this.Arch.$destroy();
        this.Ver.$destroy();
        this.GccLibDir.$destroy();
        this.Base.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "Base=" + this.Base + ", GccLibDir=" + this.GccLibDir + ", Ver=" + this.Ver + ", Arch=" + this.Arch + ", Preprocessor=" + this.Preprocessor + ", Compiler=" + this.Compiler + super.toString();
    }
}

