/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;

public final class PathArchive
implements Archive {
    private final Path root;
    private final String rootURI;
    private final char separator;

    PathArchive(@NonNull Path root, @NullAllowed URI rootURI) {
        assert (root != null);
        this.root = root;
        this.rootURI = rootURI == null ? null : rootURI.toString();
        String separator = root.getFileSystem().getSeparator();
        if (separator.length() != 1) {
            throw new IllegalArgumentException("Multi character separators are unsupported");
        }
        this.separator = separator.charAt(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public Iterable<JavaFileObject> getFiles(@NonNull String folderName, @NullAllowed ClassPath.Entry entry, @NullAllowed Set<JavaFileObject.Kind> kinds, @NullAllowed JavaFileFilterImplementation filter) throws IOException {
        if (this.separator != '/') {
            folderName = folderName.replace('/', this.separator);
        }
        Path target = this.root.resolve(folderName);
        try (DirectoryStream<Path> dir = Files.newDirectoryStream(target, new KindFilter(kinds));){
            ArrayList<InferableJavaFileObject> res = new ArrayList<InferableJavaFileObject>();
            for (Path dirEnt : dir) {
                res.add(FileObjects.pathFileObject(dirEnt, this.root, this.rootURI, null));
            }
            ArrayList<InferableJavaFileObject> arrayList = res;
            return arrayList;
        }
        catch (NoSuchFileException | NotDirectoryException e) {
            return Collections.emptyList();
        }
    }

    @Override
    @CheckForNull
    public JavaFileObject getFile(@NonNull String name) throws IOException {
        Path target;
        if (this.separator != '/') {
            name = name.replace('/', this.separator);
        }
        return Files.exists(target = this.root.resolve(name), new LinkOption[0]) ? FileObjects.pathFileObject(target, this.root, this.rootURI, null) : null;
    }

    @Override
    public JavaFileObject create(String relativeName, JavaFileFilterImplementation filter) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Write not supported");
    }

    @Override
    public void clear() {
    }

    private static final class KindFilter
    implements DirectoryStream.Filter<Path> {
        private final Set<JavaFileObject.Kind> kinds;

        KindFilter(@NullAllowed Set<JavaFileObject.Kind> kinds) {
            this.kinds = kinds;
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            if (Files.isDirectory(entry, new LinkOption[0])) {
                return false;
            }
            if (this.kinds == null) {
                return true;
            }
            return this.kinds.contains((Object)FileObjects.getKind(FileObjects.getExtension(entry.getFileName().toString())));
        }
    }
}

