/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.databinding;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.netbeans.microedition.databinding.DataBindingException;
import org.netbeans.microedition.databinding.DataBindingProvider;
import org.netbeans.microedition.databinding.DataSet;
import org.netbeans.microedition.databinding.IndexableDataSet;
import org.netbeans.microedition.databinding.core.BindDescriptor;
import org.netbeans.microedition.databinding.core.DataBindingELContext;
import org.netbeans.microedition.databinding.el.StringReader;
import org.netbeans.microedition.databinding.el.parser.ELParser;
import org.netbeans.microedition.databinding.el.parser.ParseException;

public final class DataBinder {
    private static Hashtable rootDataSets = new Hashtable();
    private static Vector binds = new Vector();

    private DataBinder() {
    }

    public static void bind(String elPointer, DataBindingProvider binder, Object consumer, Object feature) {
        BindDescriptor desc = new BindDescriptor(elPointer, binder, consumer, feature);
        boolean found = false;
        for (int a = 0; a < binds.size(); ++a) {
            BindDescriptor inner = (BindDescriptor)binds.elementAt(a);
            if (!inner.equalsBindTarget(desc)) continue;
            binds.setElementAt(desc, a);
            found = true;
            break;
        }
        if (!found) {
            binds.addElement(desc);
        }
        desc.notifyBind();
        desc.updateFromDataSourceToCustomer();
    }

    public static void unbind(Object consumer, Object feature) {
        BindDescriptor desc = new BindDescriptor(null, null, consumer, feature);
        for (int a = 0; a < binds.size(); ++a) {
            BindDescriptor inner = (BindDescriptor)binds.elementAt(a);
            if (!inner.equalsBindTarget(desc)) continue;
            inner.notifyUnbind();
            binds.removeElementAt(a);
            return;
        }
    }

    public static void registerDataSet(DataSet dataSet, String variable) {
        if (dataSet == null) {
            throw new IllegalArgumentException("null dataset");
        }
        if (variable == null) {
            throw new IllegalArgumentException("null variable");
        }
        if (rootDataSets.contains(variable)) {
            throw new IllegalArgumentException("variable already registered");
        }
        rootDataSets.put(variable, dataSet);
        DataBinder.fireDataSetChanged(null, variable);
    }

    public static void unregisterDataSet(String variable) {
        if (variable == null) {
            throw new IllegalArgumentException("null variable");
        }
        if (rootDataSets.remove(variable) == null) {
            throw new IllegalArgumentException("variable not registered");
        }
        DataBinder.fireDataSetChanged(null, variable);
    }

    public static DataSet getRegisteredDataSet(String variable) {
        return (DataSet)rootDataSets.get(variable);
    }

    public static void updateConsumer(String elPointer, DataBindingProvider binder, Object consumer, Object feature) {
        new BindDescriptor(elPointer, binder, consumer, feature).updateFromDataSourceToCustomer();
    }

    public static void updateDataSet(String elPointer, DataBindingProvider binder, Object consumer, Object feature) {
        new BindDescriptor(elPointer, binder, consumer, feature).updateFromCustomerToDataSource();
    }

    public static Object readValue(String elPointer) {
        ELParser parser = new ELParser(new StringReader(elPointer), DataBindingELContext.CONTEXT, false);
        try {
            return parser.Expression();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeValue(String elPointer, Object value) {
        ELParser parser = new ELParser(new StringReader(elPointer), DataBindingELContext.CONTEXT, true);
        try {
            parser.Expression();
            Object pointerProperty = parser.getLastPointerProperty();
            if (pointerProperty instanceof String) {
                ((DataSet)parser.getLastPointerBase()).setValue((String)pointerProperty, value);
            }
            if (pointerProperty instanceof Integer) {
                ((IndexableDataSet)parser.getLastPointerBase()).setRow((Integer)pointerProperty, value);
            }
            if (pointerProperty instanceof Long) {
                ((IndexableDataSet)parser.getLastPointerBase()).setRow((int)((Long)pointerProperty).longValue(), value);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (DataBindingException e) {
            e.printStackTrace();
        }
    }

    public static void insertRow(String elPointer, int index, Object value) {
        throw new IllegalStateException("Not implemented yet!");
    }

    public static void deleteRow(String elPointer, int index) {
        throw new IllegalStateException("Not implemented yet!");
    }

    public static void fireDataSetChanged(DataSet dataSet, Object dataItemName) {
        if (dataItemName instanceof Long) {
            throw new IllegalArgumentException("Long indexing is forbidden.");
        }
        Enumeration e = binds.elements();
        while (e.hasMoreElements()) {
            BindDescriptor desc = (BindDescriptor)e.nextElement();
            if (!desc.containsDataSetItem(dataSet, dataItemName)) continue;
            desc.updateFromDataSourceToCustomer();
        }
    }
}

