/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.startup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.mobility.cldcplatform.startup.LibraryConverter;
import org.netbeans.modules.mobility.cldcplatform.startup.PostInstallJ2meAction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInstall;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DefaultEmulatorInstall
extends ModuleInstall {
    private static final String EMU_MARKER = "emu_installed.mark";
    private static final String DSC_MARKER = "dsc_installed.mark";

    public void restored() {
        new LibraryConverter();
        this.installEmulators();
        this.installDescriptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installDescriptors() {
        FileObject platformsFolder;
        FileObject descRoot = FileUtil.getConfigFile((String)"emulator-descriptor-inst");
        try {
            platformsFolder = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)"Services/Platforms/org-netbeans-api-java-Platform");
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            return;
        }
        byte[] data = new byte[256];
        if (descRoot != null) {
            for (FileObject desc : descRoot.getChildren()) {
                InputStream is = null;
                OutputStreamWriter os = null;
                FileLock fl = null;
                File installRoot = FileUtil.toFile((FileObject)desc);
                if (!installRoot.isFile() || (installRoot = installRoot.getParentFile()) == null || (installRoot = installRoot.getParentFile()) == null || (installRoot = installRoot.getParentFile()) == null || !desc.getExt().equals("xml")) continue;
                if (platformsFolder.getFileObject(desc.getNameExt()) != null) {
                    ErrorManager.getDefault().log("Emulator description file already installed: " + installRoot.getAbsolutePath());
                    continue;
                }
                try {
                    int len;
                    is = desc.getInputStream();
                    StringBuffer sb = new StringBuffer(1024);
                    while ((len = is.read(data)) != -1) {
                        sb.append(new String(data, 0, len, "UTF-8"));
                    }
                    is.close();
                    is = null;
                    FileObject fo = platformsFolder.createData(desc.getNameExt());
                    fl = fo.lock();
                    os = new OutputStreamWriter(fo.getOutputStream(fl), "UTF8");
                    os.write(MessageFormat.format(sb.toString(), XMLUtil.toAttributeValue((String)installRoot.getAbsolutePath())));
                    os.close();
                    os = null;
                    desc.delete();
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fl != null && fl.isValid()) {
                        fl.releaseLock();
                    }
                }
            }
        }
    }

    public void installEmulators() {
        File[] emulators = this.getAvailableEmulators();
        if (emulators == null || emulators.length <= 0) {
            ErrorManager.getDefault().log(1, "No emulator available");
            return;
        }
        for (int i = 0; i < emulators.length; ++i) {
            File emulator = emulators[i];
            File target = this.getTargetFolder(emulator);
            String root = this.getEmulatorRootInPack(emulator);
            if (root == null || target == null) continue;
            File rootFolder = new File(target, root);
            if (new File(rootFolder, EMU_MARKER).exists()) {
                String path;
                this.checkJavaPath(rootFolder);
                ErrorManager.getDefault().log(1, "Emulator already installed: " + emulator.getAbsolutePath());
                if (new File(rootFolder, DSC_MARKER).exists()) continue;
                try {
                    path = rootFolder.getCanonicalPath();
                }
                catch (IOException e) {
                    path = rootFolder.getAbsolutePath();
                }
                if (this.installDescriptionFile(emulator, path)) continue;
                ErrorManager.getDefault().log("Emulator description file already installed: " + emulator.getAbsolutePath());
                continue;
            }
            this.installEmulator(emulator, target, root);
        }
    }

    private File[] getAvailableEmulators() {
        ArrayList<File> ret = new ArrayList<File>();
        InstalledFileLocator instance = InstalledFileLocator.getDefault();
        File folder = instance.locate("emulators-inst", "org.netbeans.modules.kjava.emulators", false);
        if (folder == null || !folder.exists() || !folder.isDirectory()) {
            return new File[0];
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (int j = 0; j < files.length; ++j) {
                String name;
                File file = files[j];
                if (!file.exists() || !file.isFile() || this.isAlreadyInstalled(file) || !(name = file.getName().toLowerCase()).endsWith(".zip") && !name.endsWith(".jar")) continue;
                ret.add(file);
            }
        }
        return ret.toArray(new File[ret.size()]);
    }

    private boolean isAlreadyInstalled(File emulatorPack) {
        String[] desc = this.getDescriptionFile(emulatorPack);
        if (desc == null || desc.length != 2) {
            return false;
        }
        FileObject platformsFolder = FileUtil.getConfigFile((String)"Services/Platforms/org-netbeans-api-java-Platform");
        FileObject df = platformsFolder.getFileObject(desc[0]);
        if (df != null) {
            JavaPlatform[] pl;
            File target = this.getTargetFolder(emulatorPack);
            String root = this.getEmulatorRootInPack(emulatorPack);
            File rootFolder = new File(target, root);
            Document doc = null;
            try {
                doc = XMLUtil.parse((InputSource)new InputSource(df.getInputStream()), (boolean)false, (boolean)false, null, (EntityResolver)new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) {
                        return new InputSource(new ByteArrayInputStream(new byte[0]));
                    }
                });
            }
            catch (Exception ex) {
                return false;
            }
            Attr st = doc.getDocumentElement().getAttributeNode("displayname");
            if (st == null) {
                return false;
            }
            String displayName = st.getValue();
            for (JavaPlatform pli : pl = JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                String name = pli.getDisplayName();
                if (!name.equals(displayName)) continue;
                for (FileObject obj : pli.getInstallFolders()) {
                    if (rootFolder.getAbsolutePath().equals(FileUtil.toFile((FileObject)obj).getAbsolutePath())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private String archiveName2FolderName(File emulatorPack) {
        if (emulatorPack != null) {
            String name = emulatorPack.getName().toLowerCase();
            if (name.endsWith(".zip")) {
                name = name.substring(0, name.length() - ".zip".length());
            } else if (name.endsWith(".jar")) {
                name = name.substring(0, name.length() - ".jar".length());
            }
            return name;
        }
        return "unknown";
    }

    private File getTargetFolder(File emulatorPack) {
        if (emulatorPack == null) {
            return null;
        }
        FileObject root = FileUtil.getConfigRoot();
        if (root == null) {
            return null;
        }
        File rootFolder = FileUtil.toFile((FileObject)root);
        if (rootFolder == null) {
            return null;
        }
        if ((rootFolder = rootFolder.getParentFile()) == null) {
            return null;
        }
        return new File(rootFolder, "emulators" + File.separator + this.archiveName2FolderName(emulatorPack));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEmulatorRootInPack(File emulatorPack) {
        if (emulatorPack == null) {
            return null;
        }
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(emulatorPack)));
            while (true) {
                ZipEntry entry;
                if ((entry = zis.getNextEntry()) != null) {
                    int i;
                    String name = entry.getName();
                    if (!entry.isDirectory() && (i = (name = name.replace('\\', '/')).toLowerCase().indexOf("bin/emulator")) >= 0) {
                        String string = name.substring(0, i).replace('/', File.separatorChar);
                        return string;
                    }
                    zis.closeEntry();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().log(1, "IOException while detecting emulator pack: " + emulatorPack.getAbsolutePath());
        }
        finally {
            if (zis != null) {
                try {
                    zis.closeEntry();
                }
                catch (IOException iOException) {}
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private void installEmulator(final File emulatorPack, final File targetFolder, String root) {
        String path;
        final File rootFolder = new File(targetFolder, root);
        try {
            path = rootFolder.getCanonicalPath();
        }
        catch (IOException e) {
            path = rootFolder.getAbsolutePath();
        }
        rootFolder.mkdirs();
        if (!this.installDescriptionFile(emulatorPack, path)) {
            ErrorManager.getDefault().log("Emulator description file already installed: " + emulatorPack.getAbsolutePath());
        }
        final RequestProcessor rp = new RequestProcessor();
        rp.post(new Runnable(){

            @Override
            public void run() {
                if (!DefaultEmulatorInstall.this.unpackEmulator(emulatorPack, targetFolder)) {
                    ErrorManager.getDefault().log("Failed to unpack emulator: " + emulatorPack.getAbsolutePath());
                    return;
                }
                ErrorManager.getDefault().log("Emulator unpacked: " + emulatorPack.getAbsolutePath());
                try {
                    new File(rootFolder, DefaultEmulatorInstall.EMU_MARKER).createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                DefaultEmulatorInstall.this.checkJavaPath(rootFolder);
                rp.stop();
            }
        }, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean installDescriptionFile(File emulatorPack, String rootPath) {
        String[] desc = this.getDescriptionFile(emulatorPack);
        if (desc == null || desc.length != 2) {
            return false;
        }
        FileObject platformsFolder = FileUtil.getConfigFile((String)"Services/Platforms/org-netbeans-api-java-Platform");
        if (platformsFolder.getFileObject(desc[0]) != null) {
            ErrorManager.getDefault().log("Emulator description file already installed: " + emulatorPack.getAbsolutePath());
            return false;
        }
        try {
            rootPath = XMLUtil.toAttributeValue((String)rootPath);
        }
        catch (CharConversionException cce) {
            ErrorManager.getDefault().notify((Throwable)cce);
        }
        String s = MessageFormat.format(desc[1], rootPath);
        OutputStreamWriter bos = null;
        FileLock fl = null;
        try {
            FileObject fo = platformsFolder.createData(desc[0]);
            fl = fo.lock();
            bos = new OutputStreamWriter(fo.getOutputStream(fl), "UTF8");
            bos.write(s);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException iOException) {}
            if (fl != null) {
                fl.releaseLock();
            }
        }
        try {
            new File(rootPath, DSC_MARKER).createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getDescriptionFile(File emulatorPack) {
        if (emulatorPack == null) {
            return null;
        }
        ZipInputStream zis = null;
        byte[] data = new byte[256];
        try {
            ZipEntry entry;
            zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(emulatorPack)));
            while ((entry = zis.getNextEntry()) != null) {
                String name = entry.getName();
                if (!entry.isDirectory() && name.indexOf(47) == -1 && name.indexOf(92) == -1 && name.toLowerCase().endsWith(".xml")) {
                    int len;
                    StringBuffer sb = new StringBuffer(1024);
                    while ((len = zis.read(data)) != -1) {
                        sb.append(new String(data, 0, len));
                    }
                    String[] stringArray = new String[]{name, sb.toString()};
                    return stringArray;
                }
                zis.closeEntry();
            }
            zis.close();
        }
        catch (IOException iOException) {
        }
        finally {
            data = null;
            if (zis != null) {
                try {
                    zis.closeEntry();
                }
                catch (IOException iOException) {}
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unpackEmulator(File emulatorPack, File targetFolder) {
        if (emulatorPack == null) {
            return false;
        }
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(emulatorPack)));
            while ((entry = zis.getNextEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory()) {
                    File dir = new File(targetFolder, name);
                    dir.mkdirs();
                } else {
                    if (name.indexOf(47) == -1 && name.indexOf(92) == -1 && name.toLowerCase().endsWith(".xml")) {
                        zis.closeEntry();
                        continue;
                    }
                    File file = new File(targetFolder, name);
                    if (file.createNewFile()) {
                        BufferedOutputStream bos = null;
                        byte[] data = new byte[256];
                        try {
                            int len;
                            bos = new BufferedOutputStream(new FileOutputStream(file));
                            while ((len = zis.read(data)) != -1) {
                                bos.write(data, 0, len);
                            }
                        }
                        finally {
                            data = null;
                            if (bos != null) {
                                try {
                                    bos.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                }
                zis.closeEntry();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zis != null) {
                try {
                    zis.closeEntry();
                }
                catch (IOException iOException) {}
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkJavaPath(File file) {
        String path;
        final String java = System.getProperty("java.home");
        final File marker = new File(file, "java.mark");
        if (marker != null && marker.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(marker));
                String javaVersion = br.readLine();
                if (javaVersion != null && javaVersion.equals(java)) {
                    return;
                }
            }
            catch (IOException javaVersion) {
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            path = file.getAbsolutePath();
        }
        final String rootPath = path;
        final RequestProcessor rp = new RequestProcessor();
        rp.post(new Runnable(){

            @Override
            public void run() {
                block13: {
                    try {
                        PostInstallJ2meAction.installAction(rootPath);
                        if (marker == null) break block13;
                        BufferedWriter bw = null;
                        try {
                            bw = new BufferedWriter(new FileWriter(marker));
                            bw.write(java);
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            if (bw != null) {
                                try {
                                    bw.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
                rp.stop();
            }
        }, 1000);
    }
}

