/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote;

import java.awt.Color;
import java.awt.EventQueue;
import java.io.Serializable;
import java.util.HashSet;
import java.util.ResourceBundle;
import org.netbeans.modules.mercurial.remote.FileStatus;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.util.common.VCSFileInformation;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.NbBundle;

public class FileInformation
extends VCSFileInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_NOTVERSIONED_NOTMANAGED = 1;
    public static final int STATUS_NOTVERSIONED_EXCLUDED = 2;
    public static final int STATUS_NOTVERSIONED_NEWLOCALLY = 4;
    public static final int STATUS_VERSIONED_UPTODATE = 8;
    public static final int STATUS_VERSIONED_MODIFIEDLOCALLY = 16;
    public static final int STATUS_VERSIONED_MODIFIEDINREPOSITORY = 32;
    public static final int STATUS_VERSIONED_CONFLICT = 64;
    public static final int STATUS_VERSIONED_MERGE = 128;
    public static final int STATUS_VERSIONED_REMOVEDLOCALLY = 256;
    public static final int STATUS_VERSIONED_NEWINREPOSITORY = 512;
    public static final int STATUS_VERSIONED_REMOVEDINREPOSITORY = 1024;
    public static final int STATUS_VERSIONED_DELETEDLOCALLY = 2048;
    public static final int STATUS_VERSIONED_ADDEDLOCALLY = 4096;
    public static final int STATUS_ALL = -1;
    public static final int STATUS_MANAGED = -2;
    public static final int STATUS_VERSIONED = 7672;
    public static final int STATUS_IN_REPOSITORY = 4088;
    public static final int STATUS_LOCAL_CHANGE = 6612;
    public static final int STATUS_REVERTIBLE_CHANGE = 6608;
    public static final int STATUS_REMOTE_CHANGE = 1696;
    private static final int STATUS_VERSIONED_REMOVED = 2304;
    private final int status;
    private transient FileStatus entry;
    private final boolean isDirectory;
    private final HashSet<VCSFileProxy> modifiedChildren = new HashSet();
    private final HashSet<VCSFileProxy> conflictedChildren = new HashSet();
    private boolean seenInUI;

    public FileInformation() {
        this.status = 0;
        this.isDirectory = false;
    }

    public FileInformation(int status, FileStatus entry, boolean isDirectory) {
        this.status = status;
        this.entry = entry;
        this.isDirectory = isDirectory;
        this.seenInUI = !isDirectory;
    }

    FileInformation(int status, boolean isDirectory) {
        this(status, null, isDirectory);
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public FileStatus getStatus(VCSFileProxy file) {
        return this.entry;
    }

    public String getStatusText() {
        return this.getStatusText(-1);
    }

    public String getStatusText(int displayStatuses) {
        int status = this.status & displayStatuses;
        ResourceBundle loc = NbBundle.getBundle(FileInformation.class);
        if (status == 0) {
            return loc.getString("CTL_FileInfoStatus_Unknown");
        }
        if (FileInformation.match(status, 2)) {
            return loc.getString("CTL_FileInfoStatus_Excluded");
        }
        if (FileInformation.match(status, 4)) {
            return loc.getString("CTL_FileInfoStatus_NewLocally");
        }
        if (FileInformation.match(status, 4096)) {
            if (this.entry != null && this.entry.isCopied()) {
                if (!EventQueue.isDispatchThread() && !this.entry.getOriginalFile().exists() || (Mercurial.getInstance().getFileStatusCache().getStatus(this.entry.getOriginalFile()).getStatus() & 0x900) != 0) {
                    if (this.entry.getOriginalFile().getParentFile().getPath().equals(this.entry.getFile().getParentFile().getPath())) {
                        return loc.getString("CTL_FileInfoStatus_AddedLocallyRenamed");
                    }
                    return loc.getString("CTL_FileInfoStatus_AddedLocallyMoved");
                }
                return loc.getString("CTL_FileInfoStatus_AddedLocallyCopied");
            }
            return loc.getString("CTL_FileInfoStatus_AddedLocally");
        }
        if (FileInformation.match(status, 8)) {
            return loc.getString("CTL_FileInfoStatus_UpToDate");
        }
        if (FileInformation.match(status, 64)) {
            return loc.getString("CTL_FileInfoStatus_Conflict");
        }
        if (FileInformation.match(status, 128)) {
            return loc.getString("CTL_FileInfoStatus_Merge");
        }
        if (FileInformation.match(status, 2048)) {
            return loc.getString("CTL_FileInfoStatus_DeletedLocally");
        }
        if (FileInformation.match(status, 256)) {
            return loc.getString("CTL_FileInfoStatus_RemovedLocally");
        }
        if (FileInformation.match(status, 16)) {
            return loc.getString("CTL_FileInfoStatus_ModifiedLocally");
        }
        if (FileInformation.match(status, 512)) {
            return loc.getString("CTL_FileInfoStatus_NewInRepository");
        }
        if (FileInformation.match(status, 32)) {
            return loc.getString("CTL_FileInfoStatus_ModifiedInRepository");
        }
        if (FileInformation.match(status, 1024)) {
            return loc.getString("CTL_FileInfoStatus_RemovedInRepository");
        }
        return "";
    }

    public String getShortStatusText() {
        ResourceBundle loc = NbBundle.getBundle(FileInformation.class);
        if (FileInformation.match(this.status, 2)) {
            return loc.getString("CTL_FileInfoStatus_Excluded_Short");
        }
        if (FileInformation.match(this.status, 4)) {
            return loc.getString("CTL_FileInfoStatus_NewLocally_Short");
        }
        if (FileInformation.match(this.status, 4096)) {
            if (this.entry != null && this.entry.isCopied()) {
                if (!EventQueue.isDispatchThread() && !this.entry.getOriginalFile().exists() || (Mercurial.getInstance().getFileStatusCache().getStatus(this.entry.getOriginalFile()).getStatus() & 0x900) != 0) {
                    if (this.entry.getOriginalFile().getParentFile().getPath().equals(this.entry.getFile().getParentFile().getPath())) {
                        return loc.getString("CTL_FileInfoStatus_AddedLocallyRenamed_Short");
                    }
                    return loc.getString("CTL_FileInfoStatus_AddedLocallyMoved_Short");
                }
                return loc.getString("CTL_FileInfoStatus_AddedLocallyCopied_Short");
            }
            return loc.getString("CTL_FileInfoStatus_AddedLocally_Short");
        }
        if (this.status == 256) {
            return loc.getString("CTL_FileInfoStatus_RemovedLocally_Short");
        }
        if (this.status == 2048) {
            return loc.getString("CTL_FileInfoStatus_DeletedLocally_Short");
        }
        if (FileInformation.match(this.status, 16)) {
            return loc.getString("CTL_FileInfoStatus_ModifiedLocally_Short");
        }
        if (FileInformation.match(this.status, 64)) {
            return loc.getString("CTL_FileInfoStatus_Conflict_Short");
        }
        return "";
    }

    private static boolean match(int status, int mask) {
        return (status & mask) != 0;
    }

    public String toString() {
        return "Text: " + this.status + " " + this.getStatusText(this.status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashSet<VCSFileProxy> getModifiedChildren(boolean onlyConflicted) {
        HashSet<VCSFileProxy> children;
        HashSet<VCSFileProxy> hashSet = this.modifiedChildren;
        synchronized (hashSet) {
            children = onlyConflicted ? new HashSet<VCSFileProxy>(this.conflictedChildren) : new HashSet<VCSFileProxy>(this.modifiedChildren);
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setModifiedChild(VCSFileProxy child, FileInformation newInfo) {
        if ((this.status & 1) != 0) {
            return false;
        }
        HashSet<VCSFileProxy> hashSet = this.modifiedChildren;
        synchronized (hashSet) {
            this.modifiedChildren.remove(child);
            this.conflictedChildren.remove(child);
            boolean followOnParent = this.modifiedChildren.isEmpty();
            if (newInfo.getStatus() != 0 && (newInfo.getStatus() & 8) == 0) {
                boolean testBeforeAdd = false;
                if (!$assertionsDisabled) {
                    testBeforeAdd = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (testBeforeAdd && this.modifiedChildren.size() > 0) {
                    VCSFileProxy alreadyAdded = this.modifiedChildren.iterator().next();
                    if (!child.getParentFile().equals((Object)alreadyAdded.getParentFile())) {
                        throw new IllegalStateException("Adding " + child.getPath() + ", already added " + alreadyAdded.getPath() + " under " + alreadyAdded.getParentFile().getPath());
                    }
                }
                this.modifiedChildren.add(child);
                if ((newInfo.getStatus() & 0x40) != 0) {
                    this.conflictedChildren.add(child);
                }
                followOnParent = true;
            }
            return followOnParent;
        }
    }

    boolean wasSeenInUi() {
        return this.seenInUI;
    }

    void setSeenInUI(boolean seenInUI) {
        this.seenInUI = seenInUI;
    }

    public int getComparableStatus() {
        return HgUtils.getComparableStatus(this.status);
    }

    public String annotateNameHtml(String name) {
        return Mercurial.getInstance().getMercurialAnnotator().annotateNameHtml(name, this, null);
    }

    public Color getAnnotatedColor() {
        return Mercurial.getInstance().getMercurialAnnotator().getAnnotatedColor(this);
    }
}

