/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.annotate;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.text.DateFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.annotate.AnnotateLine;
import org.netbeans.modules.mercurial.remote.ui.annotate.AnnotationBar;
import org.netbeans.modules.mercurial.remote.ui.annotate.Bundle;
import org.netbeans.modules.mercurial.remote.ui.log.LogAction;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.netbeans.modules.versioning.util.VCSHyperlinkSupport;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

class TooltipWindow
implements AWTEventListener,
MouseMotionListener,
MouseListener,
WindowFocusListener {
    private static final int SCREEN_BORDER = 20;
    private static final Color LINK_COLOR = UIManager.getColor("nb.html.link.foreground");
    private final AnnotationBar master;
    private JTextPane textPane;
    private final AnnotateLine annotateLine;
    private int messageOffset;
    private final VCSHyperlinkSupport linkerSupport = new VCSHyperlinkSupport();
    private JWindow contentWindow;
    private TooltipContentPanel cp;

    public TooltipWindow(AnnotationBar master, AnnotateLine al) {
        this.annotateLine = al;
        this.master = master;
    }

    public void show(Point location) {
        GraphicsDevice device;
        GraphicsConfiguration gc;
        GraphicsDevice[] gds;
        Rectangle screenBounds = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = gds = ge.getScreenDevices();
        int n = graphicsDeviceArray.length;
        for (int i = 0; i < n && !(screenBounds = (gc = (device = graphicsDeviceArray[i]).getDefaultConfiguration()).getBounds()).contains(location); ++i) {
        }
        this.cp = new TooltipContentPanel(this.master.getTextComponent());
        Window w = SwingUtilities.windowForComponent(this.master.getTextComponent());
        this.contentWindow = new JWindow(w);
        this.contentWindow.add(this.cp);
        this.contentWindow.pack();
        Dimension dim = this.contentWindow.getSize();
        if (location.y + dim.height + 20 > screenBounds.y + screenBounds.height) {
            dim.height = screenBounds.y + screenBounds.height - (location.y + 20);
        }
        if (location.x + dim.width + 20 > screenBounds.x + screenBounds.width) {
            dim.width = screenBounds.x + screenBounds.width - (location.x + 20);
        }
        this.contentWindow.setSize(dim);
        this.contentWindow.setLocation(location.x, location.y - 1);
        this.contentWindow.setVisible(true);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
        w.addWindowFocusListener(this);
        this.contentWindow.addWindowFocusListener(this);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getID() == 501 || event.getID() == 401) {
            this.onClick(event);
        }
    }

    private void onClick(AWTEvent event) {
        Component component = (Component)event.getSource();
        if (this.outsideOfTooltipWindow(component)) {
            this.shutdown();
        }
    }

    private boolean outsideOfTooltipWindow(Component component) {
        boolean retval = true;
        while (component != null) {
            if (component instanceof TooltipContentPanel) {
                retval = false;
                break;
            }
            component = component.getParent();
        }
        return retval;
    }

    void shutdown() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.contentWindow != null) {
            this.contentWindow.getOwner().removeWindowFocusListener(this);
            this.contentWindow.removeWindowFocusListener(this);
            this.contentWindow.dispose();
        }
        this.contentWindow = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getSource().equals(this.textPane)) {
            this.textPane.setCursor(Cursor.getPredefinedCursor(0));
            this.linkerSupport.computeBounds(this.textPane, 0);
            this.linkerSupport.mouseMoved(e.getPoint(), (JComponent)this.textPane, this.messageOffset);
        }
        this.textPane.setToolTipText("");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource().equals(this.textPane)) {
            this.linkerSupport.computeBounds(this.textPane, 0);
            if (this.linkerSupport.mouseClicked(e.getPoint(), 0)) {
                this.shutdown();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (this.contentWindow != null && e.getOppositeWindow() == null) {
            this.shutdown();
        }
    }

    private static class RevisionLinker
    extends VCSHyperlinkSupport.StyledDocumentHyperlink {
        private final String revision;
        private final int docstart;
        private final int docend;
        private Rectangle bounds;
        private final VCSFileProxy repository;
        private final VCSFileProxy root;
        private final String changeset;
        private final String toInsert;

        public RevisionLinker(String revision, String changeset, StyledDocument sd, VCSFileProxy repository, VCSFileProxy root) {
            this.revision = revision;
            this.changeset = changeset;
            this.repository = repository;
            this.root = root;
            this.toInsert = revision + ":" + changeset;
            int doclen = sd.getLength();
            int textlen = this.toInsert.length();
            this.docstart = doclen;
            this.docend = doclen + textlen;
        }

        public void insertString(StyledDocument sd, Style style) throws BadLocationException {
            sd.insertString(sd.getLength(), this.toInsert, style);
        }

        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null && this.bounds.contains(p)) {
                component.setCursor(Cursor.getPredefinedCursor(12));
                component.setToolTipText(Bundle.CTL_AnnotationBar_action_showCommit(this.revision));
                return true;
            }
            return false;
        }

        public boolean mouseClicked(Point p) {
            if (this.bounds != null && this.bounds.contains(p)) {
                LogAction.openHistory(this.repository, new VCSFileProxy[]{this.root}, this.changeset);
                return true;
            }
            return false;
        }

        public void computeBounds(JTextPane textPane) {
            Rectangle tpBounds = textPane.getBounds();
            TextUI tui = textPane.getUI();
            this.bounds = new Rectangle();
            try {
                Rectangle startr = tui.modelToView(textPane, this.docstart, Position.Bias.Forward).getBounds();
                Rectangle endr = tui.modelToView(textPane, this.docend, Position.Bias.Backward).getBounds();
                this.bounds = new Rectangle(tpBounds.x + startr.x, startr.y, endr.x - startr.x, startr.height);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class TooltipContentPanel
    extends JComponent {
        public TooltipContentPanel(JTextComponent parentPane) {
            try {
                TooltipWindow.this.textPane = new JTextPane();
                StyledDocument doc = (StyledDocument)TooltipWindow.this.textPane.getDocument();
                Style normalStyle = TooltipWindow.this.textPane.getStyle("normal");
                Style hyperlinkStyle = TooltipWindow.this.textPane.addStyle("hyperlink", normalStyle);
                StyleConstants.setForeground(hyperlinkStyle, LINK_COLOR == null ? Color.BLUE : LINK_COLOR);
                StyleConstants.setUnderline(hyperlinkStyle, true);
                Style authorStyle = TooltipWindow.this.textPane.addStyle("author", normalStyle);
                StyleConstants.setForeground(authorStyle, LINK_COLOR == null ? Color.BLUE : LINK_COLOR);
                String revisionNumber = TooltipWindow.this.annotateLine.getRevision();
                String changesetId = TooltipWindow.this.annotateLine.getId();
                RevisionLinker l = new RevisionLinker(revisionNumber, changesetId, doc, TooltipWindow.this.master.getRepositoryRoot(), TooltipWindow.this.master.getCurrentFile());
                TooltipWindow.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l, 0);
                l.insertString(doc, hyperlinkStyle);
                doc.insertString(doc.getLength(), " - ", normalStyle);
                String author = TooltipWindow.this.annotateLine.getAuthor();
                VCSHyperlinkSupport.StyledDocumentHyperlink l2 = (VCSHyperlinkSupport.StyledDocumentHyperlink)TooltipWindow.this.linkerSupport.getLinker(VCSHyperlinkSupport.AuthorLinker.class, 0);
                if (l2 != null) {
                    l2.insertString(doc, authorStyle);
                } else {
                    doc.insertString(doc.getLength(), author, normalStyle);
                }
                doc.insertString(doc.getLength(), " ", normalStyle);
                doc.insertString(doc.getLength(), DateFormat.getDateInstance().format(TooltipWindow.this.annotateLine.getDate()), normalStyle);
                doc.insertString(doc.getLength(), "\n", normalStyle);
                VCSHyperlinkSupport.IssueLinker l3 = null;
                String commitMessage = TooltipWindow.this.annotateLine.getCommitMessage();
                List<VCSHyperlinkProvider> providers = Mercurial.getInstance().getHyperlinkProviders();
                for (VCSHyperlinkProvider hp : providers) {
                    l3 = VCSHyperlinkSupport.IssueLinker.create((VCSHyperlinkProvider)hp, (Style)hyperlinkStyle, null, (StyledDocument)doc, (String)commitMessage);
                    if (l3 == null) continue;
                    TooltipWindow.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l3, 0);
                    break;
                }
                if (l3 != null) {
                    l3.insertString(doc, normalStyle);
                } else {
                    doc.insertString(doc.getLength(), commitMessage, normalStyle);
                }
                TooltipWindow.this.textPane.setDocument(doc);
                TooltipWindow.this.textPane.setEditable(false);
                Color color = UIManager.getColor("nb.versioning.tooltip.background.color");
                if (null == color) {
                    color = new Color(233, 241, 255);
                }
                TooltipWindow.this.textPane.setBackground(color);
                Element rootElement = NbDocument.findLineRootElement((StyledDocument)doc);
                int lineCount = rootElement.getElementCount();
                int height = TooltipWindow.this.textPane.getFontMetrics(TooltipWindow.this.textPane.getFont()).getHeight() * (lineCount + 1);
                int maxWidth = 0;
                for (int line = 0; line < lineCount; ++line) {
                    Element lineElement = rootElement.getElement(line);
                    String text = null;
                    try {
                        text = doc.getText(lineElement.getStartOffset(), lineElement.getEndOffset() - lineElement.getStartOffset());
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                    int lineLength = TooltipWindow.this.textPane.getFontMetrics(TooltipWindow.this.textPane.getFont()).stringWidth(text);
                    if (lineLength <= maxWidth) continue;
                    maxWidth = lineLength;
                }
                if (maxWidth < 50) {
                    maxWidth = 50;
                }
                TooltipWindow.this.textPane.setPreferredSize(new Dimension(maxWidth * 7 / 6, height));
                if (!TooltipWindow.this.textPane.isEditable()) {
                    TooltipWindow.this.textPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
                }
                TooltipWindow.this.textPane.addMouseListener(TooltipWindow.this);
                TooltipWindow.this.textPane.addMouseMotionListener(TooltipWindow.this);
                JScrollPane jsp = new JScrollPane(TooltipWindow.this.textPane);
                jsp.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
                this.setLayout(new BorderLayout());
                this.add(jsp);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

